/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.SimpleManagement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionAddressType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerSource;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorMessageFactory;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPReplicaTest
extends AmqpClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final int AMQP_PORT_2 = 5673;
    protected static final int AMQP_PORT_3 = 5674;
    public static final int TIME_BEFORE_RESTART = 1000;
    ActiveMQServer server_2;
    private AssertionLoggerHandler loggerHandler;

    @BeforeEach
    public void startLogging() {
        this.loggerHandler = new AssertionLoggerHandler();
    }

    @AfterEach
    public void stopLogging() throws Exception {
        try {
            Assertions.assertFalse((boolean)this.loggerHandler.findText(new String[]{"AMQ222214"}));
        }
        finally {
            this.loggerHandler.close();
        }
    }

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,OPENWIRE,CORE";
    }

    @Override
    protected ActiveMQServer createServer() throws Exception {
        return this.createServer(5672, false);
    }

    @Test
    public void testReplicaCatchupOnQueueCreates() throws Exception {
        this.server.setIdentity("Server1");
        this.server.stop();
        this.server_2 = this.createServer(5673, false);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672");
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.start();
        this.server_2.addAddressInfo(new AddressInfo("sometest").setAutoCreated(false));
        this.server_2.createQueue(QueueConfiguration.of((String)"sometest").setDurable(Boolean.valueOf(true)));
        Wait.assertTrue(() -> this.server_2.locateQueue("sometest") != null);
        this.server_2.stop();
        this.server.start();
        Assertions.assertTrue((this.server.locateQueue("sometest") == null ? 1 : 0) != 0);
        Wait.assertTrue(() -> ((ActiveMQServer)this.server).isActive());
        this.server_2.start();
        Wait.assertTrue(() -> this.server.locateQueue("sometest") != null);
        this.server_2.stop();
        this.server.stop();
    }

    @Test
    public void testNotFoundRetries() throws Exception {
        this.server.setIdentity("Server1");
        this.server.start();
        this.server_2 = this.createServer(5673, false);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672");
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.start();
        this.server_2.addAddressInfo(new AddressInfo("sometest").setAutoCreated(false));
        this.server_2.createQueue(QueueConfiguration.of((String)"sometest").setDurable(Boolean.valueOf(true)));
        Wait.assertTrue(() -> this.server_2.locateQueue("sometest") != null);
        Wait.waitFor(() -> this.server_2.locateQueue("$ACTIVEMQ_ARTEMIS_MIRROR_test") != null);
        Queue mirrorQueue = this.server_2.locateQueue("$ACTIVEMQ_ARTEMIS_MIRROR_test");
        Assertions.assertNotNull((Object)mirrorQueue);
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            org.apache.activemq.artemis.api.core.Message message = AMQPMirrorMessageFactory.createMessage((String)mirrorQueue.getAddress().toString(), (SimpleString)SimpleString.of((String)"sometest"), (SimpleString)SimpleString.of((String)"sometest"), (Object)AMQPMirrorControllerSource.POST_ACK, (String)"0000", (Object)3333L, (AckReason)AckReason.EXPIRED).setDurable(true);
            message.setMessageID(this.server_2.getStorageManager().generateID());
            this.server_2.getPostOffice().route(message, false);
            message = AMQPMirrorMessageFactory.createMessage((String)mirrorQueue.getAddress().toString(), (SimpleString)SimpleString.of((String)"sometest"), (SimpleString)SimpleString.of((String)"sometest"), (Object)AMQPMirrorControllerSource.POST_ACK, (String)"0000", (Object)3334L, (AckReason)AckReason.NORMAL).setDurable(true);
            message.setMessageID(this.server_2.getStorageManager().generateID());
            this.server_2.getPostOffice().route(message, false);
            Wait.assertEquals((Long)0L, () -> ((Queue)mirrorQueue).getMessageCount(), (long)2000L, (long)100L);
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ224041"}));
        }
        this.server_2.stop();
        this.server.stop();
    }

    @Test
    public void testDeleteQueueWithRemoveFalse() throws Exception {
        this.server.setIdentity("Server1");
        this.server.start();
        this.server_2 = this.createServer(5673, false);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672");
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setQueueRemoval(false));
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.start();
        SimpleString queueName = RandomUtil.randomSimpleString();
        this.server_2.addAddressInfo(new AddressInfo(queueName).setAutoCreated(false));
        this.server_2.createQueue(QueueConfiguration.of((SimpleString)queueName).setDurable(Boolean.valueOf(true)));
        Wait.assertTrue(() -> this.server_2.locateQueue(queueName) != null);
        Wait.assertTrue(() -> this.server.locateQueue(queueName) != null);
        this.server_2.destroyQueue(queueName);
        Wait.assertTrue(() -> this.server_2.locateQueue(queueName) == null);
        Thread.sleep(100L);
        Assertions.assertTrue((this.server.locateQueue(queueName) != null ? 1 : 0) != 0, (String)"Queue was removed when it was configured to not remove it");
        this.server_2.stop();
        this.server.stop();
    }

    @Test
    public void testSendCreateQueue() throws Exception {
        this.doSendCreateQueueTestImpl(true);
    }

    @Test
    public void testDoNotSendCreateQueue() throws Exception {
        this.doSendCreateQueueTestImpl(false);
    }

    private void doSendCreateQueueTestImpl(boolean sendCreate) throws Exception {
        this.server.start();
        SimpleString ADDRESS_NAME = SimpleString.of((String)"address");
        this.server_2 = this.createServer(5673, false);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672");
        AMQPMirrorBrokerConnectionElement mirror = new AMQPMirrorBrokerConnectionElement();
        if (sendCreate) {
            mirror.setQueueCreation(true);
            mirror.setQueueRemoval(false);
        } else {
            mirror.setQueueCreation(false);
        }
        amqpConnection.addElement((AMQPBrokerConnectionElement)mirror);
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.start();
        Wait.assertTrue(() -> ((ActiveMQServer)this.server).isActive());
        this.server_2.addAddressInfo(new AddressInfo(ADDRESS_NAME).addRoutingType(RoutingType.ANYCAST));
        this.server_2.createQueue(QueueConfiguration.of((SimpleString)ADDRESS_NAME).setDurable(Boolean.valueOf(true)).setAddress(ADDRESS_NAME));
        if (sendCreate) {
            Wait.assertTrue(() -> this.server.locateQueue(ADDRESS_NAME) != null);
            Wait.assertTrue(() -> this.server.getAddressInfo(ADDRESS_NAME) != null);
        } else {
            Thread.sleep(250L);
            Assertions.assertTrue((this.server.locateQueue(ADDRESS_NAME) == null ? 1 : 0) != 0);
            Assertions.assertTrue((this.server.getAddressInfo(ADDRESS_NAME) == null ? 1 : 0) != 0);
        }
        this.server_2.stop();
        this.server.stop();
    }

    @Test
    public void testReplicaCatchupOnQueueCreatesAndDeletes() throws Exception {
        this.server.start();
        this.server.setIdentity("Server1");
        this.server.addAddressInfo(new AddressInfo("sometest").setAutoCreated(false).addRoutingType(RoutingType.MULTICAST));
        this.server.createQueue(QueueConfiguration.of((String)"ToBeGone").setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.MULTICAST));
        this.server.stop();
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("server_2");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672");
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.start();
        this.server_2.addAddressInfo(new AddressInfo("sometest").setAutoCreated(false).addRoutingType(RoutingType.MULTICAST));
        this.server_2.createQueue(QueueConfiguration.of((String)"sometest").setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.MULTICAST));
        Wait.assertTrue(() -> this.server_2.locateQueue("sometest") != null);
        this.server_2.stop();
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("server_2");
        amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672");
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.start();
        Assertions.assertTrue((this.server.locateQueue("sometest") == null ? 1 : 0) != 0);
        Assertions.assertTrue((this.server.locateQueue("ToBeGone") != null ? 1 : 0) != 0);
        Wait.assertTrue(() -> ((ActiveMQServer)this.server).isActive());
        this.server_2.start();
        Wait.assertTrue(() -> this.server.locateQueue("sometest") != null);
        this.server_2.stop();
        this.server.stop();
    }

    @Test
    public void testReplicaWithDurable() throws Exception {
        this.server.start();
        this.server.setIdentity("Server1");
        this.server.addAddressInfo(new AddressInfo("sometest").setAutoCreated(false).addRoutingType(RoutingType.MULTICAST));
        this.server.stop();
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("server_2");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672");
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.start();
        this.server_2.addAddressInfo(new AddressInfo("sometest").setAutoCreated(false).addRoutingType(RoutingType.MULTICAST));
        this.server_2.createQueue(QueueConfiguration.of((String)"sometest").setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.MULTICAST));
        Wait.assertTrue(() -> this.server_2.locateQueue("sometest") != null);
        this.server_2.stop();
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("server_2");
        amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672");
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.start();
        Assertions.assertTrue((this.server.locateQueue("sometest") == null ? 1 : 0) != 0);
        Wait.assertTrue(() -> ((ActiveMQServer)this.server).isActive());
        this.server_2.start();
        Wait.assertTrue(() -> this.server.locateQueue("sometest") != null);
        this.server_2.stop();
        this.server.stop();
    }

    @Test
    public void testReplicaLargeMessages() throws Exception {
        this.replicaTest(true, true, false, false, false, false, false);
    }

    @Test
    public void testReplicaLargeMessagesPagingEverywhere() throws Exception {
        this.replicaTest(true, true, true, true, false, false, false);
    }

    @Test
    public void testReplica() throws Exception {
        this.replicaTest(false, true, false, false, false, false, false);
    }

    @Test
    public void testReplicaRestartBrokerConnection() throws Exception {
        this.replicaTest(false, true, false, false, false, false, true);
    }

    @Test
    public void testReplicaRestart() throws Exception {
        this.replicaTest(false, true, false, false, false, true, false);
    }

    @Test
    public void testReplicaDeferredStart() throws Exception {
        this.replicaTest(false, true, false, false, true, false, false);
    }

    @Test
    public void testReplicaCopyOnly() throws Exception {
        this.replicaTest(false, false, false, false, false, false, false);
    }

    @Test
    public void testReplicaPagedTarget() throws Exception {
        this.replicaTest(false, true, true, false, false, false, false);
    }

    @Test
    public void testReplicaPagingEverywhere() throws Exception {
        this.replicaTest(false, true, true, true, false, false, false);
    }

    private String getText(boolean large, int i) {
        if (!large) {
            return "Text " + i;
        }
        StringBuffer buffer = new StringBuffer();
        while (buffer.length() < 112640) {
            buffer.append("Text " + i + " ");
        }
        return buffer.toString();
    }

    @Test
    public void testLargeMessagesWithDeliveryAnnotations() throws Exception {
        int i;
        this.server.setIdentity("targetServer");
        this.server.start();
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("server_2");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100);
        AMQPMirrorBrokerConnectionElement replica = new AMQPMirrorBrokerConnectionElement().setMessageAcknowledgements(true);
        amqpConnection.addElement((AMQPBrokerConnectionElement)replica);
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        int NUMBER_OF_MESSAGES = 20;
        this.server_2.start();
        Wait.assertTrue(() -> ((ActiveMQServer)this.server_2).isStarted());
        this.server_2.addAddressInfo(new AddressInfo(this.getQueueName()).addRoutingType(RoutingType.ANYCAST).setAutoCreated(false));
        this.server_2.createQueue(QueueConfiguration.of((String)this.getQueueName()).setRoutingType(RoutingType.ANYCAST).setAddress(this.getQueueName()).setAutoCreated(Boolean.valueOf(false)));
        Assertions.assertFalse((boolean)this.loggerHandler.findText(new String[]{"AMQ222214"}));
        Queue queueView = this.locateQueue(this.server_2, this.getQueueName());
        Queue queueViewReplica = this.locateQueue(this.server_2, this.getQueueName());
        AmqpClient client = new AmqpClient(new URI("tcp://localhost:5673"), null, null);
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        for (i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setDeliveryAnnotation("gone", "test");
            message.setText(this.getText(true, i));
            sender.send(message);
        }
        sender.close();
        connection.close();
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueView).getMessageCount());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueViewReplica).getMessageCount());
        client = new AmqpClient(new URI("tcp://localhost:5672"), null, null);
        connection = this.addConnection(client.connect());
        session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(NUMBER_OF_MESSAGES + 1);
        for (i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)received);
            Assertions.assertEquals((Object)this.getText(true, i), (Object)received.getText());
            Assertions.assertNull((Object)received.getDeliveryAnnotation("gone"));
        }
        Assertions.assertNull((Object)receiver.receiveNoWait());
        connection.close();
    }

    @Test
    public void testNoAddressWithAnnotations() throws Exception {
        int i;
        this.server.setIdentity("targetServer");
        this.server.start();
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("server_2");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100);
        AMQPMirrorBrokerConnectionElement replica = new AMQPMirrorBrokerConnectionElement().setMessageAcknowledgements(true);
        amqpConnection.addElement((AMQPBrokerConnectionElement)replica);
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        int NUMBER_OF_MESSAGES = 20;
        this.server_2.start();
        Wait.assertTrue(() -> ((ActiveMQServer)this.server_2).isStarted());
        this.server_2.addAddressInfo(new AddressInfo(this.getQueueName()).addRoutingType(RoutingType.ANYCAST).setAutoCreated(false));
        this.server_2.createQueue(QueueConfiguration.of((String)this.getQueueName()).setRoutingType(RoutingType.ANYCAST).setAddress(this.getQueueName()).setAutoCreated(Boolean.valueOf(false)));
        Assertions.assertFalse((boolean)this.loggerHandler.findText(new String[]{"AMQ222214"}));
        AmqpClient client = new AmqpClient(new URI("tcp://localhost:5673"), null, null);
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        for (i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setDeliveryAnnotation("gone", "test");
            message.setText(this.getText(false, i));
            sender.send(message);
        }
        sender.close();
        connection.close();
        client = new AmqpClient(new URI("tcp://localhost:5672"), null, null);
        connection = this.addConnection(client.connect());
        session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(NUMBER_OF_MESSAGES + 1);
        for (i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)received);
            Assertions.assertEquals((Object)this.getText(false, i), (Object)received.getText());
            Assertions.assertNull((Object)received.getDeliveryAnnotation("gone"));
        }
        Assertions.assertNull((Object)receiver.receiveNoWait());
        connection.close();
    }

    @Test
    public void testAddressFilter() throws Exception {
        String REPLICATED = "replicated";
        String NON_REPLICATED = "nonReplicated";
        String ADDRESS_FILTER = "replicated,!nonReplicated";
        String MSG = "msg";
        this.server.start();
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("server_2");
        this.server_2.getConfiguration().setName("server_2");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("mirror-source", "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100);
        AMQPMirrorBrokerConnectionElement replica = new AMQPMirrorBrokerConnectionElement().setDurable(true).setAddressFilter("replicated,!nonReplicated");
        amqpConnection.addElement((AMQPBrokerConnectionElement)replica);
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.start();
        try (Connection connection = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673").createConnection();){
            int i;
            Session session = connection.createSession(false, 1);
            try (MessageProducer producer = session.createProducer((Destination)session.createQueue("nonReplicated"));){
                producer.setDeliveryMode(2);
                for (i = 0; i < 2; ++i) {
                    producer.send((Message)session.createTextMessage("never receive"));
                }
            }
            Assertions.assertEquals((long)0L, (long)this.server_2.locateQueue(replica.getMirrorSNF()).getMessagesAdded());
            producer = session.createProducer((Destination)session.createQueue("replicated"));
            try {
                producer.setDeliveryMode(2);
                for (i = 0; i < 2; ++i) {
                    producer.send((Message)session.createTextMessage("msg"));
                }
            }
            finally {
                if (producer != null) {
                    producer.close();
                }
            }
            Assertions.assertTrue((this.server_2.locateQueue(replica.getMirrorSNF()).getMessagesAdded() > 0L ? 1 : 0) != 0);
        }
        SimpleManagement simpleManagement = new SimpleManagement("tcp://localhost:5673", null, null);
        Wait.assertEquals((long)0L, () -> simpleManagement.getMessageCountOnQueue("$ACTIVEMQ_ARTEMIS_MIRROR_mirror-source"), (long)5000L);
        try (Connection connection = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672").createConnection();){
            connection.start();
            Session session = connection.createSession(false, 1);
            try (MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("replicated"));){
                Message message = consumer.receive(3000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((Object)"msg", (Object)message.getBody(String.class));
            }
            consumer = session.createConsumer((Destination)session.createQueue("nonReplicated"));
            try {
                Assertions.assertNull((Object)consumer.receiveNoWait());
            }
            finally {
                if (consumer != null) {
                    consumer.close();
                }
            }
        }
    }

    @Test
    public void testRouteSurviving() throws Exception {
        this.testRouteSurvivor(false);
    }

    @Test
    public void testRouteSurvivingStop() throws Exception {
        this.testRouteSurvivor(true);
    }

    private void testRouteSurvivor(boolean server1Stopped) throws Exception {
        if (!server1Stopped) {
            this.server.start();
        }
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("server_2");
        this.server_2.getConfiguration().setName("thisone");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("OtherSide", "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100);
        AMQPMirrorBrokerConnectionElement replica = new AMQPMirrorBrokerConnectionElement().setDurable(true);
        amqpConnection.addElement((AMQPBrokerConnectionElement)replica);
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.start();
        this.server_2.addAddressInfo(new AddressInfo(this.getQueueName()).addRoutingType(RoutingType.ANYCAST).setAutoCreated(false));
        this.server_2.createQueue(QueueConfiguration.of((String)this.getQueueName()).setRoutingType(RoutingType.ANYCAST).setAddress(this.getQueueName()).setAutoCreated(Boolean.valueOf(false)));
        int NUMBER_OF_MESSAGES = 200;
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)session.createQueue(this.getQueueName()));
        producer.setDeliveryMode(2);
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            producer.send((Message)session.createTextMessage("i=" + i));
        }
        connection.close();
        if (!server1Stopped) {
            Wait.assertTrue(() -> this.server.locateQueue(this.getQueueName()) != null);
            Queue queueServer1 = this.server.locateQueue(this.getQueueName());
            Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueServer1).getMessageCount());
        }
        Wait.assertTrue(() -> this.server_2.locateQueue(this.getQueueName()) != null);
        Queue queueServer2 = this.server_2.locateQueue(this.getQueueName());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueServer2).getMessageCount());
        if (!server1Stopped) {
            this.server.stop();
        }
        this.server_2.stop();
        this.server.start();
        this.server_2.start();
        Wait.assertTrue(() -> this.server.locateQueue(this.getQueueName()) != null);
        Wait.assertTrue(() -> this.server_2.locateQueue(this.getQueueName()) != null);
        Queue queueServer1 = this.server.locateQueue(this.getQueueName());
        Queue queueServer22 = this.server_2.locateQueue(this.getQueueName());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueServer1).getMessageCount());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueServer22).getMessageCount());
    }

    private void replicaTest(boolean largeMessage, boolean acks, boolean pagingTarget, boolean pagingSource, boolean deferredStart, boolean restartAndDisconnect, boolean restartBrokerConnection) throws Exception {
        Queue queueOnServer1;
        String brokerConnectionName = "brokerConnectionName:" + UUIDGenerator.getInstance().generateStringUUID();
        this.server.setIdentity("targetServer");
        if (deferredStart) {
            this.server.stop();
        } else {
            this.server.start();
        }
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("server_2");
        this.server_2.getConfiguration().setName("thisone");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(brokerConnectionName, "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100);
        AMQPMirrorBrokerConnectionElement replica = new AMQPMirrorBrokerConnectionElement().setMessageAcknowledgements(acks).setDurable(true);
        replica.setName("theReplica");
        amqpConnection.addElement((AMQPBrokerConnectionElement)replica);
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.getConfiguration().setName("server_2");
        int NUMBER_OF_MESSAGES = 200;
        this.server_2.start();
        Wait.assertTrue(() -> ((ActiveMQServer)this.server_2).isStarted());
        this.server_2.addAddressInfo(new AddressInfo(this.getQueueName()).addRoutingType(RoutingType.ANYCAST).setAutoCreated(false));
        this.server_2.createQueue(QueueConfiguration.of((String)this.getQueueName()).setRoutingType(RoutingType.ANYCAST).setAddress(this.getQueueName()).setAutoCreated(Boolean.valueOf(false)));
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)session.createQueue(this.getQueueName()));
        if (!deferredStart) {
            Queue queueOnServer12 = this.locateQueue(this.server, this.getQueueName());
            if (pagingTarget) {
                queueOnServer12.getPagingStore().startPaging();
            }
        }
        if (pagingSource) {
            Queue queueOnServer2 = this.server_2.locateQueue(this.getQueueName());
            queueOnServer2.getPagingStore().startPaging();
        }
        Assertions.assertFalse((boolean)this.loggerHandler.findText(new String[]{"AMQ222214"}));
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            TextMessage message = session.createTextMessage(this.getText(largeMessage, i));
            message.setIntProperty("i", i);
            producer.send((Message)message);
        }
        Assertions.assertFalse((boolean)this.loggerHandler.findText(new String[]{"AMQ222214"}));
        if (deferredStart) {
            Thread.sleep(1000L);
            this.server.start();
            Wait.assertTrue(() -> ((ActiveMQServer)this.server).isActive());
            queueOnServer1 = this.locateQueue(this.server, this.getQueueName());
            if (pagingTarget) {
                queueOnServer1.getPagingStore().startPaging();
            }
        } else {
            queueOnServer1 = this.locateQueue(this.server, this.getQueueName());
        }
        Queue snfreplica = this.server_2.locateQueue(replica.getMirrorSNF());
        Assertions.assertNotNull((Object)snfreplica);
        Wait.assertEquals((long)0L, () -> ((Queue)snfreplica).getMessageCount());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueOnServer1).getMessageCount(), (long)2000L);
        Queue queueOnServer2 = this.locateQueue(this.server_2, this.getQueueName());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueOnServer1).getMessageCount());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueOnServer2).getMessageCount());
        if (restartBrokerConnection) {
            this.server_2.stopBrokerConnection(brokerConnectionName);
            Thread.sleep(1000L);
            this.server_2.startBrokerConnection(brokerConnectionName);
        }
        Assertions.assertSame((Object)snfreplica, (Object)this.server_2.locateQueue(replica.getMirrorSNF()));
        if (pagingTarget) {
            Assertions.assertTrue((boolean)queueOnServer1.getPagingStore().isPaging());
        }
        if (acks) {
            this.consumeMessages(largeMessage, 0, NUMBER_OF_MESSAGES / 2 - 1, 5673, false);
            Wait.assertEquals((long)0L, () -> ((Queue)snfreplica).getMessageCount());
            Wait.assertEquals((long)(NUMBER_OF_MESSAGES / 2), () -> ((Queue)queueOnServer1).getMessageCount());
            this.consumeMessages(largeMessage, NUMBER_OF_MESSAGES / 2, NUMBER_OF_MESSAGES - 1, 5672, true);
            Wait.assertEquals((long)0L, () -> ((Queue)snfreplica).getMessageCount());
            this.consumeMessages(largeMessage, NUMBER_OF_MESSAGES / 2, NUMBER_OF_MESSAGES - 1, 5673, false);
            Wait.assertEquals((long)0L, () -> ((Queue)snfreplica).getMessageCount());
            if (largeMessage) {
                this.validateNoFilesOnLargeDir(this.server.getConfiguration().getLargeMessagesDirectory(), 0);
            }
        } else {
            this.consumeMessages(largeMessage, 0, NUMBER_OF_MESSAGES - 1, 5673, true);
            Wait.assertEquals((long)0L, () -> ((Queue)snfreplica).getMessageCount());
            this.consumeMessages(largeMessage, 0, NUMBER_OF_MESSAGES - 1, 5672, true);
            Wait.assertEquals((long)0L, () -> ((Queue)snfreplica).getMessageCount());
            if (largeMessage) {
                this.validateNoFilesOnLargeDir(this.server.getConfiguration().getLargeMessagesDirectory(), 0);
                this.validateNoFilesOnLargeDir(this.server_2.getConfiguration().getLargeMessagesDirectory(), 0);
            }
        }
        if (restartAndDisconnect) {
            this.server.stop();
            Thread.sleep(1000L);
            this.server.start();
            Wait.assertTrue(() -> ((ActiveMQServer)this.server).isActive());
            this.consumeMessages(largeMessage, 0, -1, 5673, true);
            this.consumeMessages(largeMessage, 0, -1, 5672, true);
            for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
                TextMessage message = session.createTextMessage(this.getText(largeMessage, i));
                message.setIntProperty("i", i);
                producer.send((Message)message);
            }
            this.consumeMessages(largeMessage, 0, NUMBER_OF_MESSAGES - 1, 5672, true);
            this.consumeMessages(largeMessage, 0, NUMBER_OF_MESSAGES - 1, 5673, true);
        }
    }

    @Test
    public void testDualStandardRestartBrokerConnection() throws Exception {
        this.dualReplica(false, false, false, true);
    }

    @Test
    public void testDualStandard() throws Exception {
        this.dualReplica(false, false, false, false);
    }

    @Test
    public void testDualRegularPagedTargets() throws Exception {
        this.dualReplica(false, false, true, false);
    }

    @Test
    public void testDualRegularPagedEverything() throws Exception {
        this.dualReplica(false, true, true, false);
    }

    @Test
    public void testDualRegularLarge() throws Exception {
        this.dualReplica(true, false, false, false);
    }

    public Queue locateQueue(ActiveMQServer server, String queueName) throws Exception {
        Assertions.assertNotNull((Object)queueName);
        Assertions.assertNotNull((Object)server);
        Wait.waitFor(() -> server.locateQueue(queueName) != null);
        return server.locateQueue(queueName);
    }

    private void dualReplica(boolean largeMessage, boolean pagingSource, boolean pagingTarget, boolean restartBC) throws Exception {
        this.server.setIdentity("server_1");
        this.server.start();
        ActiveMQServer server_3 = this.createServer(5674, false);
        server_3.setIdentity("server_3");
        server_3.start();
        Wait.assertTrue(() -> ((ActiveMQServer)server_3).isStarted());
        ConnectionFactory factory_3 = CFUtil.createConnectionFactory("amqp", "tcp://localhost:5674");
        factory_3.createConnection().close();
        this.server_2 = this.createServer(5673, false);
        String brokerConnectionOne = "brokerConnection1:" + UUIDGenerator.getInstance().generateStringUUID();
        String brokerConnectionTwo = "brokerConnection2:" + UUIDGenerator.getInstance().generateStringUUID();
        AMQPBrokerConnectConfiguration amqpConnection1 = new AMQPBrokerConnectConfiguration(brokerConnectionOne, "tcp://localhost:5672");
        AMQPMirrorBrokerConnectionElement replica1 = new AMQPMirrorBrokerConnectionElement().setType(AMQPBrokerConnectionAddressType.MIRROR);
        amqpConnection1.addElement((AMQPBrokerConnectionElement)replica1);
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection1);
        AMQPBrokerConnectConfiguration amqpConnection3 = new AMQPBrokerConnectConfiguration(brokerConnectionTwo, "tcp://localhost:5674");
        AMQPMirrorBrokerConnectionElement replica2 = new AMQPMirrorBrokerConnectionElement().setType(AMQPBrokerConnectionAddressType.MIRROR);
        amqpConnection3.addElement((AMQPBrokerConnectionElement)replica2);
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection3);
        int NUMBER_OF_MESSAGES = 200;
        this.server_2.start();
        Wait.assertTrue(() -> ((ActiveMQServer)this.server_2).isStarted());
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)session.createQueue(this.getQueueName()));
        producer.setDeliveryMode(2);
        Queue queue_server_2 = this.locateQueue(this.server_2, this.getQueueName());
        Queue queue_server_1 = this.locateQueue(this.server, this.getQueueName());
        Queue queue_server_3 = this.locateQueue(server_3, this.getQueueName());
        if (pagingSource) {
            queue_server_2.getPagingStore().startPaging();
        }
        if (pagingTarget) {
            queue_server_1.getPagingStore().startPaging();
            queue_server_3.getPagingStore().startPaging();
        }
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            TextMessage message = session.createTextMessage(this.getText(largeMessage, i));
            message.setIntProperty("i", i);
            producer.send((Message)message);
            if (i != NUMBER_OF_MESSAGES / 2 || !restartBC) continue;
            Wait.assertEquals((long)(NUMBER_OF_MESSAGES / 2 + 1), () -> ((Queue)queue_server_2).getMessageCount());
            Wait.assertEquals((long)(NUMBER_OF_MESSAGES / 2 + 1), () -> ((Queue)queue_server_3).getMessageCount());
            Wait.assertEquals((long)(NUMBER_OF_MESSAGES / 2 + 1), () -> ((Queue)queue_server_1).getMessageCount());
            this.server_2.stopBrokerConnection(brokerConnectionOne);
            this.server_2.stopBrokerConnection(brokerConnectionTwo);
            Thread.sleep(1000L);
            this.server_2.startBrokerConnection(brokerConnectionOne);
            this.server_2.startBrokerConnection(brokerConnectionTwo);
        }
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queue_server_2).getMessageCount());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queue_server_3).getMessageCount());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queue_server_1).getMessageCount());
        Queue replica1Queue = this.server_2.locateQueue(replica1.getMirrorSNF());
        Queue replica2Queue = this.server_2.locateQueue(replica2.getMirrorSNF());
        Wait.assertEquals((Long)0L, () -> ((PagingStore)replica2Queue.getPagingStore()).getAddressSize(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)0L, () -> ((PagingStore)replica1Queue.getPagingStore()).getAddressSize(), (long)1000L, (long)100L);
        if (pagingTarget) {
            Assertions.assertTrue((boolean)queue_server_1.getPagingStore().isPaging());
            Assertions.assertTrue((boolean)queue_server_3.getPagingStore().isPaging());
        }
        if (pagingSource) {
            Assertions.assertTrue((boolean)queue_server_2.getPagingStore().isPaging());
        }
        this.consumeMessages(largeMessage, 0, NUMBER_OF_MESSAGES / 2 - 1, 5673, false);
        Wait.assertEquals((long)(NUMBER_OF_MESSAGES / 2), () -> ((Queue)queue_server_1).getMessageCount());
        Wait.assertEquals((long)(NUMBER_OF_MESSAGES / 2), () -> ((Queue)queue_server_2).getMessageCount());
        Wait.assertEquals((long)(NUMBER_OF_MESSAGES / 2), () -> ((Queue)queue_server_3).getMessageCount());
        Wait.assertEquals((long)(NUMBER_OF_MESSAGES / 2), () -> ((Queue)queue_server_1).getMessageCount());
        this.consumeMessages(largeMessage, NUMBER_OF_MESSAGES / 2, NUMBER_OF_MESSAGES - 1, 5672, true);
        this.consumeMessages(largeMessage, NUMBER_OF_MESSAGES / 2, NUMBER_OF_MESSAGES - 1, 5674, true);
        this.consumeMessages(largeMessage, NUMBER_OF_MESSAGES / 2, NUMBER_OF_MESSAGES - 1, 5673, true);
        this.validateNoFilesOnLargeDir(this.server.getConfiguration().getLargeMessagesDirectory(), 0);
        this.validateNoFilesOnLargeDir(server_3.getConfiguration().getLargeMessagesDirectory(), 0);
        this.validateNoFilesOnLargeDir(this.server_2.getConfiguration().getLargeMessagesDirectory(), 0);
    }

    @Test
    public void testWithTXLargeMessage() throws Exception {
        this.testWithTX(true);
    }

    @Test
    public void testWithTX() throws Exception {
        this.testWithTX(false);
    }

    private void testWithTX(boolean largeMessage) throws Exception {
        TextMessage message;
        int i;
        this.server.setIdentity("server_1");
        this.server.start();
        ActiveMQServer server_3 = this.createServer(5674, false);
        server_3.setIdentity("server_3");
        server_3.start();
        Wait.assertTrue(() -> ((ActiveMQServer)server_3).isStarted());
        ConnectionFactory factory_3 = CFUtil.createConnectionFactory("amqp", "tcp://localhost:5674");
        factory_3.createConnection().close();
        this.server_2 = this.createServer(5673, false);
        String brokerConnectionOne = "brokerConnection1:" + UUIDGenerator.getInstance().generateStringUUID();
        String brokerConnectionTwo = "brokerConnection2:" + UUIDGenerator.getInstance().generateStringUUID();
        AMQPBrokerConnectConfiguration amqpConnection1 = new AMQPBrokerConnectConfiguration(brokerConnectionOne, "tcp://localhost:5672");
        AMQPMirrorBrokerConnectionElement replica1 = new AMQPMirrorBrokerConnectionElement().setType(AMQPBrokerConnectionAddressType.MIRROR);
        amqpConnection1.addElement((AMQPBrokerConnectionElement)replica1);
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection1);
        AMQPBrokerConnectConfiguration amqpConnection3 = new AMQPBrokerConnectConfiguration(brokerConnectionTwo, "tcp://localhost:5674");
        AMQPMirrorBrokerConnectionElement replica2 = new AMQPMirrorBrokerConnectionElement().setType(AMQPBrokerConnectionAddressType.MIRROR);
        amqpConnection3.addElement((AMQPBrokerConnectionElement)replica2);
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection3);
        int NUMBER_OF_MESSAGES = 5;
        this.server_2.start();
        Wait.assertTrue(() -> ((ActiveMQServer)this.server_2).isStarted());
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(true, 0);
        MessageProducer producer = session.createProducer((Destination)session.createQueue(this.getQueueName()));
        producer.setDeliveryMode(1);
        Queue queue_server_2 = this.locateQueue(this.server_2, this.getQueueName());
        Queue queue_server_1 = this.locateQueue(this.server, this.getQueueName());
        Queue queue_server_3 = this.locateQueue(server_3, this.getQueueName());
        for (i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            message = session.createTextMessage(this.getText(largeMessage, i));
            message.setIntProperty("i", i);
            producer.send((Message)message);
        }
        session.rollback();
        Thread.sleep(100L);
        Wait.assertEquals((long)0L, () -> ((Queue)queue_server_2).getMessageCount());
        Wait.assertEquals((long)0L, () -> ((Queue)queue_server_3).getMessageCount());
        Wait.assertEquals((long)0L, () -> ((Queue)queue_server_1).getMessageCount());
        for (i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            message = session.createTextMessage(this.getText(largeMessage, i));
            message.setIntProperty("i", i);
            producer.send((Message)message);
        }
        session.commit();
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queue_server_2).getMessageCount());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queue_server_3).getMessageCount());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queue_server_1).getMessageCount());
    }

    private void printMessages(String printInfo, Queue queue) {
        System.out.println("*******************************************************************************************************************************");
        System.out.println(printInfo);
        System.out.println();
        LinkedListIterator referencesIterator = queue.browserIterator();
        while (referencesIterator.hasNext()) {
            System.out.println("message " + ((MessageReference)referencesIterator.next()).getMessage());
        }
        referencesIterator.close();
        System.out.println("*******************************************************************************************************************************");
    }

    private void consumeMessages(boolean largeMessage, int START_ID, int LAST_ID, int port, boolean assertNull) throws JMSException {
        int i;
        ConnectionFactory cf = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:" + port);
        Connection conn = cf.createConnection();
        Session sess = conn.createSession(false, 1);
        conn.start();
        HashSet<Integer> idsReceived = new HashSet<Integer>();
        MessageConsumer consumer = sess.createConsumer((Destination)sess.createQueue(this.getQueueName()));
        for (i = START_ID; i <= LAST_ID; ++i) {
            Message message = consumer.receive(3000L);
            Assertions.assertNotNull((Object)message);
            Integer id = message.getIntProperty("i");
            Assertions.assertNotNull((Object)id);
            Assertions.assertTrue((boolean)idsReceived.add(id));
        }
        if (assertNull) {
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
        for (i = START_ID; i <= LAST_ID; ++i) {
            Assertions.assertTrue((boolean)idsReceived.remove(i));
        }
        Assertions.assertTrue((boolean)idsReceived.isEmpty());
        conn.close();
    }

    private void consumeSubscription(int START_ID, int LAST_ID, int port, String clientID, String queueName, String subscriptionName, boolean assertNull) throws JMSException {
        int i;
        ConnectionFactory cf = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:" + port);
        Connection conn = cf.createConnection();
        conn.setClientID(clientID);
        Session sess = conn.createSession(false, 1);
        conn.start();
        HashSet<Integer> idsReceived = new HashSet<Integer>();
        Topic topic = sess.createTopic(queueName);
        MessageConsumer consumer = sess.createDurableConsumer(topic, subscriptionName);
        for (i = START_ID; i <= LAST_ID; ++i) {
            Message message = consumer.receive(3000L);
            Assertions.assertNotNull((Object)message);
            Integer id = message.getIntProperty("i");
            Assertions.assertNotNull((Object)id);
            Assertions.assertTrue((boolean)idsReceived.add(id));
        }
        if (assertNull) {
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
        for (i = START_ID; i <= LAST_ID; ++i) {
            Assertions.assertTrue((boolean)idsReceived.remove(i));
        }
        Assertions.assertTrue((boolean)idsReceived.isEmpty());
        conn.close();
    }

    @Test
    public void testMulticast() throws Exception {
        this.multiCastReplicaTest(false, false, false, false, true);
    }

    @Test
    public void testMulticastSerializeConsumption() throws Exception {
        this.multiCastReplicaTest(false, false, false, false, false);
    }

    @Test
    public void testMulticastTargetPaging() throws Exception {
        this.multiCastReplicaTest(false, true, false, false, true);
    }

    @Test
    public void testMulticastTargetSourcePaging() throws Exception {
        this.multiCastReplicaTest(false, true, true, true, true);
    }

    @Test
    public void testMulticastTargetLargeMessage() throws Exception {
        this.multiCastReplicaTest(true, true, true, true, true);
    }

    private void multiCastReplicaTest(boolean largeMessage, boolean pagingTarget, boolean pagingSource, boolean restartBrokerConnection, boolean multiThreadConsumers) throws Exception {
        String brokerConnectionName = "brokerConnectionName:" + UUIDGenerator.getInstance().generateStringUUID();
        ActiveMQServer server = this.server;
        server.setIdentity("targetServer");
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("server_2");
        this.server_2.getConfiguration().setName("thisone");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(brokerConnectionName, "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100);
        AMQPMirrorBrokerConnectionElement replica = new AMQPMirrorBrokerConnectionElement().setMessageAcknowledgements(true).setDurable(true);
        replica.setName("theReplica");
        amqpConnection.addElement((AMQPBrokerConnectionElement)replica);
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.getConfiguration().setName("server_2");
        int NUMBER_OF_MESSAGES = 200;
        this.server_2.start();
        server.start();
        Wait.assertTrue(() -> ((ActiveMQServer)this.server_2).isStarted());
        Wait.assertTrue(() -> ((ActiveMQServer)server).isStarted());
        this.server_2.addAddressInfo(new AddressInfo(this.getTopicName()).addRoutingType(RoutingType.MULTICAST).setAutoCreated(false));
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        Topic topic = session.createTopic(this.getTopicName());
        MessageProducer producer = session.createProducer((Destination)topic);
        for (int i = 0; i <= 1; ++i) {
            this.consumeSubscription(0, -1, 5673, "client" + i, this.getTopicName(), "subscription" + i, false);
        }
        String subs0Name = "client0.subscription0";
        String subs1Name = "client1.subscription1";
        Queue subs0Server1 = this.locateQueue(server, subs0Name);
        Queue subs1Server1 = this.locateQueue(server, subs1Name);
        Assertions.assertNotNull((Object)subs0Server1);
        Assertions.assertNotNull((Object)subs1Server1);
        Queue subs0Server2 = this.locateQueue(this.server_2, subs0Name);
        Queue subs1Server2 = this.locateQueue(this.server_2, subs1Name);
        Assertions.assertNotNull((Object)subs0Server2);
        Assertions.assertNotNull((Object)subs1Server2);
        if (pagingTarget) {
            subs0Server1.getPagingStore().startPaging();
        }
        if (pagingSource) {
            subs0Server2.getPagingStore().startPaging();
        }
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            TextMessage message = session.createTextMessage(this.getText(largeMessage, i));
            message.setIntProperty("i", i);
            producer.send((Message)message);
        }
        if (pagingTarget) {
            subs0Server1.getPagingStore().startPaging();
        }
        Queue snfreplica = this.server_2.locateQueue(replica.getMirrorSNF());
        Assertions.assertNotNull((Object)snfreplica);
        Wait.assertEquals((long)0L, () -> ((Queue)snfreplica).getMessageCount());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)subs0Server1).getMessageCount(), (long)2000L);
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)subs1Server1).getMessageCount(), (long)2000L);
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)subs0Server2).getMessageCount(), (long)2000L);
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)subs1Server2).getMessageCount(), (long)2000L);
        if (restartBrokerConnection) {
            this.server_2.stopBrokerConnection(brokerConnectionName);
            Thread.sleep(1000L);
            this.server_2.startBrokerConnection(brokerConnectionName);
        }
        Assertions.assertSame((Object)snfreplica, (Object)this.server_2.locateQueue(replica.getMirrorSNF()));
        if (pagingTarget) {
            Assertions.assertTrue((boolean)subs0Server1.getPagingStore().isPaging());
            Assertions.assertTrue((boolean)subs1Server1.getPagingStore().isPaging());
        }
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        this.runAfter(executorService::shutdownNow);
        CountDownLatch done = new CountDownLatch(2);
        AtomicInteger errors = new AtomicInteger(0);
        for (int i = 0; i <= 1; ++i) {
            CountDownLatch threadDone = new CountDownLatch(1);
            int subscriptionID = i;
            executorService.execute(() -> {
                try {
                    this.consumeSubscription(0, NUMBER_OF_MESSAGES - 1, 5673, "client" + subscriptionID, this.getTopicName(), "subscription" + subscriptionID, false);
                }
                catch (Throwable e) {
                    logger.warn(e.getMessage(), e);
                    errors.incrementAndGet();
                }
                finally {
                    done.countDown();
                    threadDone.countDown();
                }
            });
            if (multiThreadConsumers) continue;
            threadDone.await(1L, TimeUnit.MINUTES);
        }
        Assertions.assertTrue((boolean)done.await(60L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)0, (int)errors.get());
        Wait.assertEquals((long)0L, () -> ((Queue)snfreplica).getMessageCount());
        Wait.assertEquals((Long)0L, () -> ((Queue)subs0Server1).getMessageCount(), (long)2000L, (long)100L);
        Wait.assertEquals((Long)0L, () -> ((Queue)subs1Server1).getMessageCount(), (long)2000L, (long)100L);
        Wait.assertEquals((Long)0L, () -> ((Queue)subs0Server2).getMessageCount(), (long)2000L, (long)100L);
        Wait.assertEquals((Long)0L, () -> ((Queue)subs1Server2).getMessageCount(), (long)2000L, (long)100L);
        if (largeMessage) {
            this.validateNoFilesOnLargeDir(server.getConfiguration().getLargeMessagesDirectory(), 0);
            this.validateNoFilesOnLargeDir(this.server_2.getConfiguration().getLargeMessagesDirectory(), 0);
        }
    }

    @Test
    public void testSimpleReplicaTX() throws Exception {
        String brokerConnectionName = "brokerConnectionName:" + UUIDGenerator.getInstance().generateStringUUID();
        this.server.setIdentity("targetServer");
        this.server.start();
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("server_2");
        this.server_2.getConfiguration().setName("thisone");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(brokerConnectionName, "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100);
        AMQPMirrorBrokerConnectionElement replica = new AMQPMirrorBrokerConnectionElement().setMessageAcknowledgements(true).setDurable(true);
        replica.setName("theReplica");
        amqpConnection.addElement((AMQPBrokerConnectionElement)replica);
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.getConfiguration().setName("server_2");
        int NUMBER_OF_MESSAGES = 10;
        this.server_2.start();
        Wait.assertTrue(() -> ((ActiveMQServer)this.server_2).isStarted());
        this.server_2.addAddressInfo(new AddressInfo(this.getQueueName()).addRoutingType(RoutingType.ANYCAST).setAutoCreated(false));
        this.server_2.createQueue(QueueConfiguration.of((String)this.getQueueName()).setRoutingType(RoutingType.ANYCAST).setAddress(this.getQueueName()).setAutoCreated(Boolean.valueOf(false)));
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(true, 0);
        MessageProducer producer = session.createProducer((Destination)session.createQueue(this.getQueueName()));
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            TextMessage message = session.createTextMessage(this.getText(true, i));
            message.setIntProperty("i", i);
            producer.send((Message)message);
        }
        session.commit();
        Queue queueOnServer1 = this.locateQueue(this.server, this.getQueueName());
        Queue snfreplica = this.server_2.locateQueue(replica.getMirrorSNF());
        Assertions.assertNotNull((Object)snfreplica);
        Wait.assertEquals((long)0L, () -> ((Queue)snfreplica).getMessageCount());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueOnServer1).getMessageCount(), (long)2000L);
        Queue queueOnServer2 = this.locateQueue(this.server_2, this.getQueueName());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueOnServer1).getMessageCount());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueOnServer2).getMessageCount());
        MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(this.getQueueName()));
        connection.start();
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            Message m = consumer.receive(1000L);
            Assertions.assertNotNull((Object)m);
        }
        session.commit();
        Wait.assertEquals((long)0L, () -> ((Queue)snfreplica).getMessageCount());
        Wait.assertEquals((long)0L, () -> ((Queue)queueOnServer1).getMessageCount());
        Wait.assertEquals((long)0L, () -> ((Queue)queueOnServer2).getMessageCount());
    }

    @Test
    public void testCalculationSize() throws Exception {
        this.testCalculationSize(false);
    }

    @Test
    public void testCalculationSizeRestartSource() throws Exception {
        this.testCalculationSize(true);
    }

    private void testCalculationSize(boolean restartSource) throws Exception {
        String brokerConnectionName = "brokerConnectionName:" + UUIDGenerator.getInstance().generateStringUUID();
        this.server.setIdentity("targetServer");
        this.server.start();
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("server_2");
        this.server_2.getConfiguration().setName("server2");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(brokerConnectionName, "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100);
        AMQPMirrorBrokerConnectionElement replica = new AMQPMirrorBrokerConnectionElement().setMessageAcknowledgements(true).setDurable(true);
        replica.setName("theReplica");
        amqpConnection.addElement((AMQPBrokerConnectionElement)replica);
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.getConfiguration().setName("server_2");
        int NUMBER_OF_MESSAGES = 1;
        this.server_2.start();
        Wait.assertTrue(() -> ((ActiveMQServer)this.server_2).isStarted());
        this.server_2.addAddressInfo(new AddressInfo(this.getQueueName()).addRoutingType(RoutingType.ANYCAST).setAutoCreated(false));
        this.server_2.createQueue(new QueueConfiguration(this.getQueueName()).setRoutingType(RoutingType.ANYCAST).setAddress(this.getQueueName()).setAutoCreated(Boolean.valueOf(false)));
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)session.createQueue(this.getQueueName()));
        Queue queueOnServer2 = this.locateQueue(this.server_2, this.getQueueName());
        this.server.stop();
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            TextMessage message = session.createTextMessage(this.getText(false, i));
            message.setIntProperty("i", i);
            producer.send((Message)message);
        }
        if (restartSource) {
            this.server_2.stop();
            replica.setQueueCreation(false).setQueueRemoval(false);
            this.server_2.start();
        }
        Queue snfreplica = this.server_2.locateQueue(replica.getMirrorSNF());
        Assertions.assertNotNull((Object)snfreplica);
        logger.info("Size on queueOnServer2:: {}", (Object)queueOnServer2.getPagingStore().getAddressSize());
        logger.info("Size on SNF:: {}", (Object)snfreplica.getPagingStore().getAddressSize());
        Wait.assertTrue(() -> queueOnServer2.getPagingStore().getAddressSize() == snfreplica.getPagingStore().getAddressSize(), (long)5000L);
        Wait.assertTrue(() -> queueOnServer2.getPagingStore().getAddressElements() == snfreplica.getPagingStore().getAddressElements(), (long)5000L);
        logger.info("Size on queueOnServer2:: {}, elements={}", (Object)queueOnServer2.getPagingStore().getAddressSize(), (Object)queueOnServer2.getPagingStore().getAddressElements());
        logger.info("Size on SNF:: {}, elements={}", (Object)snfreplica.getPagingStore().getAddressSize(), (Object)snfreplica.getPagingStore().getAddressElements());
        this.server.start();
        Wait.assertTrue(() -> ((ActiveMQServer)this.server).isStarted());
        Queue queueOnServer1 = this.locateQueue(this.server, this.getQueueName());
        Assertions.assertFalse((boolean)this.loggerHandler.findText(new String[]{"AMQ222214"}));
        Wait.assertEquals((long)0L, () -> ((PagingStore)snfreplica.getPagingStore()).getAddressElements());
        Wait.assertEquals((long)0L, () -> ((PagingStore)snfreplica.getPagingStore()).getAddressSize());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueOnServer1).getMessageCount(), (long)2000L);
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueOnServer1).getMessageCount());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueOnServer2).getMessageCount());
        Assertions.assertSame((Object)snfreplica, (Object)this.server_2.locateQueue(replica.getMirrorSNF()));
    }
}

