/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.sasl;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.File;
import java.net.URL;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.apache.qpid.jms.exceptions.JMSSecuritySaslException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SaslScramTest
extends ActiveMQTestBase {
    private EmbeddedActiveMQ BROKER;

    @BeforeEach
    public void startBroker() throws Exception {
        String loginConfPath = new File(SaslScramTest.class.getResource("/login.config").toURI()).getAbsolutePath();
        System.setProperty("java.security.auth.login.config", loginConfPath);
        this.BROKER = new EmbeddedActiveMQ();
        URL urlScram = SaslScramTest.class.getResource("/broker-saslscram.xml");
        Assertions.assertNotNull((Object)urlScram);
        this.BROKER.setConfigResourcePath(urlScram.toExternalForm());
        this.BROKER.setSecurityManager((ActiveMQSecurityManager)new ActiveMQJAASSecurityManager("artemis-sasl-scram"));
        this.BROKER.start();
    }

    @AfterEach
    public void shutdownBroker() throws Exception {
        this.BROKER.stop();
    }

    @Test
    public void testUnencryptedWorksWithAllMechanism() throws JMSException {
        this.sendRcv("SCRAM-SHA-256", "hello", "ogre1234");
    }

    @Test
    public void testEncryptedWorksWithAllMechanism() throws JMSException {
        this.sendRcv("SCRAM-SHA-256", "multi", "worksforall");
    }

    @Test
    public void testEncryptedWorksOnlyWithMechanism() throws JMSException {
        Assertions.assertThrows(JMSSecuritySaslException.class, () -> this.sendRcv("SCRAM-SHA-1", "test", "test"));
    }

    @Test
    public void testEncryptedWorksWithMechanism() throws JMSException {
        this.sendRcv("SCRAM-SHA-256", "test", "test");
    }

    private void sendRcv(String method, String username, String password) throws JMSException {
        JmsConnectionFactory connectionFactory = new JmsConnectionFactory("amqp://localhost:5672?amqp.saslMechanisms=" + method);
        try (Connection connection = connectionFactory.createConnection(username, password);){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue("exampleQueue");
            MessageProducer sender = session.createProducer((Destination)queue);
            String text = "Hello " + method;
            sender.send((Message)session.createTextMessage(text));
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            TextMessage m = (TextMessage)consumer.receive(5000L);
            Assertions.assertEquals((Object)text, (Object)m.getText());
        }
    }
}

