/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Bindable;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.cluster.impl.Redistributor;
import org.apache.activemq.artemis.core.server.group.impl.GroupingHandlerConfiguration;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageRedistributionTest
extends ClusterTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.start();
    }

    private void start() throws Exception {
        this.setupServers();
        this.setRedistributionDelay(0L);
    }

    protected boolean isNetty() {
        return false;
    }

    @Override
    protected void setSessionFactoryCreateLocator(int node, boolean ha, TransportConfiguration serverTotc) {
        super.setSessionFactoryCreateLocator(node, ha, serverTotc);
        this.locators[node].setConsumerWindowSize(0);
    }

    @Test
    public void testRedistributionWithMessageGroups() throws Exception {
        ClientMessage message;
        int i;
        ClientMessage message2;
        int i2;
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        logger.debug("Doing test");
        this.getServer(0).getConfiguration().setGroupingHandlerConfiguration(new GroupingHandlerConfiguration().setName(SimpleString.of((String)"handler")).setType(GroupingHandlerConfiguration.TYPE.LOCAL).setAddress(SimpleString.of((String)"queues")));
        this.getServer(1).getConfiguration().setGroupingHandlerConfiguration(new GroupingHandlerConfiguration().setName(SimpleString.of((String)"handler")).setType(GroupingHandlerConfiguration.TYPE.REMOTE).setAddress(SimpleString.of((String)"queues")));
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.waitForBindings(1, "queues.testaddress", 1, 0, false);
        this.sendWithProperty(0, "queues.testaddress", 10, false, org.apache.activemq.artemis.api.core.Message.HDR_GROUP_ID, SimpleString.of((String)"grp1"));
        this.addConsumer(0, 0, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        this.send(0, "queues.testaddress", 10, false, null);
        for (i2 = 0; i2 < 5; ++i2) {
            message2 = this.getConsumer(1).receive(1000L);
            Assertions.assertNotNull((Object)message2);
            message2.acknowledge();
            Assertions.assertNotNull((Object)message2.getSimpleStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_GROUP_ID));
        }
        for (i2 = 0; i2 < 5; ++i2) {
            message2 = this.getConsumer(0).receive(5000L);
            Assertions.assertNotNull((Object)message2, (String)("" + i2));
            message2.acknowledge();
            Assertions.assertNull((Object)message2.getSimpleStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_GROUP_ID));
        }
        ClientMessage clientMessage = this.getConsumer(0).receiveImmediate();
        Assertions.assertNull((Object)clientMessage);
        this.waitForMessages(1, "queues.testaddress", 15);
        this.removeConsumer(1);
        for (i = 0; i < 5; ++i) {
            message = this.getConsumer(0).receive(5000L);
            Assertions.assertNotNull((Object)message, (String)("" + i));
            message.acknowledge();
            Assertions.assertNull((Object)message.getSimpleStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_GROUP_ID));
        }
        clientMessage = this.getConsumer(0).receiveImmediate();
        Assertions.assertNull((Object)clientMessage);
        this.removeConsumer(0);
        this.addConsumer(1, 1, "queue0", null);
        for (i = 0; i < 5; ++i) {
            message = this.getConsumer(1).receive(1000L);
            Assertions.assertNotNull((Object)message);
            message.acknowledge();
            Assertions.assertNotNull((Object)message.getSimpleStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_GROUP_ID));
        }
        logger.debug("Test done");
    }

    @Test
    public void testRedistributionWithMultipleQueuesOnTheSameAddress() throws Exception {
        int MESSAGE_COUNT = 10;
        String ADDRESS = "myAddress";
        String QUEUE0 = "queue0";
        String QUEUE1 = "queue1";
        this.getServer(0).getConfiguration().addAddressSetting("myAddress", new AddressSettings().setRedistributionDelay(0L));
        this.getServer(1).getConfiguration().addAddressSetting("myAddress", new AddressSettings().setRedistributionDelay(0L));
        this.setupClusterConnection("cluster0", "myAddress", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "myAddress", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        this.startServers(0, 1);
        MessageRedistributionTest.waitForTopology(this.servers[0], 2);
        MessageRedistributionTest.waitForTopology(this.servers[1], 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "myAddress", "queue0", null, false);
        this.createQueue(0, "myAddress", "queue1", null, false);
        this.createQueue(1, "myAddress", "queue0", null, false);
        this.createQueue(1, "myAddress", "queue1", null, false);
        this.addConsumer(0, 0, "queue0", null, true, null, null, 0);
        this.addConsumer(1, 1, "queue0", null, true, null, null, 0);
        this.waitForBindings(0, "myAddress", 2, 1, true);
        this.waitForBindings(0, "myAddress", 2, 1, false);
        this.waitForBindings(1, "myAddress", 2, 1, true);
        this.waitForBindings(1, "myAddress", 2, 1, false);
        this.send(0, "myAddress", 10, true, null, RoutingType.MULTICAST, null);
        Wait.assertEquals((Long)5L, () -> this.servers[0].locateQueue("queue0").getMessagesAdded(), (long)2000L, (long)100L);
        Wait.assertEquals((Long)5L, () -> this.servers[1].locateQueue("queue0").getMessagesAdded(), (long)2000L, (long)100L);
        Wait.assertEquals((Long)10L, () -> this.servers[0].locateQueue("queue1").getMessageCount(), (long)2000L, (long)100L);
        Wait.assertEquals((Long)0L, () -> this.servers[1].locateQueue("queue1").getMessageCount(), (long)2000L, (long)100L);
        for (int i = 0; i < 5; ++i) {
            ClientMessage m = this.consumers[0].getConsumer().receive(1000L);
            Assertions.assertNotNull((Object)m);
            m.acknowledge();
            m = this.consumers[1].getConsumer().receive(1000L);
            Assertions.assertNotNull((Object)m);
            m.acknowledge();
        }
        Wait.assertEquals((Long)5L, () -> this.servers[0].locateQueue("queue0").getMessagesAcknowledged(), (long)2000L, (long)100L);
        Wait.assertEquals((Long)0L, () -> this.servers[0].locateQueue("queue0").getMessageCount(), (long)2000L, (long)100L);
        Wait.assertEquals((Long)5L, () -> this.servers[1].locateQueue("queue0").getMessagesAcknowledged(), (long)2000L, (long)100L);
        Wait.assertEquals((Long)0L, () -> this.servers[1].locateQueue("queue0").getMessageCount(), (long)2000L, (long)100L);
        this.addConsumer(2, 1, "queue1", null);
        this.waitForBindings(1, "myAddress", 2, 2, true);
        this.waitForBindings(0, "myAddress", 2, 2, false);
        Wait.assertEquals((Long)10L, () -> this.servers[1].locateQueue("queue1").getMessageCount(), (long)2000L, (long)100L);
        Wait.assertEquals((Long)0L, () -> this.servers[0].locateQueue("queue1").getMessageCount(), (long)2000L, (long)100L);
        Wait.assertEquals((Long)0L, () -> this.servers[1].locateQueue("queue0").getMessageCount(), (long)2000L, (long)100L);
    }

    @Test
    public void testRedistributionStopsWhenConsumerAdded() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        logger.debug("Doing test");
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 2, 0, false);
        this.waitForBindings(1, "queues.testaddress", 2, 1, false);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        this.send(0, "queues.testaddress", 2000, false, null);
        this.removeConsumer(0);
        this.addConsumer(0, 0, "queue0", null);
        Bindable bindable = this.servers[0].getPostOffice().getBinding(SimpleString.of((String)"queue0")).getBindable();
        String debug = ((QueueImpl)bindable).debug();
        Assertions.assertFalse((boolean)debug.contains(Redistributor.class.getName()));
        logger.debug("Test done");
    }

    @Test
    public void testRedistributionWhenConsumerIsClosed() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        logger.debug("Doing test");
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.send(0, "queues.testaddress", 20, false, null);
        this.getReceivedOrder(0);
        int[] ids1 = this.getReceivedOrder(1);
        this.getReceivedOrder(2);
        this.removeConsumer(1);
        this.verifyReceiveRoundRobinInSomeOrderWithCounts(false, ids1, 0, 2);
        logger.debug("Test done");
    }

    @Test
    public void testRedistributionWhenConsumerIsClosedDifferentQueues() throws Exception {
        ClientMessage msg;
        int i;
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        this.createQueue(1, "queues.testaddress", "queue1", null, true);
        this.createQueue(2, "queues.testaddress", "queue2", null, true);
        ClientSession sess0 = this.sfs[0].createSession();
        ClientConsumer consumer0 = sess0.createConsumer("queue0");
        ClientSession sess1 = this.sfs[1].createSession();
        ClientConsumer consumer1 = sess1.createConsumer("queue1");
        ClientSession sess2 = this.sfs[2].createSession();
        ClientConsumer consumer2 = sess2.createConsumer("queue2");
        ClientProducer producer0 = sess0.createProducer("queues.testaddress");
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        int NUMBER_OF_MESSAGES = 1000;
        for (i = 0; i < 1000; ++i) {
            producer0.send((org.apache.activemq.artemis.api.core.Message)sess0.createMessage(true).putIntProperty("count", i));
        }
        sess0.start();
        sess1.start();
        sess2.start();
        for (i = 0; i < 1000; ++i) {
            msg = consumer0.receive(5000L);
            Assertions.assertNotNull((Object)msg);
            msg.acknowledge();
            Assertions.assertEquals((int)i, (int)msg.getIntProperty("count"));
        }
        Assertions.assertNull((Object)consumer0.receiveImmediate());
        consumer1.close();
        Thread.sleep(500L);
        for (i = 0; i < 1000; ++i) {
            msg = consumer2.receive(5000L);
            Assertions.assertNotNull((Object)msg);
            msg.acknowledge();
            Assertions.assertEquals((int)i, (int)msg.getIntProperty("count"));
        }
        Assertions.assertNull((Object)consumer2.receiveImmediate());
        Assertions.assertNull((Object)consumer0.receiveImmediate());
        consumer1 = sess1.createConsumer("queue1");
        for (i = 0; i < 1000; ++i) {
            msg = consumer1.receive(5000L);
            Assertions.assertNotNull((Object)msg);
            msg.acknowledge();
            Assertions.assertEquals((int)i, (int)msg.getIntProperty("count"));
        }
        Assertions.assertNull((Object)consumer0.receiveImmediate());
        Assertions.assertNull((Object)consumer1.receiveImmediate());
        Assertions.assertNull((Object)consumer2.receiveImmediate());
        logger.debug("Test done");
    }

    @Test
    public void testRedistributionWhenConsumerIsClosedNotConsumersOnAllNodes() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 1, false);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        this.send(0, "queues.testaddress", 20, false, null);
        int[] ids1 = this.getReceivedOrder(1);
        this.getReceivedOrder(2);
        this.removeConsumer(1);
        this.verifyReceiveRoundRobinInSomeOrderWithCounts(false, ids1, 2);
    }

    @Test
    public void testNoRedistributionWhenConsumerIsClosedForwardWhenNoConsumersTrue() throws Exception {
        this.setupCluster(MessageLoadBalancingType.STRICT);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.send(0, "queues.testaddress", 20, false, null);
        this.removeConsumer(1);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 1, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.verifyReceiveRoundRobinInSomeOrder(20, 0, 1, 2);
    }

    @Test
    public void testNoRedistributionWhenConsumerIsClosedNoConsumersOnOtherNodes() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 2, 1, false);
        this.waitForBindings(1, "queues.testaddress", 2, 0, false);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        this.send(0, "queues.testaddress", 20, false, null);
        this.removeConsumer(1);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 2, 0, false);
        this.waitForBindings(1, "queues.testaddress", 2, 0, false);
        this.waitForBindings(2, "queues.testaddress", 2, 0, false);
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 2, 1, false);
        this.waitForBindings(1, "queues.testaddress", 2, 0, false);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        this.verifyReceiveAll(20, 1);
    }

    @Test
    public void testRedistributeWithScheduling() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        AddressSettings setting = new AddressSettings().setRedeliveryDelay(10000L);
        this.servers[0].getAddressSettingsRepository().addMatch("queues.testaddress", (Object)setting);
        this.servers[0].getAddressSettingsRepository().addMatch("queue0", (Object)setting);
        this.servers[1].getAddressSettingsRepository().addMatch("queue0", (Object)setting);
        this.servers[1].getAddressSettingsRepository().addMatch("queues.testaddress", (Object)setting);
        this.startServers(0);
        this.setupSessionFactory(0, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        ClientSession session0 = this.sfs[0].createSession(false, false, false);
        ClientProducer prod0 = session0.createProducer("queues.testaddress");
        for (int i = 0; i < 100; ++i) {
            ClientMessage msg = session0.createMessage(true);
            msg.putIntProperty("key", i);
            byte[] bytes = new byte[24];
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.putLong(i);
            msg.putBytesProperty(org.apache.activemq.artemis.api.core.Message.HDR_BRIDGE_DUPLICATE_ID, bytes);
            prod0.send((org.apache.activemq.artemis.api.core.Message)msg);
            session0.commit();
        }
        session0.close();
        session0 = this.sfs[0].createSession(true, false, false);
        ClientConsumer consumer0 = session0.createConsumer("queue0");
        session0.start();
        ArrayList<XidImpl> xids = new ArrayList<XidImpl>();
        for (int i = 0; i < 100; ++i) {
            XidImpl xid = this.newXID();
            session0.start((Xid)xid, 0);
            ClientMessage msg = consumer0.receive(5000L);
            msg.acknowledge();
            session0.end((Xid)xid, 0x4000000);
            session0.prepare((Xid)xid);
            xids.add(xid);
        }
        session0.close();
        this.sfs[0].close();
        this.sfs[0] = null;
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        ClientSession session1 = this.sfs[1].createSession(false, false);
        session1.start();
        ClientConsumer consumer1 = session1.createConsumer("queue0");
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 2, 1, false);
        this.waitForBindings(1, "queues.testaddress", 2, 0, false);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        session0 = this.sfs[0].createSession(true, false, false);
        for (Xid xid : xids) {
            session0.rollback(xid);
        }
        for (int i = 0; i < 100; ++i) {
            ClientMessage clientMessage = consumer1.receive(15000L);
            Assertions.assertNotNull((Object)clientMessage);
            clientMessage.acknowledge();
        }
        session1.commit();
    }

    @Test
    public void testRedistributionWhenConsumerIsClosedQueuesWithFilters() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        String filter1 = "giraffe";
        String filter2 = "platypus";
        this.createQueue(0, "queues.testaddress", "queue0", filter1, false);
        this.createQueue(1, "queues.testaddress", "queue0", filter2, false);
        this.createQueue(2, "queues.testaddress", "queue0", filter1, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.send(0, "queues.testaddress", 20, false, filter1);
        int[] ids0 = this.getReceivedOrder(0);
        this.getReceivedOrder(1);
        this.getReceivedOrder(2);
        this.removeConsumer(0);
        this.verifyReceiveRoundRobinInSomeOrderWithCounts(false, ids0, 2);
    }

    @Test
    public void testRedistributionWhenConsumerIsClosedConsumersWithFilters() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        String filter1 = "giraffe";
        String filter2 = "platypus";
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", filter1);
        this.addConsumer(1, 1, "queue0", filter2);
        this.addConsumer(2, 2, "queue0", filter1);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.send(0, "queues.testaddress", 20, false, filter1);
        int[] ids0 = this.getReceivedOrder(0);
        this.getReceivedOrder(1);
        this.getReceivedOrder(2);
        this.removeConsumer(0);
        this.verifyReceiveRoundRobinInSomeOrderWithCounts(false, ids0, 2);
    }

    @Test
    public void testRedistributionWithPrefixesWhenRemoteConsumerIsAdded() throws Exception {
        for (int i = 0; i <= 2; ++i) {
            ActiveMQServer server = this.getServer(i);
            for (TransportConfiguration c : server.getConfiguration().getAcceptorConfigurations()) {
                c.getExtraParams().putIfAbsent("anycastPrefix", "jms.queue.");
            }
        }
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        String name = "queues.queue";
        this.createQueue(0, name, name, null, false, RoutingType.ANYCAST);
        this.createQueue(1, name, name, null, false, RoutingType.ANYCAST);
        this.createQueue(2, name, name, null, false, RoutingType.ANYCAST);
        this.addConsumer(0, 0, name, null);
        this.waitForBindings(0, name, 1, 1, true);
        this.waitForBindings(1, name, 1, 0, true);
        this.waitForBindings(2, name, 1, 0, true);
        this.waitForBindings(0, name, 2, 0, false);
        this.waitForBindings(1, name, 2, 1, false);
        this.waitForBindings(2, name, 2, 1, false);
        this.removeConsumer(0);
        Thread.sleep(2000L);
        this.send(0, "jms.queue." + name, 20, false, null);
        this.addConsumer(1, 1, name, null);
        this.verifyReceiveAll(20, 1);
        this.verifyNotReceive(1);
    }

    @Test
    public void testRedistributionWhenRemoteConsumerIsAdded() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 2, 0, false);
        this.waitForBindings(1, "queues.testaddress", 2, 1, false);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        this.send(0, "queues.testaddress", 20, false, null);
        this.removeConsumer(0);
        this.addConsumer(1, 1, "queue0", null);
        this.verifyReceiveAll(20, 1);
        this.verifyNotReceive(1);
    }

    @Test
    public void testRedistributionWithFqqnAnycast() throws Exception {
        this.internalTestRedistributionWithFqqn(RoutingType.ANYCAST);
    }

    @Test
    public void testRedistributionWithFqqnMulticast() throws Exception {
        this.internalTestRedistributionWithFqqn(RoutingType.MULTICAST);
    }

    private void internalTestRedistributionWithFqqn(RoutingType routingType) throws Exception {
        String ADDRESS = "myAddress";
        String QUEUE = "myQueue";
        String FQQN = CompositeAddress.toFullyQualified((String)"myAddress", (String)"myQueue");
        AddressSettings as = new AddressSettings().setRedistributionDelay(0L);
        this.getServer(0).getAddressSettingsRepository().addMatch("myAddress", (Object)as);
        this.getServer(1).getAddressSettingsRepository().addMatch("myAddress", (Object)as);
        this.setupCluster("myAddress", MessageLoadBalancingType.ON_DEMAND);
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.createQueue(0, "myAddress", "myQueue", null, false, routingType);
        this.createQueue(0, "myAddress", "extra", null, false, routingType);
        this.waitForBindings(0, "myAddress", 2, 0, true);
        this.waitForBindings(1, "myAddress", 2, 0, false);
        this.send(0, FQQN, 20, false, null, routingType, null);
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(1, "myAddress", "myQueue", null, false, routingType);
        this.waitForBindings(0, "myAddress", 1, 0, false);
        this.waitForBindings(1, "myAddress", 1, 0, true);
        this.addConsumer(1, 1, FQQN, null);
        this.waitForBindings(1, "myAddress", 1, 1, true);
        this.verifyReceiveAll(20, 1);
        this.verifyNotReceive(1);
    }

    @Test
    public void testRedistributionWithFqqnJmsQueue() throws Exception {
        String ADDRESS = "myAddress";
        String QUEUE = "myQueue";
        String FQQN = CompositeAddress.toFullyQualified((String)"myAddress", (String)"myQueue");
        AddressSettings as = new AddressSettings().setRedistributionDelay(0L);
        this.getServer(0).getAddressSettingsRepository().addMatch("myAddress", (Object)as);
        this.getServer(1).getAddressSettingsRepository().addMatch("myAddress", (Object)as);
        this.setupCluster("myAddress", MessageLoadBalancingType.ON_DEMAND);
        this.getServer(0).getConfiguration().setName("0");
        this.getServer(1).getConfiguration().setName("1");
        this.startServers(0, 1);
        ActiveMQConnectionFactory cf0 = new ActiveMQConnectionFactory("vm://0");
        ActiveMQConnectionFactory cf1 = new ActiveMQConnectionFactory("vm://1");
        try (Connection connection0 = cf0.createConnection();
             Connection connection1 = cf1.createConnection();){
            jakarta.jms.Queue sendTo = ActiveMQJMSClient.createQueue((String)FQQN);
            jakarta.jms.Queue consumeFrom = ActiveMQJMSClient.createQueue((String)FQQN);
            this.setupSessionFactory(0, this.isNetty());
            this.createQueue(0, "myAddress", "myQueue", null, false, RoutingType.ANYCAST);
            this.waitForBindings(0, "myAddress", 1, 0, true);
            this.waitForBindings(1, "myAddress", 1, 0, false);
            Session session0 = connection0.createSession(false, 1);
            MessageProducer producer = session0.createProducer((Destination)sendTo);
            int numMessages = 10;
            for (int i = 0; i < 10; ++i) {
                TextMessage message = session0.createTextMessage("This is text message " + i);
                producer.send((Message)message);
            }
            producer.close();
            Assertions.assertEquals((long)10L, (long)this.servers[0].locateQueue("myQueue").getMessageCount());
            this.setupSessionFactory(1, this.isNetty());
            this.createQueue(1, "myAddress", "myQueue", null, false, RoutingType.ANYCAST);
            this.waitForBindings(1, "myAddress", 1, 0, true);
            this.waitForBindings(0, "myAddress", 1, 0, false);
            Session session1 = connection1.createSession(false, 1);
            connection1.start();
            MessageConsumer consumer1 = session1.createConsumer((Destination)consumeFrom);
            this.waitForBindings(1, "myAddress", 1, 1, true);
            for (int i = 0; i < 10; ++i) {
                Message message1 = consumer1.receive(5000L);
                Assertions.assertNotNull((Object)message1);
            }
        }
    }

    @Test
    public void testRedistributionWhenRemoteConsumerIsAddedLbOffWithRedistribution() throws Exception {
        this.setupCluster(MessageLoadBalancingType.OFF_WITH_REDISTRIBUTION);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 2, 0, false);
        this.waitForBindings(1, "queues.testaddress", 2, 1, false);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        this.send(0, "queues.testaddress", 20, false, null);
        this.removeConsumer(0);
        this.addConsumer(1, 1, "queue0", null);
        this.verifyReceiveAll(20, 1);
        this.verifyNotReceive(1);
    }

    @Test
    public void testRedistributionOnlyWhenLocalRemovedLbOffWithRedistribution() throws Exception {
        this.setupCluster(MessageLoadBalancingType.OFF_WITH_REDISTRIBUTION);
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        this.send(0, "queues.testaddress", 2, false, null);
        this.verifyNotReceive(1);
        this.removeConsumer(0);
        this.verifyReceiveAll(2, 1);
    }

    @Test
    public void testRedistributionToRemoteConsumerFromNewQueueLbOffWithRedistribution() throws Exception {
        String address = "test.address";
        String queue = "test.address";
        String clusterAddress = "test";
        AddressSettings settings = new AddressSettings().setRedistributionDelay(0L).setAutoCreateAddresses(Boolean.valueOf(true)).setAutoCreateQueues(Boolean.valueOf(true));
        RoutingType routingType = RoutingType.ANYCAST;
        this.getServer(0).getAddressSettingsRepository().addMatch(address, (Object)settings);
        this.getServer(1).getAddressSettingsRepository().addMatch(address, (Object)settings);
        this.setupClusterConnection("cluster0", clusterAddress, MessageLoadBalancingType.OFF_WITH_REDISTRIBUTION, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster0", clusterAddress, MessageLoadBalancingType.OFF_WITH_REDISTRIBUTION, 1, this.isNetty(), 1, 0);
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, address, queue, null, true, routingType);
        this.addConsumer(0, 0, queue, null);
        this.waitForBindings(0, address, 1, 1, true);
        this.waitForBindings(1, address, 1, 1, false);
        this.createQueue(1, address, queue, null, true, routingType);
        this.waitForBindings(1, address, 1, 0, true);
        this.waitForBindings(0, address, 1, 0, false);
        this.waitForBindings(1, address, 1, 1, false);
        int noMessages = 10;
        this.send(1, address, 10, true, null, null);
        this.verifyReceiveAll(10, 0);
    }

    @Test
    public void testRedistributionToRemoteMulticastConsumerLbOffWithRedistribution() throws Exception {
        String address = "test.address";
        String queue = "queue";
        String clusterAddress = "test";
        AddressSettings settings = new AddressSettings().setRedistributionDelay(0L).setAutoCreateAddresses(Boolean.valueOf(true)).setAutoCreateQueues(Boolean.valueOf(true));
        RoutingType routingType = RoutingType.MULTICAST;
        this.getServer(0).getAddressSettingsRepository().addMatch(address, (Object)settings);
        this.getServer(1).getAddressSettingsRepository().addMatch(address, (Object)settings);
        this.setupClusterConnection("cluster0", clusterAddress, MessageLoadBalancingType.OFF_WITH_REDISTRIBUTION, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster0", clusterAddress, MessageLoadBalancingType.OFF_WITH_REDISTRIBUTION, 1, this.isNetty(), 1, 0);
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, address, queue, null, false, routingType);
        this.addConsumer(0, 0, queue, null);
        this.waitForBindings(0, address, 1, 1, true);
        this.waitForBindings(1, address, 1, 1, false);
        this.createAddressInfo(1, address, routingType, 0, false);
        int noMessages = 10;
        this.send(1, address, 10, false, null, routingType, null);
        this.verifyReceiveAll(10, 0);
    }

    @Test
    public void testBackAndForth() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
            this.startServers(0, 1, 2);
            this.setupSessionFactory(0, this.isNetty());
            this.setupSessionFactory(1, this.isNetty());
            this.setupSessionFactory(2, this.isNetty());
            String ADDRESS = "queues.testaddress";
            String QUEUE = "queue0";
            this.createQueue(0, "queues.testaddress", "queue0", null, false);
            this.createQueue(1, "queues.testaddress", "queue0", null, false);
            this.createQueue(2, "queues.testaddress", "queue0", null, false);
            this.addConsumer(0, 0, "queue0", null);
            this.waitForBindings(0, "queues.testaddress", 1, 1, true);
            this.waitForBindings(1, "queues.testaddress", 1, 0, true);
            this.waitForBindings(2, "queues.testaddress", 1, 0, true);
            this.waitForBindings(0, "queues.testaddress", 2, 0, false);
            this.waitForBindings(1, "queues.testaddress", 2, 1, false);
            this.waitForBindings(2, "queues.testaddress", 2, 1, false);
            this.send(0, "queues.testaddress", 20, false, null);
            this.waitForMessages(0, "queues.testaddress", 20);
            this.removeConsumer(0);
            this.waitForBindings(0, "queues.testaddress", 1, 0, true);
            this.waitForBindings(1, "queues.testaddress", 1, 0, true);
            this.waitForBindings(2, "queues.testaddress", 1, 0, true);
            this.waitForBindings(0, "queues.testaddress", 2, 0, false);
            this.waitForBindings(1, "queues.testaddress", 2, 0, false);
            this.waitForBindings(2, "queues.testaddress", 2, 0, false);
            this.addConsumer(1, 1, "queue0", null);
            this.waitForBindings(0, "queues.testaddress", 1, 0, true);
            this.waitForBindings(1, "queues.testaddress", 1, 1, true);
            this.waitForBindings(2, "queues.testaddress", 1, 0, true);
            this.waitForMessages(1, "queues.testaddress", 20);
            this.waitForMessages(0, "queues.testaddress", 0);
            this.waitForBindings(0, "queues.testaddress", 2, 1, false);
            this.waitForBindings(1, "queues.testaddress", 2, 0, false);
            this.waitForBindings(2, "queues.testaddress", 2, 1, false);
            this.removeConsumer(1);
            this.waitForBindings(0, "queues.testaddress", 1, 0, true);
            this.waitForBindings(1, "queues.testaddress", 1, 0, true);
            this.waitForBindings(2, "queues.testaddress", 1, 0, true);
            this.waitForBindings(0, "queues.testaddress", 2, 0, false);
            this.waitForBindings(1, "queues.testaddress", 2, 0, false);
            this.waitForBindings(2, "queues.testaddress", 2, 0, false);
            this.addConsumer(0, 0, "queue0", null);
            this.waitForBindings(0, "queues.testaddress", 1, 1, true);
            this.waitForBindings(1, "queues.testaddress", 1, 0, true);
            this.waitForBindings(2, "queues.testaddress", 1, 0, true);
            this.waitForBindings(0, "queues.testaddress", 2, 0, false);
            this.waitForBindings(1, "queues.testaddress", 2, 1, false);
            this.waitForBindings(2, "queues.testaddress", 2, 1, false);
            this.waitForMessages(0, "queues.testaddress", 20);
            this.verifyReceiveAll(20, 0);
            this.verifyNotReceive(0);
            this.addConsumer(1, 1, "queue0", null);
            this.verifyNotReceive(1);
            this.removeConsumer(1);
            this.stopServers();
            this.start();
        }
    }

    @Test
    public void testBackAndForth2WithDuplicDetection() throws Exception {
        this.internalTestBackAndForth2(true);
    }

    @Test
    public void testBackAndForth2() throws Exception {
        this.internalTestBackAndForth2(false);
    }

    public void internalTestBackAndForth2(boolean useDuplicateDetection) throws Exception {
        AtomicInteger duplDetection = null;
        if (useDuplicateDetection) {
            duplDetection = new AtomicInteger(0);
        }
        for (int i = 0; i < 10; ++i) {
            this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
            this.startServers(0, 1);
            this.setupSessionFactory(0, this.isNetty());
            this.setupSessionFactory(1, this.isNetty());
            String ADDRESS = "queues.testaddress";
            String QUEUE = "queue0";
            this.createQueue(0, "queues.testaddress", "queue0", null, false);
            this.createQueue(1, "queues.testaddress", "queue0", null, false);
            this.addConsumer(0, 0, "queue0", null);
            this.waitForBindings(0, "queues.testaddress", 1, 1, true);
            this.waitForBindings(1, "queues.testaddress", 1, 0, true);
            this.waitForBindings(0, "queues.testaddress", 1, 0, false);
            this.waitForBindings(1, "queues.testaddress", 1, 1, false);
            this.send(1, "queues.testaddress", 20, false, null, duplDetection);
            this.waitForMessages(0, "queues.testaddress", 20);
            this.removeConsumer(0);
            this.waitForBindings(0, "queues.testaddress", 1, 0, true);
            this.waitForBindings(1, "queues.testaddress", 1, 0, true);
            this.waitForBindings(0, "queues.testaddress", 1, 0, false);
            this.waitForBindings(1, "queues.testaddress", 1, 0, false);
            this.addConsumer(1, 1, "queue0", null);
            this.waitForMessages(1, "queues.testaddress", 20);
            this.waitForMessages(0, "queues.testaddress", 0);
            this.waitForBindings(0, "queues.testaddress", 1, 1, false);
            this.waitForBindings(1, "queues.testaddress", 1, 0, false);
            this.removeConsumer(1);
            this.addConsumer(0, 0, "queue0", null);
            this.waitForMessages(1, "queues.testaddress", 0);
            this.waitForMessages(0, "queues.testaddress", 20);
            this.removeConsumer(0);
            this.addConsumer(1, 1, "queue0", null);
            this.waitForMessages(1, "queues.testaddress", 20);
            this.waitForMessages(0, "queues.testaddress", 0);
            this.verifyReceiveAll(20, 1);
            this.stopServers();
            this.start();
        }
    }

    @Test
    public void testRedistributionToQueuesWhereNotAllMessagesMatch() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        String filter1 = "giraffe";
        String filter2 = "platypus";
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 2, 0, false);
        this.waitForBindings(1, "queues.testaddress", 2, 1, false);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        this.sendInRange(0, "queues.testaddress", 0, 10, false, filter1);
        this.sendInRange(0, "queues.testaddress", 10, 20, false, filter2);
        this.removeConsumer(0);
        this.addConsumer(1, 1, "queue0", filter1);
        this.addConsumer(2, 2, "queue0", filter2);
        this.verifyReceiveAllInRange(0, 10, 1);
        this.verifyReceiveAllInRange(10, 20, 2);
    }

    @Test
    public void testDelayedRedistribution() throws Exception {
        long delay = 1000L;
        this.setRedistributionDelay(1000L);
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 2, 0, false);
        this.waitForBindings(1, "queues.testaddress", 2, 1, false);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        this.send(0, "queues.testaddress", 20, false, null);
        long start = System.currentTimeMillis();
        this.removeConsumer(0);
        this.addConsumer(1, 1, "queue0", null);
        long minReceiveTime = start + 1000L;
        this.verifyReceiveAllNotBefore(minReceiveTime, 20, 1);
    }

    @Test
    public void testDelayedRedistributionCancelled() throws Exception {
        long delay = 1000L;
        this.setRedistributionDelay(1000L);
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 2, 0, false);
        this.waitForBindings(1, "queues.testaddress", 2, 1, false);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        this.send(0, "queues.testaddress", 20, false, null);
        this.removeConsumer(0);
        this.addConsumer(1, 1, "queue0", null);
        Thread.sleep(500L);
        this.addConsumer(0, 0, "queue0", null);
        Thread.sleep(1000L);
        this.verifyReceiveAll(20, 0);
    }

    @Test
    public void testRedistributionNumberOfMessagesGreaterThanBatchSize() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 2, 0, false);
        this.waitForBindings(1, "queues.testaddress", 2, 1, false);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        this.send(0, "queues.testaddress", 200, false, null);
        this.removeConsumer(0);
        this.addConsumer(1, 1, "queue0", null);
        Queue queue = this.servers[1].locateQueue(SimpleString.of((String)"queue0"));
        Assertions.assertNotNull((Object)queue);
        Wait.waitFor(() -> queue.getMessageCount() == 200L);
        for (int i = 0; i < 200; ++i) {
            ClientMessage message = this.consumers[1].getConsumer().receive(5000L);
            Assertions.assertNotNull((Object)message);
            message.acknowledge();
        }
        Assertions.assertNull((Object)this.consumers[1].getConsumer().receiveImmediate());
    }

    @Test
    public void testRedistributionWhenNewNodeIsAddedWithConsumer() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.startServers(0);
        this.setupSessionFactory(0, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.send(0, "queues.testaddress", 20, false, null);
        this.startServers(1);
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 1, 0, false);
        this.addConsumer(0, 1, "queue0", null);
        this.verifyReceiveAll(20, 0);
        this.verifyNotReceive(0);
    }

    @Test
    public void testRedistributionWithPagingOnTarget() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        AddressSettings as = new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setPageSizeBytes(10000).setMaxSizeBytes(20000L);
        this.getServer(0).getAddressSettingsRepository().addMatch("queues.*", (Object)as);
        this.getServer(1).getAddressSettingsRepository().addMatch("queues.*", (Object)as);
        this.getServer(2).getAddressSettingsRepository().addMatch("queues.*", (Object)as);
        this.startServers(0);
        this.startServers(1);
        MessageRedistributionTest.waitForTopology(this.getServer(0), 2);
        MessageRedistributionTest.waitForTopology(this.getServer(1), 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        this.createQueue(1, "queues.testaddress", "queue0", null, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 1, 0, false);
        this.getServer(0).getPagingManager().getPageStore(SimpleString.of((String)"queues.testaddress")).startPaging();
        ClientSession session0 = this.sfs[0].createSession(true, true, 0);
        ClientProducer producer0 = session0.createProducer("queues.testaddress");
        ClientConsumer consumer0 = session0.createConsumer("queue0");
        session0.start();
        ClientSession session1 = this.sfs[1].createSession(true, true, 0);
        ClientConsumer consumer1 = session1.createConsumer("queue0");
        session1.start();
        for (int i = 0; i < 10; ++i) {
            ClientMessage msg = session0.createMessage(true);
            msg.putIntProperty("i", i);
            producer0.send((org.apache.activemq.artemis.api.core.Message)msg);
            producer0.send((org.apache.activemq.artemis.api.core.Message)msg);
            msg = consumer0.receive(5000L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((int)i, (int)msg.getIntProperty("i"));
            msg = consumer1.receive(5000L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((int)i, (int)msg.getIntProperty("i"));
            msg.acknowledge();
        }
        session0.close();
        session1.close();
    }

    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.setupCluster("queues", messageLoadBalancingType);
    }

    protected void setupCluster(String address, MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.setupClusterConnection("cluster0", address, messageLoadBalancingType, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", address, messageLoadBalancingType, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", address, messageLoadBalancingType, 1, this.isNetty(), 2, 0, 1);
    }

    protected void setRedistributionDelay(long delay) {
        AddressSettings as = new AddressSettings().setRedistributionDelay(delay);
        this.getServer(0).getAddressSettingsRepository().addMatch("queues.*", (Object)as);
        this.getServer(1).getAddressSettingsRepository().addMatch("queues.*", (Object)as);
        this.getServer(2).getAddressSettingsRepository().addMatch("queues.*", (Object)as);
    }

    protected void setupServers() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
    }

    protected void stopServers() throws Exception {
        this.closeAllConsumers();
        this.closeAllSessionFactories();
        this.closeAllServerLocatorsFactories();
        this.stopServers(0, 1, 2);
        this.clearServer(0, 1, 2);
    }
}

