/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.integration.jms.serializables.TestClass1;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ActiveMQConnectionFactoryTest
extends ActiveMQTestBase {
    private final String groupAddress = ActiveMQConnectionFactoryTest.getUDPDiscoveryAddress();
    private final int groupPort = ActiveMQConnectionFactoryTest.getUDPDiscoveryPort();
    private ActiveMQServer liveService;
    private TransportConfiguration primaryTC;

    @Test
    public void testDefaultConstructor() throws Exception {
        ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[0]);
        this.assertFactoryParams(cf, null, null, null, ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, ActiveMQClient.DEFAULT_CONNECTION_TTL, 30000L, 30000L, 102400, 0x100000, -1, -1, -1, false, true, false, false, false, ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME, 0x100000, 0x100000, 10000L, true, 5, -1, 2000L, ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, 0);
        Connection conn = null;
        try {
            conn = cf.createConnection();
            conn.createSession(false, 1);
            Assertions.fail((String)"Should throw exception");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        if (conn != null) {
            conn.close();
        }
        this.testSettersThrowException(cf);
    }

    @Test
    public void testDefaultConstructorAndSetConnectorPairs() throws Exception {
        ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{this.primaryTC});
        this.assertFactoryParams(cf, new TransportConfiguration[]{this.primaryTC}, null, null, ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, ActiveMQClient.DEFAULT_CONNECTION_TTL, 30000L, 30000L, 102400, 0x100000, -1, -1, -1, false, true, false, false, false, ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME, 0x100000, 0x100000, 10000L, true, 5, -1, 2000L, ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, 0);
        Connection conn = cf.createConnection();
        conn.createSession(false, 1);
        this.testSettersThrowException(cf);
        conn.close();
    }

    @Test
    public void testDiscoveryConstructor() throws Exception {
        DiscoveryGroupConfiguration groupConfiguration = new DiscoveryGroupConfiguration().setBroadcastEndpointFactory((BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(this.groupAddress).setGroupPort(this.groupPort));
        ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((DiscoveryGroupConfiguration)groupConfiguration, (JMSFactoryType)JMSFactoryType.CF);
        this.assertFactoryParams(cf, null, groupConfiguration, null, ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, ActiveMQClient.DEFAULT_CONNECTION_TTL, 30000L, 30000L, 102400, 0x100000, -1, -1, -1, false, true, false, false, false, ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME, 0x100000, 0x100000, 10000L, true, 5, -1, 2000L, ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, 0);
        Connection conn = cf.createConnection();
        conn.createSession(false, 1);
        this.testSettersThrowException(cf);
        conn.close();
    }

    @Test
    public void testStaticConnectorListConstructor() throws Exception {
        ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{this.primaryTC});
        this.assertFactoryParams(cf, new TransportConfiguration[]{this.primaryTC}, null, null, ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, ActiveMQClient.DEFAULT_CONNECTION_TTL, 30000L, 30000L, 102400, 0x100000, -1, -1, -1, false, true, false, false, false, ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME, 0x100000, 0x100000, 10000L, true, 5, -1, 2000L, ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, 0);
        Connection conn = cf.createConnection();
        conn.createSession(false, 1);
        this.testSettersThrowException(cf);
        conn.close();
    }

    @Test
    public void testStaticConnectorPrimaryConstructor() throws Exception {
        ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{this.primaryTC});
        this.assertFactoryParams(cf, new TransportConfiguration[]{this.primaryTC}, null, null, ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, ActiveMQClient.DEFAULT_CONNECTION_TTL, 30000L, 30000L, 102400, 0x100000, -1, -1, -1, false, true, false, false, false, ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME, 0x100000, 0x100000, 10000L, true, 5, -1, 2000L, ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, 0);
        Connection conn = cf.createConnection();
        conn.createSession(false, 1);
        this.testSettersThrowException(cf);
        cf.close();
        conn.close();
    }

    @Test
    public void testGettersAndSetters() {
        ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{this.primaryTC});
        long clientFailureCheckPeriod = RandomUtil.randomPositiveLong();
        long connectionTTL = RandomUtil.randomPositiveLong();
        long callTimeout = RandomUtil.randomPositiveLong();
        int minLargeMessageSize = RandomUtil.randomPositiveInt();
        int consumerWindowSize = RandomUtil.randomPositiveInt();
        int consumerMaxRate = RandomUtil.randomPositiveInt();
        int confirmationWindowSize = RandomUtil.randomPositiveInt();
        int producerMaxRate = RandomUtil.randomPositiveInt();
        boolean blockOnAcknowledge = RandomUtil.randomBoolean();
        boolean blockOnDurableSend = RandomUtil.randomBoolean();
        boolean blockOnNonDurableSend = RandomUtil.randomBoolean();
        boolean autoGroup = RandomUtil.randomBoolean();
        boolean preAcknowledge = RandomUtil.randomBoolean();
        String loadBalancingPolicyClassName = RandomUtil.randomString();
        boolean useGlobalPools = RandomUtil.randomBoolean();
        int scheduledThreadPoolMaxSize = RandomUtil.randomPositiveInt();
        int threadPoolMaxSize = RandomUtil.randomPositiveInt();
        long retryInterval = RandomUtil.randomPositiveLong();
        double retryIntervalMultiplier = RandomUtil.randomDouble();
        int reconnectAttempts = RandomUtil.randomPositiveInt();
        cf.setClientFailureCheckPeriod(clientFailureCheckPeriod);
        cf.setConnectionTTL(connectionTTL);
        cf.setCallTimeout(callTimeout);
        cf.setMinLargeMessageSize(minLargeMessageSize);
        cf.setConsumerWindowSize(consumerWindowSize);
        cf.setConsumerMaxRate(consumerMaxRate);
        cf.setConfirmationWindowSize(confirmationWindowSize);
        cf.setProducerMaxRate(producerMaxRate);
        cf.setBlockOnAcknowledge(blockOnAcknowledge);
        cf.setBlockOnDurableSend(blockOnDurableSend);
        cf.setBlockOnNonDurableSend(blockOnNonDurableSend);
        cf.setAutoGroup(autoGroup);
        cf.setPreAcknowledge(preAcknowledge);
        cf.setConnectionLoadBalancingPolicyClassName(loadBalancingPolicyClassName);
        cf.setUseGlobalPools(useGlobalPools);
        cf.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
        cf.setThreadPoolMaxSize(threadPoolMaxSize);
        cf.setRetryInterval(retryInterval);
        cf.setRetryIntervalMultiplier(retryIntervalMultiplier);
        cf.setReconnectAttempts(reconnectAttempts);
        Assertions.assertEquals((long)clientFailureCheckPeriod, (long)cf.getClientFailureCheckPeriod());
        Assertions.assertEquals((long)connectionTTL, (long)cf.getConnectionTTL());
        Assertions.assertEquals((long)callTimeout, (long)cf.getCallTimeout());
        Assertions.assertEquals((int)minLargeMessageSize, (int)cf.getMinLargeMessageSize());
        Assertions.assertEquals((int)consumerWindowSize, (int)cf.getConsumerWindowSize());
        Assertions.assertEquals((int)consumerMaxRate, (int)cf.getConsumerMaxRate());
        Assertions.assertEquals((int)confirmationWindowSize, (int)cf.getConfirmationWindowSize());
        Assertions.assertEquals((int)producerMaxRate, (int)cf.getProducerMaxRate());
        Assertions.assertEquals((Object)blockOnAcknowledge, (Object)cf.isBlockOnAcknowledge());
        Assertions.assertEquals((Object)blockOnDurableSend, (Object)cf.isBlockOnDurableSend());
        Assertions.assertEquals((Object)blockOnNonDurableSend, (Object)cf.isBlockOnNonDurableSend());
        Assertions.assertEquals((Object)autoGroup, (Object)cf.isAutoGroup());
        Assertions.assertEquals((Object)preAcknowledge, (Object)cf.isPreAcknowledge());
        Assertions.assertEquals((Object)loadBalancingPolicyClassName, (Object)cf.getConnectionLoadBalancingPolicyClassName());
        Assertions.assertEquals((Object)useGlobalPools, (Object)cf.isUseGlobalPools());
        Assertions.assertEquals((int)scheduledThreadPoolMaxSize, (int)cf.getScheduledThreadPoolMaxSize());
        Assertions.assertEquals((int)threadPoolMaxSize, (int)cf.getThreadPoolMaxSize());
        Assertions.assertEquals((long)retryInterval, (long)cf.getRetryInterval());
        Assertions.assertEquals((double)retryIntervalMultiplier, (double)cf.getRetryIntervalMultiplier(), (double)1.0E-4);
        Assertions.assertEquals((int)reconnectAttempts, (int)cf.getReconnectAttempts());
        cf.close();
    }

    @Test
    public void testDeserializationOptions() throws Exception {
        this.testDeserializationOptions(false, false);
    }

    @Test
    public void testDeserializationOptionsJndi() throws Exception {
        this.testDeserializationOptions(true, false);
    }

    @Test
    public void testDeserializationOptionsBrowser() throws Exception {
        this.testDeserializationOptions(false, true);
    }

    @Test
    public void testDeserializationOptionsJndiBrowser() throws Exception {
        this.testDeserializationOptions(true, true);
    }

    private void testDeserializationOptions(boolean useJndi, boolean useBrowser) throws Exception {
        String qname = "SerialTestQueue";
        this.liveService.createQueue(QueueConfiguration.of((String)qname).setRoutingType(RoutingType.ANYCAST));
        String denyList = null;
        String allowList = null;
        Object obj = this.receiveObjectMessage(denyList, allowList, qname, new TestClass1(), useJndi, useBrowser);
        Assertions.assertTrue((boolean)(obj instanceof TestClass1), (String)("Object is " + obj));
        denyList = "java.lang";
        allowList = "some.other.package1";
        obj = this.receiveObjectMessage(denyList, allowList, qname, new TestClass1(), useJndi, useBrowser);
        Assertions.assertTrue((boolean)(obj instanceof JMSException), (String)("Object is " + obj));
        obj = this.receiveObjectMessage(denyList, allowList, qname, (Serializable)((Object)new String("hello")), useJndi, useBrowser);
        Assertions.assertTrue((boolean)"hello".equals(obj), (String)"java.lang.String always trusted ");
        denyList = "org.apache.activemq.artemis.tests.integration.jms.serializables";
        allowList = "org.apache.activemq.artemis.tests.integration.jms.serializables";
        obj = this.receiveObjectMessage(denyList, allowList, qname, new TestClass1(), useJndi, useBrowser);
        Assertions.assertTrue((boolean)(obj instanceof JMSException), (String)("Object is " + obj));
        denyList = "org.apache.activemq.artemis";
        allowList = "org.apache.activemq.artemis.tests.integration.jms.serializables";
        obj = this.receiveObjectMessage(denyList, allowList, qname, new TestClass1(), useJndi, useBrowser);
        Assertions.assertTrue((boolean)(obj instanceof JMSException), (String)("Object is " + obj));
        denyList = "some.other.package";
        allowList = "org.apache.activemq.artemis.tests.integration.jms.serializables";
        obj = this.receiveObjectMessage(denyList, allowList, qname, new TestClass1(), useJndi, useBrowser);
        Assertions.assertTrue((boolean)(obj instanceof TestClass1), (String)("Object is " + obj));
        denyList = "some.other.package";
        allowList = "org.apache.activemq.artemis.tests.integration.jms";
        obj = this.receiveObjectMessage(denyList, allowList, qname, new TestClass1(), useJndi, useBrowser);
        Assertions.assertTrue((boolean)(obj instanceof TestClass1), (String)("Object is " + obj));
        denyList = "some.other.package";
        allowList = "org.apache.activemq.artemis.tests.integration.jms.serializables.pkg1";
        obj = this.receiveObjectMessage(denyList, allowList, qname, new TestClass1(), useJndi, useBrowser);
        Assertions.assertTrue((boolean)(obj instanceof JMSException), (String)("Object is " + obj));
        denyList = "org.apache.activemq.artemis.tests.integration.jms.serializables";
        allowList = "*";
        obj = this.receiveObjectMessage(denyList, allowList, qname, new TestClass1(), useJndi, useBrowser);
        Assertions.assertTrue((boolean)(obj instanceof JMSException), (String)("Object is " + obj));
        denyList = "some.other.package";
        allowList = "*";
        obj = this.receiveObjectMessage(denyList, allowList, qname, new TestClass1(), useJndi, useBrowser);
        Assertions.assertTrue((boolean)(obj instanceof TestClass1), (String)("Object is " + obj));
        denyList = "*";
        allowList = "*";
        obj = this.receiveObjectMessage(denyList, allowList, qname, new TestClass1(), useJndi, useBrowser);
        Assertions.assertTrue((boolean)(obj instanceof JMSException), (String)("Object is " + obj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeprecatedSystemPropertyBlackWhiteListDefault() throws Exception {
        System.setProperty("org.apache.activemq.artemis.jms.deserialization.blacklist", "*");
        System.setProperty("org.apache.activemq.artemis.jms.deserialization.whitelist", "some.other.package");
        String qname = "SerialTestQueue";
        this.liveService.createQueue(QueueConfiguration.of((String)qname).setRoutingType(RoutingType.ANYCAST));
        try {
            String denyList = null;
            String allowList = null;
            Object obj = this.receiveObjectMessage(denyList, allowList, qname, new TestClass1(), false, false);
            Assertions.assertTrue((boolean)(obj instanceof JMSException), (String)("Object is " + obj));
            obj = this.receiveObjectMessage(denyList, allowList, qname, (Serializable)((Object)new String("hello")), false, false);
            Assertions.assertTrue((boolean)"hello".equals(obj), (String)("java.lang.String always trusted " + obj));
            denyList = "some.other.package";
            allowList = "org.apache.activemq.artemis.tests.integration";
            obj = this.receiveObjectMessage(denyList, allowList, qname, new TestClass1(), false, false);
            Assertions.assertTrue((boolean)(obj instanceof TestClass1), (String)("Object is " + obj));
            obj = this.receiveObjectMessage(denyList, allowList, qname, (Serializable)((Object)new String("hello")), false, false);
            Assertions.assertTrue((boolean)"hello".equals(obj), (String)("java.lang.String always trusted " + obj));
        }
        finally {
            System.clearProperty("org.apache.activemq.artemis.jms.deserialization.blacklist");
            System.clearProperty("org.apache.activemq.artemis.jms.deserialization.whitelist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSystemPropertyDenyAllowListDefault() throws Exception {
        System.setProperty("org.apache.activemq.artemis.jms.deserialization.denylist", "*");
        System.setProperty("org.apache.activemq.artemis.jms.deserialization.allowlist", "some.other.package");
        String qname = "SerialTestQueue";
        this.liveService.createQueue(QueueConfiguration.of((String)qname).setRoutingType(RoutingType.ANYCAST));
        try {
            String denyList = null;
            String allowList = null;
            Object obj = this.receiveObjectMessage(denyList, allowList, qname, new TestClass1(), false, false);
            Assertions.assertTrue((boolean)(obj instanceof JMSException), (String)("Object is " + obj));
            obj = this.receiveObjectMessage(denyList, allowList, qname, (Serializable)((Object)new String("hello")), false, false);
            Assertions.assertTrue((boolean)"hello".equals(obj), (String)("java.lang.String always trusted " + obj));
            denyList = "some.other.package";
            allowList = "org.apache.activemq.artemis.tests.integration";
            obj = this.receiveObjectMessage(denyList, allowList, qname, new TestClass1(), false, false);
            Assertions.assertTrue((boolean)(obj instanceof TestClass1), (String)("Object is " + obj));
            obj = this.receiveObjectMessage(denyList, allowList, qname, (Serializable)((Object)new String("hello")), false, false);
            Assertions.assertTrue((boolean)"hello".equals(obj), (String)("java.lang.String always trusted " + obj));
        }
        finally {
            System.clearProperty("org.apache.activemq.artemis.jms.deserialization.denylist");
            System.clearProperty("org.apache.activemq.artemis.jms.deserialization.allowlist");
        }
    }

    private Object receiveObjectMessage(String denyList, String allowList, String qname, Serializable obj, boolean useJndi, boolean useBrowser) throws Exception {
        Serializable serializable;
        block16: {
            this.sendObjectMessage(qname, obj);
            StringBuilder query = new StringBuilder("");
            if (denyList != null) {
                query.append("?");
                query.append("deserializationDenyList=");
                query.append(denyList);
                if (allowList != null) {
                    query.append("&");
                    query.append("deserializationAllowList=");
                    query.append(allowList);
                }
            } else if (allowList != null) {
                query.append("?deserializationAllowList=");
                query.append(allowList);
            }
            ActiveMQConnectionFactory factory = null;
            if (useJndi) {
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
                props.put("connectionFactory.VmConnectionFactory", "vm://0" + query);
                InitialContext ctx = new InitialContext(props);
                factory = (ActiveMQConnectionFactory)ctx.lookup("VmConnectionFactory");
            } else {
                factory = new ActiveMQConnectionFactory("vm://0" + query);
            }
            Connection connection = factory.createConnection();
            try {
                connection.start();
                Session session = connection.createSession(false, 1);
                Queue queue = session.createQueue(qname);
                Serializable result = null;
                if (useBrowser) {
                    QueueBrowser browser = session.createBrowser(queue);
                    ObjectMessage objMessage = (ObjectMessage)browser.getEnumeration().nextElement();
                    MessageConsumer consumer = session.createConsumer((Destination)queue);
                    consumer.receive(5000L);
                    result = objMessage.getObject();
                } else {
                    MessageConsumer consumer = session.createConsumer((Destination)queue);
                    ObjectMessage objMessage = (ObjectMessage)consumer.receive(5000L);
                    Assertions.assertNotNull((Object)objMessage);
                    result = objMessage.getObject();
                }
                serializable = result;
                if (connection == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return e;
                }
            }
            connection.close();
        }
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendObjectMessage(String qname, Serializable obj) throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://0");
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(false, 1);
            Queue q = session.createQueue(qname);
            MessageProducer producer = session.createProducer((Destination)q);
            ObjectMessage objMessage = session.createObjectMessage();
            objMessage.setObject(obj);
            producer.send((Message)objMessage);
        }
    }

    private void testSettersThrowException(ActiveMQConnectionFactory cf) {
        String clientID = RandomUtil.randomString();
        long clientFailureCheckPeriod = RandomUtil.randomPositiveLong();
        long connectionTTL = RandomUtil.randomPositiveLong();
        long callTimeout = RandomUtil.randomPositiveLong();
        int minLargeMessageSize = RandomUtil.randomPositiveInt();
        int consumerWindowSize = RandomUtil.randomPositiveInt();
        int consumerMaxRate = RandomUtil.randomPositiveInt();
        int confirmationWindowSize = RandomUtil.randomPositiveInt();
        int producerMaxRate = RandomUtil.randomPositiveInt();
        boolean blockOnAcknowledge = RandomUtil.randomBoolean();
        boolean blockOnDurableSend = RandomUtil.randomBoolean();
        boolean blockOnNonDurableSend = RandomUtil.randomBoolean();
        boolean autoGroup = RandomUtil.randomBoolean();
        boolean preAcknowledge = RandomUtil.randomBoolean();
        String loadBalancingPolicyClassName = RandomUtil.randomString();
        int dupsOKBatchSize = RandomUtil.randomPositiveInt();
        int transactionBatchSize = RandomUtil.randomPositiveInt();
        boolean useGlobalPools = RandomUtil.randomBoolean();
        int scheduledThreadPoolMaxSize = RandomUtil.randomPositiveInt();
        int threadPoolMaxSize = RandomUtil.randomPositiveInt();
        long retryInterval = RandomUtil.randomPositiveLong();
        double retryIntervalMultiplier = RandomUtil.randomDouble();
        int reconnectAttempts = RandomUtil.randomPositiveInt();
        boolean enableSharedClientID = true;
        try {
            cf.setClientID(clientID);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setClientFailureCheckPeriod(clientFailureCheckPeriod);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setConnectionTTL(connectionTTL);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setCallTimeout(callTimeout);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setMinLargeMessageSize(minLargeMessageSize);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setConsumerWindowSize(consumerWindowSize);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setConsumerMaxRate(consumerMaxRate);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setConfirmationWindowSize(confirmationWindowSize);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setProducerMaxRate(producerMaxRate);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setBlockOnAcknowledge(blockOnAcknowledge);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setBlockOnDurableSend(blockOnDurableSend);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setBlockOnNonDurableSend(blockOnNonDurableSend);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setAutoGroup(autoGroup);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setPreAcknowledge(preAcknowledge);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setConnectionLoadBalancingPolicyClassName(loadBalancingPolicyClassName);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setDupsOKBatchSize(dupsOKBatchSize);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setTransactionBatchSize(transactionBatchSize);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setUseGlobalPools(useGlobalPools);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setThreadPoolMaxSize(threadPoolMaxSize);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setRetryInterval(retryInterval);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setRetryIntervalMultiplier(retryIntervalMultiplier);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setReconnectAttempts(reconnectAttempts);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        cf.getStaticConnectors();
        cf.getClientID();
        cf.getClientFailureCheckPeriod();
        cf.getConnectionTTL();
        cf.getCallTimeout();
        cf.getMinLargeMessageSize();
        cf.getConsumerWindowSize();
        cf.getConsumerMaxRate();
        cf.getConfirmationWindowSize();
        cf.getProducerMaxRate();
        cf.isBlockOnAcknowledge();
        cf.isBlockOnDurableSend();
        cf.isBlockOnNonDurableSend();
        cf.isAutoGroup();
        cf.isPreAcknowledge();
        cf.getConnectionLoadBalancingPolicyClassName();
        cf.getDupsOKBatchSize();
        cf.getTransactionBatchSize();
        cf.isUseGlobalPools();
        cf.getScheduledThreadPoolMaxSize();
        cf.getThreadPoolMaxSize();
        cf.getRetryInterval();
        cf.getRetryIntervalMultiplier();
        cf.getReconnectAttempts();
        cf.close();
    }

    private void assertFactoryParams(ActiveMQConnectionFactory cf, TransportConfiguration[] staticConnectors, DiscoveryGroupConfiguration discoveryGroupConfiguration, String clientID, long clientFailureCheckPeriod, long connectionTTL, long callTimeout, long callFailoverTimeout, int minLargeMessageSize, int consumerWindowSize, int consumerMaxRate, int confirmationWindowSize, int producerMaxRate, boolean blockOnAcknowledge, boolean blockOnDurableSend, boolean blockOnNonDurableSend, boolean autoGroup, boolean preAcknowledge, String loadBalancingPolicyClassName, int dupsOKBatchSize, int transactionBatchSize, long initialWaitTimeout, boolean useGlobalPools, int scheduledThreadPoolMaxSize, int threadPoolMaxSize, long retryInterval, double retryIntervalMultiplier, int reconnectAttempts) {
        TransportConfiguration[] cfStaticConnectors = cf.getStaticConnectors();
        if (staticConnectors == null) {
            Assertions.assertNull((Object)staticConnectors);
        } else {
            Assertions.assertEquals((int)staticConnectors.length, (int)cfStaticConnectors.length);
            for (int i = 0; i < staticConnectors.length; ++i) {
                Assertions.assertEquals((Object)staticConnectors[i], (Object)cfStaticConnectors[i]);
            }
        }
        Assertions.assertEquals((Object)cf.getClientID(), (Object)clientID);
        Assertions.assertEquals((long)cf.getClientFailureCheckPeriod(), (long)clientFailureCheckPeriod);
        Assertions.assertEquals((long)cf.getConnectionTTL(), (long)connectionTTL);
        Assertions.assertEquals((long)cf.getCallTimeout(), (long)callTimeout);
        Assertions.assertEquals((long)cf.getCallFailoverTimeout(), (long)callFailoverTimeout);
        Assertions.assertEquals((int)cf.getMinLargeMessageSize(), (int)minLargeMessageSize);
        Assertions.assertEquals((int)cf.getConsumerWindowSize(), (int)consumerWindowSize);
        Assertions.assertEquals((int)cf.getConsumerMaxRate(), (int)consumerMaxRate);
        Assertions.assertEquals((int)cf.getConfirmationWindowSize(), (int)confirmationWindowSize);
        Assertions.assertEquals((int)cf.getProducerMaxRate(), (int)producerMaxRate);
        Assertions.assertEquals((Object)cf.isBlockOnAcknowledge(), (Object)blockOnAcknowledge);
        Assertions.assertEquals((Object)cf.isBlockOnDurableSend(), (Object)blockOnDurableSend);
        Assertions.assertEquals((Object)cf.isBlockOnNonDurableSend(), (Object)blockOnNonDurableSend);
        Assertions.assertEquals((Object)cf.isAutoGroup(), (Object)autoGroup);
        Assertions.assertEquals((Object)cf.isPreAcknowledge(), (Object)preAcknowledge);
        Assertions.assertEquals((Object)cf.getConnectionLoadBalancingPolicyClassName(), (Object)loadBalancingPolicyClassName);
        Assertions.assertEquals((int)cf.getDupsOKBatchSize(), (int)dupsOKBatchSize);
        Assertions.assertEquals((int)cf.getTransactionBatchSize(), (int)transactionBatchSize);
        Assertions.assertEquals((Object)cf.isUseGlobalPools(), (Object)useGlobalPools);
        Assertions.assertEquals((int)cf.getScheduledThreadPoolMaxSize(), (int)scheduledThreadPoolMaxSize);
        Assertions.assertEquals((int)cf.getThreadPoolMaxSize(), (int)threadPoolMaxSize);
        Assertions.assertEquals((long)cf.getRetryInterval(), (long)retryInterval);
        Assertions.assertEquals((double)cf.getRetryIntervalMultiplier(), (double)retryIntervalMultiplier, (double)1.0E-5);
        Assertions.assertEquals((int)cf.getReconnectAttempts(), (int)reconnectAttempts);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.startServer();
    }

    private void startServer() throws Exception {
        this.primaryTC = new TransportConfiguration(INVM_CONNECTOR_FACTORY);
        HashMap<String, TransportConfiguration> connectors = new HashMap<String, TransportConfiguration>();
        connectors.put(this.primaryTC.getName(), this.primaryTC);
        ArrayList<String> connectorNames = new ArrayList<String>();
        connectorNames.add(this.primaryTC.getName());
        ConfigurationImpl primaryConf = this.createBasicConfig().addAcceptorConfiguration(new TransportConfiguration(INVM_ACCEPTOR_FACTORY)).setConnectorConfigurations(connectors).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStorePrimaryPolicyConfiguration());
        long broadcastPeriod = 250L;
        String bcGroupName = "bc1";
        int localBindPort = 5432;
        BroadcastGroupConfiguration bcConfig1 = new BroadcastGroupConfiguration().setName("bc1").setBroadcastPeriod(250L).setConnectorInfos(connectorNames).setEndpointFactory((BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(this.groupAddress).setGroupPort(this.groupPort).setLocalBindPort(5432));
        ArrayList<BroadcastGroupConfiguration> bcConfigs1 = new ArrayList<BroadcastGroupConfiguration>();
        bcConfigs1.add(bcConfig1);
        primaryConf.setBroadcastGroupConfigurations(bcConfigs1);
        this.liveService = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)primaryConf, (boolean)false));
        this.liveService.start();
    }
}

