/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5.spec.controlpackets;

import java.nio.charset.StandardCharsets;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptionsBuilder;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class ConnectTestsWithSecurity
extends MQTT5TestSupport {
    @Override
    public boolean isSecurityEnabled() {
        return true;
    }

    @Test
    @Timeout(value=60L)
    public void testAuthenticationFailureWithBadCredentials() throws Exception {
        this.testAuthentication(new MqttConnectionOptionsBuilder().username(RandomUtil.randomString()).password(RandomUtil.randomString().getBytes(StandardCharsets.UTF_8)).build());
    }

    @Test
    @Timeout(value=60L)
    public void testAuthenticationFailureWithNoCredentials() throws Exception {
        this.testAuthentication(new MqttConnectionOptionsBuilder().build());
    }

    private void testAuthentication(MqttConnectionOptions options) throws Exception {
        String CLIENT_ID = RandomUtil.randomString();
        MqttClient client = this.createPahoClient(CLIENT_ID);
        try {
            client.connect(options);
            Assertions.fail((String)"Connecting should have failed with a security problem");
        }
        catch (MqttException e) {
            Assertions.assertEquals((byte)-122, (byte)((byte)e.getReasonCode()));
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown an MqttException");
        }
        Assertions.assertFalse((boolean)client.isConnected());
    }

    @Test
    @Timeout(value=60L)
    public void testAuthenticationSuccess() throws Exception {
        String CLIENT_ID = RandomUtil.randomString();
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().username(this.fullUser).password(this.fullPass.getBytes(StandardCharsets.UTF_8)).build();
        MqttClient client = this.createPahoClient(CLIENT_ID);
        try {
            client.connect(options);
        }
        catch (Exception e) {
            Assertions.fail((String)"Should not have thrown an Exception");
        }
        Assertions.assertTrue((boolean)client.isConnected());
        client.disconnect();
    }
}

