/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.artemis.tests.integration.openwire.amq.JmsResourceProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class JmsTransactionTestSupport
extends BasicOpenWireTest
implements MessageListener {
    private static final int MESSAGE_COUNT = 5;
    private static final String MESSAGE_TEXT = "message";
    protected boolean topic = true;
    protected Session session;
    protected MessageConsumer consumer;
    protected MessageProducer producer;
    protected JmsResourceProvider resourceProvider;
    protected Destination destination;
    protected int batchCount = 10;
    protected int batchSize = 20;
    private List<Message> unackMessages = new ArrayList<Message>(5);
    private List<Message> ackMessages = new ArrayList<Message>(5);
    private boolean resendPhase;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.resourceProvider = this.getJmsResourceProvider();
        this.topic = this.resourceProvider.isTopic();
        this.setSessionTransacted();
        this.reconnect();
    }

    protected void reconnect() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        this.session = null;
        this.connection = (ActiveMQConnection)this.resourceProvider.createConnection((ConnectionFactory)this.factory);
        this.reconnectSession();
        this.connection.start();
    }

    protected void reconnectSession() throws JMSException {
        if (this.session != null) {
            this.session.close();
        }
        this.session = this.resourceProvider.createSession((Connection)this.connection);
        this.destination = this.resourceProvider.createDestination(this.session, this);
        this.producer = this.resourceProvider.createProducer(this.session, this.destination);
        this.consumer = this.resourceProvider.createConsumer(this.session, this.destination);
    }

    protected void setSessionTransacted() {
        this.resourceProvider.setTransacted(true);
    }

    protected void beginTx() throws Exception {
    }

    protected void commitTx() throws Exception {
        this.session.commit();
    }

    protected void rollbackTx() throws Exception {
        this.session.rollback();
    }

    @Test
    public void testSendReceiveTransactedBatches() throws Exception {
        TextMessage message = this.session.createTextMessage("Batch Message");
        for (int j = 0; j < this.batchCount; ++j) {
            int i;
            this.beginTx();
            for (i = 0; i < this.batchSize; ++i) {
                this.producer.send((Message)message);
            }
            this.messageSent();
            this.commitTx();
            this.beginTx();
            for (i = 0; i < this.batchSize; ++i) {
                message = (TextMessage)this.consumer.receive(5000L);
                Assertions.assertNotNull((Object)message, (String)("Received only " + i + " messages in batch " + j));
                Assertions.assertEquals((Object)"Batch Message", (Object)message.getText());
            }
            this.commitTx();
        }
    }

    protected void messageSent() throws Exception {
    }

    @Test
    public void testSendRollback() throws Exception {
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message")};
        this.beginTx();
        this.producer.send(outbound[0]);
        this.commitTx();
        this.beginTx();
        this.producer.send((Message)this.session.createTextMessage("I'm going to get rolled back."));
        this.rollbackTx();
        this.beginTx();
        this.producer.send(outbound[1]);
        this.commitTx();
        this.beginTx();
        ArrayList<Message> messages = new ArrayList<Message>();
        Message message = this.consumer.receive(1000L);
        messages.add(message);
        message = this.consumer.receive(4000L);
        messages.add(message);
        this.commitTx();
        Message[] inbound = new Message[messages.size()];
        messages.toArray(inbound);
        this.assertTextMessagesEqual("Rollback did not work.", outbound, inbound);
    }

    @Test
    public void testAckMessageInTx() throws Exception {
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message")};
        this.beginTx();
        this.producer.send(outbound[0]);
        outbound[0].acknowledge();
        this.commitTx();
        outbound[0].acknowledge();
        this.beginTx();
        ArrayList<Message> messages = new ArrayList<Message>();
        Message message = this.consumer.receive(1000L);
        messages.add(message);
        this.commitTx();
        Message[] inbound = new Message[messages.size()];
        messages.toArray(inbound);
        this.assertTextMessagesEqual("Message not delivered.", outbound, inbound);
    }

    @Test
    public void testSendSessionClose() throws Exception {
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message")};
        this.beginTx();
        this.producer.send(outbound[0]);
        this.commitTx();
        this.beginTx();
        this.producer.send((Message)this.session.createTextMessage("I'm going to get rolled back."));
        this.consumer.close();
        this.reconnectSession();
        this.producer.send(outbound[1]);
        this.commitTx();
        ArrayList<Message> messages = new ArrayList<Message>();
        this.beginTx();
        Message message = this.consumer.receive(1000L);
        messages.add(message);
        message = this.consumer.receive(4000L);
        messages.add(message);
        this.commitTx();
        Message[] inbound = new Message[messages.size()];
        messages.toArray(inbound);
        this.assertTextMessagesEqual("Rollback did not work.", outbound, inbound);
    }

    @Test
    public void testSendSessionAndConnectionClose() throws Exception {
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message")};
        this.beginTx();
        this.producer.send(outbound[0]);
        this.commitTx();
        this.beginTx();
        this.producer.send((Message)this.session.createTextMessage("I'm going to get rolled back."));
        this.consumer.close();
        this.session.close();
        this.reconnect();
        this.beginTx();
        this.producer.send(outbound[1]);
        this.commitTx();
        ArrayList<Message> messages = new ArrayList<Message>();
        this.beginTx();
        Message message = this.consumer.receive(1000L);
        messages.add(message);
        message = this.consumer.receive(4000L);
        messages.add(message);
        this.commitTx();
        Message[] inbound = new Message[messages.size()];
        messages.toArray(inbound);
        this.assertTextMessagesEqual("Rollback did not work.", outbound, inbound);
    }

    @Test
    public void testReceiveRollback() throws Exception {
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message")};
        this.beginTx();
        while (this.consumer.receive(1000L) != null) {
        }
        this.commitTx();
        this.beginTx();
        this.producer.send(outbound[0]);
        this.producer.send(outbound[1]);
        this.commitTx();
        ArrayList<Message> messages = new ArrayList<Message>();
        this.beginTx();
        Message message = this.consumer.receive(1000L);
        messages.add(message);
        Assertions.assertEquals((Object)outbound[0], (Object)message);
        this.commitTx();
        this.beginTx();
        message = this.consumer.receive(1000L);
        Assertions.assertNotNull((Object)message);
        Assertions.assertEquals((Object)outbound[1], (Object)message);
        this.rollbackTx();
        this.beginTx();
        message = this.consumer.receive(5000L);
        Assertions.assertNotNull((Object)message, (String)"Should have re-received the message again!");
        messages.add(message);
        this.commitTx();
        Message[] inbound = new Message[messages.size()];
        messages.toArray(inbound);
        this.assertTextMessagesEqual("Rollback did not work", outbound, inbound);
    }

    @Test
    public void testReceiveTwoThenRollback() throws Exception {
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message")};
        this.beginTx();
        while (this.consumer.receive(1000L) != null) {
        }
        this.commitTx();
        this.beginTx();
        this.producer.send(outbound[0]);
        this.producer.send(outbound[1]);
        this.commitTx();
        ArrayList<TextMessage> messages = new ArrayList<TextMessage>();
        this.beginTx();
        TextMessage message = (TextMessage)this.consumer.receive(1000L);
        Assertions.assertEquals((Object)outbound[0], (Object)message);
        message = (TextMessage)this.consumer.receive(1000L);
        Assertions.assertNotNull((Object)message);
        Assertions.assertEquals((Object)outbound[1], (Object)message);
        message = (TextMessage)this.consumer.receive(1000L);
        Assertions.assertNull((Object)message);
        this.rollbackTx();
        this.beginTx();
        message = (TextMessage)this.consumer.receive(5000L);
        Assertions.assertNotNull((Object)message, (String)"Should have re-received the first message again!");
        messages.add(message);
        Assertions.assertEquals((Object)outbound[0], (Object)message);
        message = (TextMessage)this.consumer.receive(5000L);
        Assertions.assertNotNull((Object)message, (String)"Should have re-received the second message again!");
        messages.add(message);
        Assertions.assertEquals((Object)outbound[1], (Object)message);
        message = (TextMessage)this.consumer.receiveNoWait();
        Assertions.assertNull((Object)message);
        this.commitTx();
        Message[] inbound = new Message[messages.size()];
        messages.toArray(inbound);
        this.assertTextMessagesEqual("Rollback did not work", outbound, inbound);
    }

    @Test
    public void testSendReceiveWithPrefetchOne() throws Exception {
        int i;
        this.setPrefetchToOne();
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message"), this.session.createTextMessage("Third Message"), this.session.createTextMessage("Fourth Message")};
        this.beginTx();
        for (i = 0; i < outbound.length; ++i) {
            this.producer.send(outbound[i]);
        }
        this.commitTx();
        this.beginTx();
        for (i = 0; i < outbound.length; ++i) {
            Message message = this.consumer.receive(1000L);
            Assertions.assertNotNull((Object)message);
        }
        this.commitTx();
    }

    @Test
    public void testReceiveTwoThenRollbackManyTimes() throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.testReceiveTwoThenRollback();
        }
    }

    @Test
    public void testSendRollbackWithPrefetchOfOne() throws Exception {
        this.setPrefetchToOne();
        this.testSendRollback();
    }

    @Test
    public void testReceiveRollbackWithPrefetchOfOne() throws Exception {
        this.setPrefetchToOne();
        this.testReceiveRollback();
    }

    @Test
    public void testCloseConsumerBeforeCommit() throws Exception {
        TextMessage[] outbound = new TextMessage[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message")};
        this.beginTx();
        while (this.consumer.receiveNoWait() != null) {
        }
        this.commitTx();
        this.beginTx();
        this.producer.send((Message)outbound[0]);
        this.producer.send((Message)outbound[1]);
        this.commitTx();
        this.beginTx();
        TextMessage message = (TextMessage)this.consumer.receive(1000L);
        Assertions.assertEquals((Object)outbound[0].getText(), (Object)message.getText());
        this.consumer.close();
        this.commitTx();
        this.consumer = this.resourceProvider.createConsumer(this.session, this.destination);
        this.beginTx();
        message = (TextMessage)this.consumer.receive(1000L);
        Assertions.assertEquals((Object)outbound[1].getText(), (Object)message.getText());
        this.commitTx();
    }

    @Test
    public void testChangeMutableObjectInObjectMessageThenRollback() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("First");
        ObjectMessage outbound = this.session.createObjectMessage(list);
        outbound.setStringProperty("foo", "abc");
        this.beginTx();
        this.producer.send((Message)outbound);
        this.commitTx();
        this.beginTx();
        Message message = this.consumer.receive(5000L);
        List<String> body = this.assertReceivedObjectMessageWithListBody(message);
        try {
            message.setStringProperty("foo", "def");
            Assertions.fail((String)"Cannot change properties of the object!");
        }
        catch (JMSException e) {
            System.out.println("Caught expected exception: " + e);
            e.printStackTrace();
        }
        body.clear();
        body.add("This should never be seen!");
        this.rollbackTx();
        this.beginTx();
        message = this.consumer.receive(5000L);
        List<String> secondBody = this.assertReceivedObjectMessageWithListBody(message);
        Assertions.assertNotSame(secondBody, body, (String)"Second call should return a different body");
        this.commitTx();
    }

    protected List<String> assertReceivedObjectMessageWithListBody(Message message) throws JMSException {
        Assertions.assertNotNull((Object)message, (String)"Should have received a message!");
        Assertions.assertEquals((Object)"abc", (Object)message.getStringProperty("foo"), (String)"foo header");
        Assertions.assertTrue((boolean)(message instanceof ObjectMessage), (String)("Should be an object message but was: " + message));
        ObjectMessage objectMessage = (ObjectMessage)message;
        List body = (List)((Object)objectMessage.getObject());
        Assertions.assertEquals((int)1, (int)body.size(), (String)"Size of list should be 1");
        Assertions.assertEquals((Object)"First", body.get(0), (String)"element 0 of list");
        return body;
    }

    protected void setPrefetchToOne() {
        ActiveMQPrefetchPolicy prefetchPolicy = this.getPrefetchPolicy();
        prefetchPolicy.setQueuePrefetch(1);
        prefetchPolicy.setTopicPrefetch(1);
        prefetchPolicy.setDurableTopicPrefetch(1);
        prefetchPolicy.setOptimizeDurableTopicPrefetch(1);
    }

    protected ActiveMQPrefetchPolicy getPrefetchPolicy() {
        return this.connection.getPrefetchPolicy();
    }

    @Test
    public void testMessageListener() throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.producer.send((Message)this.session.createTextMessage(MESSAGE_TEXT + i));
        }
        this.commitTx();
        this.consumer.setMessageListener((MessageListener)this);
        this.waitReceiveUnack();
        Assertions.assertEquals((int)this.unackMessages.size(), (int)5);
        this.waitReceiveAck();
        Assertions.assertEquals((int)this.ackMessages.size(), (int)5);
        this.consumer.setMessageListener(null);
        Assertions.assertNull((Object)this.consumer.receive(500L));
        this.reconnect();
    }

    public void onMessage(Message message) {
        if (!this.resendPhase) {
            this.unackMessages.add(message);
            if (this.unackMessages.size() == 5) {
                try {
                    this.rollbackTx();
                    this.resendPhase = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.ackMessages.add(message);
            if (this.ackMessages.size() == 5) {
                try {
                    this.commitTx();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void waitReceiveUnack() throws Exception {
        for (int i = 0; i < 100 && !this.resendPhase; ++i) {
            Thread.sleep(100L);
        }
        Assertions.assertTrue((boolean)this.resendPhase);
    }

    private void waitReceiveAck() throws Exception {
        for (int i = 0; i < 100 && this.ackMessages.size() < 5; ++i) {
            Thread.sleep(100L);
        }
        Assertions.assertFalse((this.ackMessages.size() < 5 ? (byte)1 : 0) != 0);
    }

    protected abstract JmsResourceProvider getJmsResourceProvider();
}

