/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.persistence.config.PersistedSecuritySetting;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.integration.persistence.StorageManagerTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class RolesConfigurationStorageTest
extends StorageManagerTestBase {
    private Map<SimpleString, PersistedSecuritySetting> mapExpectedSets;

    public RolesConfigurationStorageTest(StoreConfiguration.StoreType storeType) {
        super(storeType);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.mapExpectedSets = new HashMap<SimpleString, PersistedSecuritySetting>();
    }

    protected void addSetting(PersistedSecuritySetting setting) throws Exception {
        this.mapExpectedSets.put(setting.getAddressMatch(), setting);
        this.journal.storeSecuritySetting(setting);
    }

    @TestTemplate
    public void testStoreSecuritySettings() throws Exception {
        this.addSetting(new PersistedSecuritySetting("a#", "a1", "a1", "a1", "a1", "a1", "a1", "a1", "a1", "a1", "a1", null, null));
        this.addSetting(new PersistedSecuritySetting("a2", "a1", null, "a1", "a1", "a1", "a1", "a1", "a1", "a1", "a1", null, null));
        this.checkSettings();
        this.rebootStorage();
        this.checkSettings();
        this.addSetting(new PersistedSecuritySetting("a2", "a1", null, "a1", "a1", "a1", "a1", "a1", "a1", "a1", "a1", null, null));
        this.addSetting(new PersistedSecuritySetting("a3", "a1", null, "a1", "a1", "a1", "a1", "a1", "a1", "a1", "a1", null, null));
        this.checkSettings();
        this.rebootStorage();
        this.checkSettings();
    }

    @TestTemplate
    public void testStoreSecuritySettings2() throws Exception {
        this.checkSettings();
        this.rebootStorage();
        this.checkSettings();
        this.addSetting(new PersistedSecuritySetting("a#", "a1", "a1", "a1", "a1", "a1", "a1", "a1", "a1", "a1", "a1", null, null));
        this.rebootStorage();
        this.checkSettings();
        this.rebootStorage();
        this.checkSettings();
    }

    private void checkSettings() throws Exception {
        List listSetting = this.journal.recoverSecuritySettings();
        Assertions.assertEquals((int)this.mapExpectedSets.size(), (int)listSetting.size());
        for (PersistedSecuritySetting el : listSetting) {
            PersistedSecuritySetting el2 = this.mapExpectedSets.get(el.getAddressMatch());
            Assertions.assertEquals((Object)el, (Object)el2);
        }
    }
}

