/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.routing;

import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.File;
import java.net.URI;
import java.security.Principal;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.api.core.management.ConnectionRouterControl;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.config.routing.ConnectionRouterConfiguration;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.apache.activemq.artemis.core.server.routing.KeyType;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager5;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.apache.qpid.jms.JmsConnectionListener;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class ElasticQueueTest
extends ActiveMQTestBase {
    static final String qName = "EQ";
    static final SimpleString qNameSimple = SimpleString.of((String)"EQ");
    final int base_port = 61616;
    final Stack<Worker> workers = new Stack();
    final Stack<EmbeddedActiveMQ> nodes = new Stack();
    private final String roleNameSharder = "role_name_sharder";
    private final ExecutorService executorService = Executors.newFixedThreadPool(3);
    MBeanServer mBeanServer = this.createMBeanServer();
    final ActiveMQSecurityManager5 customSecurityManager = new ActiveMQSecurityManager5(){

        public Subject authenticate(String user, String password, RemotingConnection remotingConnection, String securityDomain) {
            Subject subject = null;
            if (this.validateUser(user, password)) {
                subject = new Subject();
                subject.getPrincipals().add((Principal)new UserPrincipal(user));
                subject.getPrincipals().add((Principal)new RolePrincipal("EQ_" + user));
                if (user.equals("BOTH")) {
                    subject.getPrincipals().add((Principal)new RolePrincipal("EQ_PRODUCER"));
                    subject.getPrincipals().add((Principal)new RolePrincipal("EQ_CONSUMER"));
                }
            }
            return subject;
        }

        public boolean authorize(Subject subject, Set<Role> roles, CheckType checkType, String address) {
            return true;
        }

        public boolean validateUser(String username, String password) {
            return username.equals("CONSUMER") || username.equals("PRODUCER") || username.equals("BOTH");
        }

        public boolean validateUserAndRole(String username, String password, Set<Role> requiredRoles, CheckType checkType) {
            return username.equals("CONSUMER") || username.equals("PRODUCER") || username.equals("BOTH");
        }
    };
    final ObjectNameBuilder node0NameBuilder = ObjectNameBuilder.create((String)ActiveMQDefaultConfiguration.getDefaultJmxDomain(), (String)"Node0", (boolean)true);
    final ObjectNameBuilder node1NameBuilder = ObjectNameBuilder.create((String)ActiveMQDefaultConfiguration.getDefaultJmxDomain(), (String)"Node1", (boolean)true);

    @AfterEach
    public void cleanup() {
        for (EmbeddedActiveMQ activeMQ : this.nodes) {
            try {
                activeMQ.stop();
            }
            catch (Throwable throwable) {}
        }
        this.nodes.clear();
        for (Worker worker : this.workers) {
            worker.done.set(true);
        }
        this.workers.clear();
        this.executorService.shutdownNow();
    }

    String urlForNodes(Stack<EmbeddedActiveMQ> nodes) {
        StringBuilder builder = new StringBuilder("failover:(");
        int port_start = 61616;
        for (EmbeddedActiveMQ ignored : nodes) {
            if (port_start != 61616) {
                builder.append(",");
            }
            builder.append("amqp://localhost:").append(port_start++);
        }
        builder.append(")?failover.randomize=true&failover.maxReconnectAttempts=0&jms.sendTimeout=1000");
        return builder.toString();
    }

    private void prepareNodesAndStartCombinedHeadTail() throws Exception {
        AddressSettings blockingQueue = new AddressSettings();
        blockingQueue.setMaxSizeBytes(102400L).setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL).setSlowConsumerPolicy(SlowConsumerPolicy.KILL).setSlowConsumerThreshold(0L).setSlowConsumerCheckPeriod(1L).setAutoDeleteQueues(Boolean.valueOf(false)).setAutoDeleteAddresses(Boolean.valueOf(false));
        ConfigurationImpl baseConfig = new ConfigurationImpl();
        baseConfig.getAddressSettings().put(qName, blockingQueue);
        ConnectionRouterConfiguration connectionRouterConfiguration = new ConnectionRouterConfiguration();
        connectionRouterConfiguration.setName("role_name_sharder").setKeyType(KeyType.ROLE_NAME).setKeyFilter("(?<=^EQ_).*");
        baseConfig.addConnectionRouter(connectionRouterConfiguration);
        for (int nodeId = 0; nodeId < 2; ++nodeId) {
            Configuration configuration = baseConfig.copy();
            configuration.setName("Node" + nodeId);
            configuration.setBrokerInstance(new File(this.getTestDirfile(), configuration.getName()));
            configuration.addAcceptorConfiguration("tcp", "tcp://localhost:" + (61616 + nodeId) + "?router=role_name_sharder;amqpCredits=1000;amqpLowCredits=300");
            this.nodes.add(new EmbeddedActiveMQ().setConfiguration(configuration));
            ((EmbeddedActiveMQ)this.nodes.get(nodeId)).setSecurityManager((ActiveMQSecurityManager)this.customSecurityManager);
            ((EmbeddedActiveMQ)this.nodes.get(nodeId)).setMbeanServer(this.mBeanServer);
        }
        ((ConnectionRouterConfiguration)((EmbeddedActiveMQ)this.nodes.get(0)).getConfiguration().getConnectionRouters().get(0)).setLocalTargetFilter("PRODUCER|CONSUMER");
        ((EmbeddedActiveMQ)this.nodes.get(0)).start();
    }

    @Test
    @Timeout(value=60L)
    public void testScale0_1() throws Exception {
        this.prepareNodesAndStartCombinedHeadTail();
        EQConsumer eqConsumer = new EQConsumer(this.urlForNodes(this.nodes));
        this.executorService.submit(eqConsumer);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> eqConsumer.connectionCount.get() > 1, (long)5000L, (long)200L));
        EQProducer eqProducer = new EQProducer(this.urlForNodes(this.nodes));
        this.executorService.submit(eqProducer);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> eqProducer.connectionCount.get() > 1, (long)10000L, (long)200L));
        AddressControl addressControl0 = (AddressControl)ManagementControlHelper.createProxy(this.node0NameBuilder.getAddressObjectName(qNameSimple), AddressControl.class, this.mBeanServer);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> {
            int usage = addressControl0.getAddressLimitPercent();
            System.out.println("Want 100% on Head&Tail, usage % " + usage);
            return usage == 100;
        }, (long)10000L, (long)500L));
        ConnectionRouterControl routerControl0 = (ConnectionRouterControl)ManagementControlHelper.createProxy(this.node0NameBuilder.getConnectionRouterObjectName("role_name_sharder"), ConnectionRouterControl.class, this.mBeanServer);
        routerControl0.setLocalTargetFilter("CONSUMER");
        ((ConnectionRouterConfiguration)((EmbeddedActiveMQ)this.nodes.get(1)).getConfiguration().getConnectionRouters().get(0)).setLocalTargetFilter("PRODUCER");
        ((EmbeddedActiveMQ)this.nodes.get(1)).start();
        AddressControl addressControl1 = (AddressControl)ManagementControlHelper.createProxy(this.node1NameBuilder.getAddressObjectName(qNameSimple), AddressControl.class, this.mBeanServer);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> {
            try {
                int usage = addressControl1.getAddressLimitPercent();
                System.out.println("Node1 (head) usage % " + usage);
                return usage > 10;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                return false;
            }
        }, (long)5000L, (long)200L), (String)"Producer is on Head, Node1");
        eqConsumer.delayMillis.set(0);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> {
            int usage = addressControl0.getAddressLimitPercent();
            System.out.println("Want 0, Node0 (tail) usage % " + usage);
            return usage == 0;
        }, (long)20000L, (long)500L));
        routerControl0.setLocalTargetFilter("");
        ConnectionRouterControl routerControl0Control1 = (ConnectionRouterControl)ManagementControlHelper.createProxy(this.node1NameBuilder.getConnectionRouterObjectName("role_name_sharder"), ConnectionRouterControl.class, this.mBeanServer);
        routerControl0Control1.setLocalTargetFilter("CONSUMER|PRODUCER");
        ((EmbeddedActiveMQ)this.nodes.get(0)).stop();
        eqConsumer.delayMillis.set(500);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> {
            int usage = addressControl1.getAddressLimitPercent();
            System.out.println("Node1 usage % " + usage);
            return usage == 100;
        }, (long)10000L, (long)200L), (String)"New head&tail, Node1 full");
        eqProducer.done.set(true);
        eqConsumer.delayMillis.set(0);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> {
            int usage = addressControl1.getAddressLimitPercent();
            System.out.println("Want 0, on producer complete, Node1 usage % " + usage);
            return usage == 0;
        }, (long)10000L, (long)200L));
        Assertions.assertTrue((boolean)Wait.waitFor(() -> this.pidInRange("head&tail", eqProducer.getLastProduced(), eqConsumer.getLastConsumed()), (long)4000L, (long)100L), (String)"Got all produced");
        eqConsumer.done.set(true);
        ((EmbeddedActiveMQ)this.nodes.get(1)).stop();
    }

    @Test
    @Timeout(value=60L)
    public void testScale0_1_CombinedProducerConsumerConnectionWithProducerRole() throws Exception {
        this.prepareNodesAndStartCombinedHeadTail();
        EQProducerAsyncConsumer eqProducerConsumer = new EQProducerAsyncConsumer(this.urlForNodes(this.nodes), "PRODUCER");
        this.executorService.submit(eqProducerConsumer);
        AddressControl addressControl0 = (AddressControl)ManagementControlHelper.createProxy(this.node0NameBuilder.getAddressObjectName(qNameSimple), AddressControl.class, this.mBeanServer);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> {
            try {
                int usage = addressControl0.getAddressLimitPercent();
                System.out.println("Head&Tail usage % " + usage);
                return usage == 100;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                return false;
            }
        }, (long)10000L, (long)200L));
        Assertions.assertTrue((boolean)Wait.waitFor(() -> eqProducerConsumer.connectionCount.get() > 2), (String)"producer got full error and reconnected");
        long lastProducedToHeadTail = eqProducerConsumer.getLastProduced();
        ConnectionRouterControl routerControl0 = (ConnectionRouterControl)ManagementControlHelper.createProxy(this.node0NameBuilder.getConnectionRouterObjectName("role_name_sharder"), ConnectionRouterControl.class, this.mBeanServer);
        routerControl0.setLocalTargetFilter("CONSUMER");
        ((ConnectionRouterConfiguration)((EmbeddedActiveMQ)this.nodes.get(1)).getConfiguration().getConnectionRouters().get(0)).setLocalTargetFilter("PRODUCER");
        ((EmbeddedActiveMQ)this.nodes.get(1)).start();
        AddressControl addressControl1 = (AddressControl)ManagementControlHelper.createProxy(this.node1NameBuilder.getAddressObjectName(qNameSimple), AddressControl.class, this.mBeanServer);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> {
            try {
                addressControl1.pause();
                return true;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                return false;
            }
        }, (long)10000L, (long)200L));
        EQConsumer eqConsumer = new EQConsumer(this.urlForNodes(this.nodes), 0);
        this.executorService.submit(eqConsumer);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> {
            int usage = addressControl0.getAddressLimitPercent();
            System.out.println("Tail usage % " + usage);
            return usage == 0;
        }, (long)10000L, (long)200L));
        Assertions.assertTrue((boolean)Wait.waitFor(() -> {
            System.out.println("drain tail, lastProduced: " + lastProducedToHeadTail + ", consumed: " + eqConsumer.getLastConsumed());
            return lastProducedToHeadTail == eqConsumer.getLastConsumed();
        }, (long)5000L, (long)100L));
        eqConsumer.done.set(true);
        routerControl0 = (ConnectionRouterControl)ManagementControlHelper.createProxy(this.node0NameBuilder.getConnectionRouterObjectName("role_name_sharder"), ConnectionRouterControl.class, this.mBeanServer);
        routerControl0.setLocalTargetFilter("");
        ((EmbeddedActiveMQ)this.nodes.get(0)).stop();
        addressControl1.resume();
        Assertions.assertTrue((boolean)Wait.waitFor(() -> {
            int usage = addressControl1.getAddressLimitPercent();
            System.out.println("Head&Tail usage % " + usage);
            return usage == 100;
        }, (long)10000L, (long)200L));
        eqProducerConsumer.producerDone.set(true);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> {
            int usage = addressControl1.getAddressLimitPercent();
            System.out.println("Node1 usage % " + usage + ", eqProducerConsumer: " + eqProducerConsumer);
            return usage == 0;
        }, (long)10000L, (long)500L));
        Assertions.assertTrue((boolean)Wait.waitFor(() -> this.pidInRange("head&tail", eqProducerConsumer.getLastProduced(), eqProducerConsumer.getLastConsumed()), (long)5000L, (long)100L));
        eqProducerConsumer.done.set(true);
        ((EmbeddedActiveMQ)this.nodes.get(1)).stop();
    }

    @Test
    @Timeout(value=60L)
    public void testScale0_1_CombinedRoleConnection() throws Exception {
        this.prepareNodesAndStartCombinedHeadTail();
        EQProducerAsyncConsumer eqProducerConsumer = new EQProducerAsyncConsumer(this.urlForNodes(this.nodes), "BOTH");
        this.executorService.submit(eqProducerConsumer);
        AddressControl addressControl0 = (AddressControl)ManagementControlHelper.createProxy(this.node0NameBuilder.getAddressObjectName(qNameSimple), AddressControl.class, this.mBeanServer);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> {
            try {
                int usage = addressControl0.getAddressLimitPercent();
                System.out.println("Head&Tail usage % " + usage);
                return usage == 100;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                return false;
            }
        }, (long)20000L, (long)200L));
        Assertions.assertTrue((boolean)Wait.waitFor(() -> eqProducerConsumer.connectionCount.get() > 0), (String)"producer got full error and reconnected");
        ConnectionRouterControl routerControl0 = (ConnectionRouterControl)ManagementControlHelper.createProxy(this.node0NameBuilder.getConnectionRouterObjectName("role_name_sharder"), ConnectionRouterControl.class, this.mBeanServer);
        routerControl0.setTargetKeyFilter("(?<=^EQ_)CONSUMER");
        addressControl0.block();
        System.out.println("Tail blocked!");
        ((ConnectionRouterConfiguration)((EmbeddedActiveMQ)this.nodes.get(1)).getConfiguration().getConnectionRouters().get(0)).setKeyFilter("(?<=^EQ_)PRODUCER");
        ((ConnectionRouterConfiguration)((EmbeddedActiveMQ)this.nodes.get(1)).getConfiguration().getConnectionRouters().get(0)).setLocalTargetFilter(null);
        ((EmbeddedActiveMQ)this.nodes.get(1)).getConfiguration().getAddressConfigurations().add(new CoreAddressConfiguration().setName(qName).addRoutingType(RoutingType.ANYCAST).addQueueConfiguration(QueueConfiguration.of((String)qName).setRoutingType(RoutingType.ANYCAST)));
        ((EmbeddedActiveMQ)this.nodes.get(1)).start();
        AddressControl addressControl1 = (AddressControl)ManagementControlHelper.createProxy(this.node1NameBuilder.getAddressObjectName(qNameSimple), AddressControl.class, this.mBeanServer);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> {
            try {
                addressControl1.pause();
                return true;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                return false;
            }
        }, (long)5000L, (long)100L));
        ConnectionRouterControl routerControl0Control1 = (ConnectionRouterControl)ManagementControlHelper.createProxy(this.node1NameBuilder.getConnectionRouterObjectName("role_name_sharder"), ConnectionRouterControl.class, this.mBeanServer);
        routerControl0Control1.setLocalTargetFilter("PRODUCER");
        System.out.println("Head enabled for producers... limit: " + addressControl1.getAddressLimitPercent());
        eqProducerConsumer.consumerSleepMillis.set(0);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> {
            int usage = addressControl0.getAddressLimitPercent();
            System.out.println("Want 0, tail usage % " + usage);
            return usage == 0;
        }, (long)20000L, (long)200L));
        System.out.println("Tail drained!");
        routerControl0.setLocalTargetFilter(null);
        addressControl1.resume();
        eqProducerConsumer.consumerSleepMillis.set(2000);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> {
            int usage = addressControl1.getAddressLimitPercent();
            System.out.println("want 100%, head&tail usage % " + usage);
            return usage == 100;
        }, (long)20000L, (long)200L));
        eqProducerConsumer.producerDone.set(true);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> {
            int usage = addressControl1.getAddressLimitPercent();
            System.out.println("Want 0, head&tail usage % " + usage);
            return usage == 0;
        }, (long)20000L, (long)200L));
        Assertions.assertTrue((boolean)Wait.waitFor(() -> this.pidInRange("head&tail", eqProducerConsumer.getLastProduced(), eqProducerConsumer.getLastConsumed()), (long)20000L, (long)200L));
        eqProducerConsumer.done.set(true);
        ((EmbeddedActiveMQ)this.nodes.get(1)).stop();
    }

    private boolean pidInRange(String s, long lastProduced, long lastConsumed) {
        System.out.println(String.format("pidInRange - %s, lastProduced: %d, lastConsumed: %d", s, lastProduced, lastConsumed));
        if (lastConsumed == lastProduced) {
            return true;
        }
        return lastConsumed == lastProduced + 1L;
    }

    abstract class Worker
    implements Runnable {
        final AtomicBoolean done = new AtomicBoolean();

        Worker() {
            ElasticQueueTest.this.workers.push(this);
        }
    }

    class EQConsumer
    extends Worker {
        final AtomicInteger consumedCount = new AtomicInteger();
        final AtomicInteger connectionCount = new AtomicInteger();
        final AtomicInteger delayMillis;
        private final String url;
        long lastConsumed = 0L;

        EQConsumer(String url) {
            this(url, 500);
        }

        EQConsumer(String url, int delay) {
            this.url = url;
            this.delayMillis = new AtomicInteger(delay);
        }

        @Override
        public void run() {
            block9: while (true) {
                try {
                    while (!this.done.get()) {
                        JmsConnectionFactory factory = new JmsConnectionFactory("CONSUMER", "PASSWORD", this.url);
                        try {
                            JmsConnection connection = (JmsConnection)factory.createConnection();
                            try {
                                this.connectionCount.incrementAndGet();
                                AtomicReference<JMSException> fatalError = new AtomicReference<JMSException>();
                                connection.addConnectionListener((JmsConnectionListener)new ConnectionListener(this.connectionCount, fatalError));
                                connection.start();
                                Session session = connection.createSession(false, 2);
                                MessageConsumer messageConsumer = session.createConsumer((Destination)session.createQueue(ElasticQueueTest.qName));
                                while (true) {
                                    if (this.done.get() || fatalError.get() != null) continue block9;
                                    Message receivedMessage = messageConsumer.receiveNoWait();
                                    if (receivedMessage != null) {
                                        this.consumedCount.incrementAndGet();
                                        this.lastConsumed = receivedMessage.getLongProperty("PID");
                                        receivedMessage.acknowledge();
                                    }
                                    TimeUnit.MILLISECONDS.sleep(this.delayMillis.get());
                                }
                            }
                            finally {
                                if (connection != null) {
                                    connection.close();
                                }
                                continue block9;
                            }
                        }
                        catch (JMSException jMSException) {
                        }
                    }
                    break;
                }
                catch (Exception outOfHere) {
                    outOfHere.printStackTrace();
                    break;
                }
            }
        }

        public long getLastConsumed() {
            return this.lastConsumed;
        }
    }

    class EQProducer
    extends Worker {
        final AtomicInteger producedCount = new AtomicInteger();
        final AtomicInteger connectionCount = new AtomicInteger();
        private final String url;

        EQProducer(String url) {
            this.url = url;
        }

        @Override
        public void run() {
            URI connectedToUri = null;
            while (!this.done.get()) {
                JmsConnectionFactory factory = new JmsConnectionFactory("PRODUCER", "PASSWORD", this.url);
                try {
                    JmsConnection connection = (JmsConnection)factory.createConnection();
                    try {
                        this.connectionCount.incrementAndGet();
                        AtomicReference<JMSException> fatalError = new AtomicReference<JMSException>();
                        connection.addConnectionListener((JmsConnectionListener)new ConnectionListener(this.connectionCount, fatalError));
                        connection.start();
                        Session session = connection.createSession(false, 1);
                        MessageProducer messageProducer = session.createProducer((Destination)session.createQueue(ElasticQueueTest.qName));
                        BytesMessage message = session.createBytesMessage();
                        message.writeBytes(new byte[1024]);
                        while (!this.done.get() && fatalError.get() == null) {
                            connectedToUri = connection.getConnectedURI();
                            message.setLongProperty("PID", (long)(this.producedCount.get() + 1));
                            messageProducer.send((Message)message);
                            this.producedCount.incrementAndGet();
                        }
                    }
                    finally {
                        if (connection == null) continue;
                        connection.close();
                    }
                }
                catch (JMSException expected) {
                    System.out.println("expected send failure: " + expected.toString() + " PID: " + this.producedCount.get() + ", uri: " + connectedToUri);
                }
            }
        }

        public long getLastProduced() {
            return this.producedCount.get();
        }
    }

    class EQProducerAsyncConsumer
    extends Worker {
        final AtomicInteger producedCount = new AtomicInteger();
        final AtomicInteger connectionCount = new AtomicInteger();
        final AtomicBoolean producerDone = new AtomicBoolean();
        final AtomicInteger consumerSleepMillis = new AtomicInteger(1000);
        private final String url;
        final AtomicInteger consumedCount = new AtomicInteger();
        private final String user;
        private long lastConsumed;
        private AtomicReference<JmsConnection> currentConnection = new AtomicReference();

        EQProducerAsyncConsumer(String url, String user) {
            this.url = url;
            this.user = user;
        }

        @Override
        public void run() {
            while (!this.done.get()) {
                JmsConnectionFactory factory = new JmsConnectionFactory(this.user, "PASSWORD", this.url);
                AtomicReference<JMSException> fatalError = new AtomicReference<JMSException>();
                try {
                    JmsConnection connection = (JmsConnection)factory.createConnection();
                    try {
                        this.currentConnection.set(connection);
                        this.connectionCount.incrementAndGet();
                        connection.addConnectionListener((JmsConnectionListener)new ConnectionListener(this.connectionCount, fatalError));
                        connection.start();
                        Session clientSession = connection.createSession(false, 2);
                        MessageConsumer messageConsumer = clientSession.createConsumer((Destination)clientSession.createQueue(ElasticQueueTest.qName));
                        messageConsumer.setMessageListener(message -> {
                            this.consumedCount.incrementAndGet();
                            try {
                                this.lastConsumed = message.getLongProperty("PID");
                                if (!this.producerDone.get()) {
                                    TimeUnit.MILLISECONDS.sleep(this.consumerSleepMillis.get());
                                }
                                message.acknowledge();
                            }
                            catch (JMSException | InterruptedException treatAsFatal) {
                                JMSException errorWrapper = new JMSException("ERROR from onMessage");
                                errorWrapper.setLinkedException((Exception)treatAsFatal);
                                fatalError.set(errorWrapper);
                                System.out.println("OnMessage Got: " + (Exception)treatAsFatal + ", lastConsumed:" + this.lastConsumed + ", connectionCount:" + this.connectionCount.get());
                            }
                        });
                        Session session = connection.createSession(false, 1);
                        MessageProducer messageProducer = session.createProducer((Destination)session.createQueue(ElasticQueueTest.qName));
                        BytesMessage message2 = session.createBytesMessage();
                        message2.writeBytes(new byte[1024]);
                        while (!this.done.get()) {
                            if (fatalError.get() != null) {
                                throw fatalError.get();
                            }
                            if (!this.producerDone.get()) {
                                message2.setLongProperty("PID", (long)(this.producedCount.get() + 1));
                                messageProducer.send((Message)message2);
                                this.producedCount.incrementAndGet();
                                continue;
                            }
                            TimeUnit.SECONDS.sleep(1L);
                        }
                    }
                    finally {
                        if (connection == null) continue;
                        connection.close();
                    }
                }
                catch (JMSException | InterruptedException ignored) {
                    System.out.println("Exception: " + ignored.toString() + ", PC=" + this.producedCount.get());
                }
            }
        }

        public long getLastProduced() {
            return this.producedCount.get();
        }

        public long getLastConsumed() {
            return this.lastConsumed;
        }

        public String toString() {
            JmsConnection connectedTo = this.currentConnection.get();
            if (connectedTo != null) {
                return "EQProducerAsyncConsumer on:" + connectedTo.getConnectedURI();
            }
            return super.toString();
        }
    }

    static class ConnectionListener
    implements JmsConnectionListener {
        AtomicInteger connectionCount;
        final AtomicReference<JMSException> failureReason;

        ConnectionListener(AtomicInteger connectionCount, AtomicReference<JMSException> failureReason) {
            this.connectionCount = connectionCount;
            this.failureReason = failureReason;
        }

        public void onConnectionEstablished(URI uri) {
        }

        public void onConnectionFailure(Throwable throwable) {
            if (this.failureReason != null) {
                JMSException wrapper = new JMSException("ConnectionFailureViaListener");
                wrapper.setLinkedException((Exception)new RuntimeException(throwable));
                this.failureReason.set(wrapper);
            }
        }

        public void onConnectionInterrupted(URI uri) {
        }

        public void onConnectionRestored(URI uri) {
            this.connectionCount.incrementAndGet();
        }

        public void onInboundMessage(JmsInboundMessageDispatch jmsInboundMessageDispatch) {
        }

        public void onSessionClosed(Session session, Throwable throwable) {
        }

        public void onConsumerClosed(MessageConsumer messageConsumer, Throwable throwable) {
        }

        public void onProducerClosed(MessageProducer messageProducer, Throwable throwable) {
        }
    }
}

