/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.security;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.ha.DistributedLockManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.lockmanager.file.FileBasedLockManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQBasicSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.util.ReplicatedBackupUtils;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LockManagerBasicSecurityManagerFailoverTest
extends FailoverTestBase {
    @Override
    protected void createConfigs() throws Exception {
        this.createPluggableReplicatedConfigs();
    }

    @Override
    protected void createPluggableReplicatedConfigs() throws Exception {
        TransportConfiguration primaryConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        TransportConfiguration backupAcceptor = this.getAcceptorTransportConfiguration(false);
        this.backupConfig = this.createDefaultInVMConfig();
        this.primaryConfig = this.createDefaultInVMConfig();
        DistributedLockManagerConfiguration managerConfiguration = new DistributedLockManagerConfiguration(FileBasedLockManager.class.getName(), Collections.singletonMap("locks-folder", LockManagerBasicSecurityManagerFailoverTest.newFolder(this.temporaryFolder, "manager").toString()));
        ReplicatedBackupUtils.configurePluggableQuorumReplicationPair(this.backupConfig, backupConnector, backupAcceptor, this.primaryConfig, primaryConnector, null, managerConfiguration, managerConfiguration);
        this.backupConfig.setSecurityEnabled(true).setBindingsDirectory(this.getBindingsDir(0, true)).setJournalDirectory(this.getJournalDir(0, true)).setPagingDirectory(this.getPageDir(0, true)).setLargeMessagesDirectory(this.getLargeMessagesDir(0, true));
        this.setupHAPolicyConfiguration();
        this.backupNodeManager = this.createReplicatedBackupNodeManager(this.backupConfig);
        this.backupServer = this.createTestableServer(this.backupConfig, this.backupNodeManager);
        this.backupServer.getServer().setSecurityManager((ActiveMQSecurityManager)new ActiveMQBasicSecurityManager());
        this.primaryConfig.setSecurityEnabled(true).clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true));
        this.nodeManager = this.createNodeManager(this.primaryConfig);
        this.primaryServer = this.createTestableServer(this.primaryConfig, this.nodeManager);
        this.primaryServer.getServer().setSecurityManager((ActiveMQSecurityManager)new ActiveMQBasicSecurityManager());
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }

    @Override
    protected void setupHAPolicyConfiguration() {
        ((ReplicationBackupPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setMaxSavedReplicatedJournalsSize(2).setAllowFailBack(true);
    }

    @Test
    public void testFailover() throws Exception {
        this.primaryServer.getServer().getActiveMQServerControl().addUser("foo", "bar", "baz", false);
        ClientSessionFactory cf = this.createSessionFactory((ServerLocator)this.getServerLocator());
        ClientSession session = null;
        try {
            session = cf.createSession("foo", "bar", false, true, true, false, 0);
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assertions.fail((String)"should not throw exception");
        }
        this.crash(session);
        this.waitForServerToStart(this.backupServer.getServer());
        try {
            cf = this.createSessionFactory((ServerLocator)this.getServerLocator());
            session = cf.createSession("foo", "bar", false, true, true, false, 0);
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assertions.fail((String)"should not throw exception");
        }
    }

    private static File newFolder(File root, String ... subDirs) throws IOException {
        String subFolder = String.join((CharSequence)"/", subDirs);
        File result = new File(root, subFolder);
        if (!result.mkdirs()) {
            throw new IOException("Couldn't create folders " + root);
        }
        return result;
    }
}

