/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.File;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.StartException;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;

abstract class ElytronDoohickey<T>
implements ExceptionFunction<OperationContext, T, OperationFailedException> {
    private static final ThreadLocal<Deque<PathAddress>> CALL_STACK = new ThreadLocal(){

        protected Deque<PathAddress> initialValue() {
            return new ArrayDeque<PathAddress>();
        }
    };
    private static final Lock GLOBAL_LOCK = new ReentrantLock();
    private final PathAddress resourceAddress;
    private volatile boolean modelResolved = false;
    private volatile ExceptionSupplier<T, StartException> serviceValueSupplier;
    private volatile T value;

    protected ElytronDoohickey(PathAddress resourceAddress) {
        this.resourceAddress = (PathAddress)Assert.checkNotNullParam((String)"resourceAddress", (Object)resourceAddress);
    }

    public final T apply(OperationContext foreignContext) throws OperationFailedException {
        if (this.value == null) {
            GLOBAL_LOCK.lock();
            try {
                this.checkCycle();
                try {
                    if (this.value == null) {
                        if (foreignContext == null) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.illegalNonManagementInitialization(this.getClass());
                        }
                        this.resolveRuntime(foreignContext, true);
                        this.value = this.createImmediately(foreignContext);
                    }
                }
                finally {
                    CALL_STACK.get().removeFirst();
                }
            }
            finally {
                GLOBAL_LOCK.unlock();
            }
        }
        return this.value;
    }

    public final T get() throws StartException {
        if (this.value == null) {
            GLOBAL_LOCK.lock();
            try {
                this.checkCycle();
                try {
                    if (this.value == null) {
                        this.value = this.serviceValueSupplier.get();
                    }
                }
                finally {
                    CALL_STACK.get().removeFirst();
                }
            }
            catch (OperationFailedException e) {
                throw new StartException((Throwable)e);
            }
            finally {
                GLOBAL_LOCK.unlock();
            }
        }
        return this.value;
    }

    public final void prepareService(OperationContext context, CapabilityServiceBuilder<?> serviceBuilder) throws OperationFailedException {
        this.serviceValueSupplier = this.prepareServiceSupplier(context, serviceBuilder);
    }

    public final void resolveRuntime(OperationContext foreignContext) throws OperationFailedException {
        this.resolveRuntime(foreignContext, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void resolveRuntime(OperationContext foreignContext, boolean skipCycleCheck) throws OperationFailedException {
        if (!this.modelResolved && this.value == null) {
            GLOBAL_LOCK.lock();
            try {
                if (!skipCycleCheck) {
                    this.checkCycle();
                }
                try {
                    if (!this.modelResolved) {
                        ModelNode model = foreignContext.readResourceFromRoot(this.resourceAddress).getModel();
                        this.resolveRuntime(model, foreignContext);
                        this.modelResolved = true;
                    }
                }
                finally {
                    if (!skipCycleCheck) {
                        CALL_STACK.get().removeFirst();
                    }
                }
            }
            finally {
                GLOBAL_LOCK.unlock();
            }
        }
    }

    protected File resolveRelativeToImmediately(String path, String relativeTo, OperationContext foreignContext) {
        FileAttributeDefinitions.PathResolver pathResolver = FileAttributeDefinitions.pathResolver();
        pathResolver.path(path);
        if (relativeTo != null) {
            PathManager pathManager = (PathManager)foreignContext.getServiceRegistry(false).getRequiredService(PathManagerService.SERVICE_NAME).getValue();
            pathResolver.relativeTo(relativeTo, pathManager);
        }
        File resolved = pathResolver.resolve();
        pathResolver.clear();
        return resolved;
    }

    private void checkCycle() throws OperationFailedException {
        Deque<PathAddress> currentStack = CALL_STACK.get();
        if (currentStack.contains(this.resourceAddress)) {
            StringBuilder sb = new StringBuilder();
            Iterator<PathAddress> iterator = currentStack.descendingIterator();
            boolean foundStart = false;
            while (iterator.hasNext()) {
                PathAddress current = iterator.next();
                if (!(foundStart = foundStart || current.equals(this.resourceAddress))) continue;
                sb.append('{').append(current.toString()).append("}->");
            }
            sb.append('{').append(this.resourceAddress.toString()).append('}');
            throw ElytronSubsystemMessages.ROOT_LOGGER.cycleDetected(sb.toString());
        }
        currentStack.addFirst(this.resourceAddress);
    }

    protected abstract void resolveRuntime(ModelNode var1, OperationContext var2) throws OperationFailedException;

    protected abstract ExceptionSupplier<T, StartException> prepareServiceSupplier(OperationContext var1, CapabilityServiceBuilder<?> var2) throws OperationFailedException;

    protected abstract T createImmediately(OperationContext var1) throws OperationFailedException;
}

