/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.select;

import org.hibernate.query.NullPrecedence;
import org.hibernate.query.SortDirection;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;

public class SortSpecification
implements SqlAstNode {
    private final Expression sortExpression;
    private final SortDirection sortOrder;
    private final NullPrecedence nullPrecedence;
    private final boolean ignoreCase;

    public SortSpecification(Expression sortExpression, SortDirection sortOrder) {
        this(sortExpression, sortOrder, NullPrecedence.NONE);
    }

    public SortSpecification(Expression sortExpression, SortDirection sortOrder, NullPrecedence nullPrecedence) {
        this(sortExpression, sortOrder, nullPrecedence, false);
    }

    public SortSpecification(Expression sortExpression, SortDirection sortOrder, NullPrecedence nullPrecedence, boolean ignoreCase) {
        assert (sortExpression != null);
        assert (sortOrder != null);
        assert (nullPrecedence != null);
        this.sortExpression = sortExpression;
        this.sortOrder = sortOrder;
        this.nullPrecedence = nullPrecedence;
        this.ignoreCase = ignoreCase;
    }

    public Expression getSortExpression() {
        return this.sortExpression;
    }

    public SortDirection getSortOrder() {
        return this.sortOrder;
    }

    public NullPrecedence getNullPrecedence() {
        return this.nullPrecedence;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitSortSpecification(this);
    }
}

