/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr.cli;

import java.util.List;
import java.util.Set;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.aesh.command.option.OptionList;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;
import org.wildfly.core.instmgr.cli.AbstractInstMgrCommand;
import org.wildfly.core.instmgr.cli.ChannelListCommand;
import org.wildfly.core.instmgr.cli.InstMgrActivator;

@CommandDefinition(name="channel-edit", description="Edit a channel subscription.", activator=InstMgrActivator.class)
public class ChannelEditCommand
extends AbstractInstMgrCommand {
    @Option(name="channel-name", required=true)
    String channelName;
    @Option(name="manifest", required=true)
    String manifest;
    @OptionList(name="repositories", required=true)
    private List<String> repositories;

    @Override
    protected Operation buildOperation() throws CommandException {
        ModelNode op = new ModelNode();
        op.get("operation").set("write-attribute");
        op.get("name").set("channels");
        ModelNode channel = new ModelNode();
        channel.get("name").set(this.channelName);
        ChannelEditCommand.addManifestToModelNode(channel, this.manifest);
        ChannelEditCommand.addRepositoriesToModelNode(channel, this.repositories);
        ModelNode channels = new ModelNode().addEmptyList();
        channels.add(channel);
        op.get("value").set(channels);
        return OperationBuilder.create((ModelNode)op).build();
    }

    @Override
    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        CommandContext ctx = commandInvocation.getCommandContext();
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            ctx.printLine("You are disconnected at the moment. Type 'connect' to connect to the server or 'help' for the list of supported commands.");
            return CommandResult.FAILURE;
        }
        Set<String> allChannelNames = new ChannelListCommand().getAllChannelNames(ctx, this.host);
        if (!allChannelNames.contains(this.channelName)) {
            throw new CommandException(String.format("Channel '%s' is not present.", this.channelName));
        }
        this.executeOp(commandInvocation.getCommandContext(), this.host);
        ctx.printLine("Channel '" + this.channelName + "' has been modified.");
        return CommandResult.SUCCESS;
    }
}

