/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import javax.sql.DataSource;
import org.jboss.as.connector.subsystems.common.jndi.Constants;
import org.jboss.as.connector.subsystems.datasources.DataSourceConfigService;
import org.jboss.as.connector.subsystems.datasources.DataSourceReferenceFactoryService;
import org.jboss.as.connector.subsystems.datasources.XADataSourceConfigService;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

public class DataSourceRemove
extends AbstractRemoveStepHandler {
    static final DataSourceRemove INSTANCE = new DataSourceRemove(false);
    static final DataSourceRemove XA_INSTANCE = new DataSourceRemove(true);
    private final boolean isXa;

    private DataSourceRemove(boolean isXa) {
        this.isXa = isXa;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isResourceServiceRestartAllowed()) {
            ModelNode address = operation.require("address");
            String dsName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
            String jndiName = Constants.JNDI_NAME.resolveModelAttribute(context, model).asString();
            ServiceName dataSourceServiceName = context.getCapabilityServiceName("org.wildfly.data-source", dsName, DataSource.class);
            ServiceName dataSourceCongServiceName = DataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{dsName});
            ServiceName xaDataSourceConfigServiceName = XADataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{dsName});
            ServiceName driverDemanderServiceName = ServiceName.JBOSS.append(new String[]{"driver-demander"}).append(new String[]{jndiName});
            ServiceName referenceFactoryServiceName = DataSourceReferenceFactoryService.SERVICE_NAME_BASE.append(new String[]{dsName});
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
            context.removeService(bindInfo.getBinderServiceName());
            context.removeService(referenceFactoryServiceName);
            context.removeService(dataSourceServiceName.append(new String[]{"statistics"}));
            if (!this.isXa) {
                context.removeService(dataSourceCongServiceName);
            } else {
                context.removeService(xaDataSourceConfigServiceName);
            }
            context.removeService(dataSourceServiceName);
            context.removeService(driverDemanderServiceName);
        } else {
            context.reloadRequired();
        }
    }
}

