/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.CharacterHandlerMap;
import org.jboss.as.cli.parsing.DefaultCharacterHandlerMap;
import org.jboss.as.cli.parsing.ErrorCharacterHandler;
import org.jboss.as.cli.parsing.ExpressionBaseState;
import org.jboss.as.cli.parsing.GlobalCharacterHandlers;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.command.ArgumentValueNotFinishedException;

public class DefaultStateWithEndCharacter
extends ExpressionBaseState {
    private final char leaveStateChar;

    public static Builder builder(String id) {
        return new Builder(id);
    }

    DefaultStateWithEndCharacter(String id, char leaveStateChar) {
        this(id, leaveStateChar, true);
    }

    DefaultStateWithEndCharacter(String id, char leaveStateChar, boolean endRequired) {
        this(id, leaveStateChar, endRequired, false);
    }

    public DefaultStateWithEndCharacter(String id, char leaveStateChar, boolean endRequired, boolean enterLeaveContent) {
        this(id, leaveStateChar, endRequired, enterLeaveContent, new DefaultCharacterHandlerMap());
    }

    public DefaultStateWithEndCharacter(String id, char leaveStateChar, boolean endRequired, boolean enterLeaveContent, CharacterHandlerMap enterStateHandlers) {
        this(id, leaveStateChar, endRequired, enterLeaveContent, enterStateHandlers, true);
    }

    private DefaultStateWithEndCharacter(String id, final char leaveStateChar, boolean endRequired, boolean enterLeaveContent, CharacterHandlerMap enterStateHandlers, boolean resolveSystemProperties) {
        super(id, enterLeaveContent, enterStateHandlers, resolveSystemProperties);
        this.leaveStateChar = leaveStateChar;
        if (enterLeaveContent) {
            this.setLeaveHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    if (ctx.getCharacter() == leaveStateChar && !ctx.isEndOfContent()) {
                        GlobalCharacterHandlers.CONTENT_CHARACTER_HANDLER.handle(ctx);
                    }
                }
            });
        }
        if (endRequired) {
            this.setEndContentHandler(new ErrorCharacterHandler("Closing '" + leaveStateChar + "' is missing."));
        } else {
            this.setEndContentHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    ctx.setError(new ArgumentValueNotFinishedException("Closing '" + leaveStateChar + "' is missing"));
                }
            });
        }
        this.setDefaultHandler(GlobalCharacterHandlers.CONTENT_CHARACTER_HANDLER);
    }

    @Override
    public CharacterHandler getHandler(char ch) {
        return this.leaveStateChar == ch ? GlobalCharacterHandlers.LEAVE_STATE_HANDLER : super.getHandler(ch);
    }

    public static class Builder {
        private String id;
        private char leaveStateChar;
        private boolean endRequired;
        private boolean enterLeaveContent;
        private CharacterHandlerMap enterStateHandlers;
        private boolean resolveSystemProperties = true;

        private Builder(String id) {
            this.id = id;
        }

        public Builder setLeaveStateChar(char leaveStateChar) {
            this.leaveStateChar = leaveStateChar;
            return this;
        }

        public Builder setEndRequired(boolean endRequired) {
            this.endRequired = endRequired;
            return this;
        }

        public Builder setEnterLeaveContent(boolean enterLeaveContent) {
            this.enterLeaveContent = enterLeaveContent;
            return this;
        }

        public Builder setEnterStateHandlers(CharacterHandlerMap enterStateHandlers) {
            this.enterStateHandlers = enterStateHandlers;
            return this;
        }

        public Builder setResolveSystemProperties(boolean resolveSystemProperties) {
            this.resolveSystemProperties = resolveSystemProperties;
            return this;
        }

        public DefaultStateWithEndCharacter build() {
            return new DefaultStateWithEndCharacter(this.id, this.leaveStateChar, this.endRequired, this.enterLeaveContent, this.enterStateHandlers, this.resolveSystemProperties);
        }
    }
}

