/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.launcher;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.wildfly.core.launcher.Arguments;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Environment;
import org.wildfly.core.launcher.JBossModulesCommandBuilder;
import org.wildfly.core.launcher.Jvm;
import org.wildfly.core.launcher.logger.LauncherMessages;

public class CliCommandBuilder
implements CommandBuilder {
    private static final Path cliClientJar = Paths.get("bin", new String[0]).resolve("client").resolve("jboss-cli-client.jar");
    private final Environment environment;
    private final Arguments javaOpts;
    private final Arguments cliArgs;
    private final boolean modularLauncher;

    private CliCommandBuilder(Environment environment, boolean modularLauncher) {
        this.environment = environment;
        this.modularLauncher = modularLauncher;
        this.javaOpts = new Arguments();
        this.cliArgs = new Arguments();
        if (modularLauncher) {
            this.javaOpts.add("-Dlogging.configuration=file:" + String.valueOf(environment.resolvePath("bin", "jboss-cli-logging.properties")));
        }
    }

    public static CliCommandBuilder asModularLauncher(Path wildflyHome) {
        return new CliCommandBuilder(new Environment(wildflyHome), true);
    }

    public static CliCommandBuilder asModularLauncher(String wildflyHome) {
        return new CliCommandBuilder(new Environment(wildflyHome), true);
    }

    public static CliCommandBuilder of(Path wildflyHome) {
        return CliCommandBuilder.asModularLauncher(wildflyHome);
    }

    public static CliCommandBuilder of(String wildflyHome) {
        return CliCommandBuilder.asModularLauncher(wildflyHome);
    }

    public static CliCommandBuilder asJarLauncher(Path wildflyHome) {
        Environment environment = new Environment(wildflyHome);
        Environment.validateJar(environment.getWildflyHome().resolve(cliClientJar));
        return new CliCommandBuilder(environment, false);
    }

    public static CliCommandBuilder asJarLauncher(String wildflyHome) {
        Environment environment = new Environment(wildflyHome);
        Environment.validateJar(environment.getWildflyHome().resolve(cliClientJar));
        return new CliCommandBuilder(environment, false);
    }

    public CliCommandBuilder setConnection(String controller) {
        this.addCliArgument(CliArgument.CONNECT);
        this.setController(controller);
        return this;
    }

    public CliCommandBuilder setConnection(String hostname, int port) {
        this.addCliArgument(CliArgument.CONNECT);
        this.setController(hostname, port);
        return this;
    }

    public CliCommandBuilder setConnection(String protocol, String hostname, int port) {
        this.addCliArgument(CliArgument.CONNECT);
        this.setController(protocol, hostname, port);
        return this;
    }

    public CliCommandBuilder setController(String controller) {
        this.addCliArgument(CliArgument.CONTROLLER, controller);
        return this;
    }

    public CliCommandBuilder setController(String hostname, int port) {
        this.setController(CliCommandBuilder.formatAddress(null, hostname, port));
        return this;
    }

    public CliCommandBuilder setController(String protocol, String hostname, int port) {
        this.setController(CliCommandBuilder.formatAddress(protocol, hostname, port));
        return this;
    }

    public CliCommandBuilder setUser(String user) {
        this.addCliArgument(CliArgument.USER, user);
        return this;
    }

    public CliCommandBuilder setPassword(String password) {
        this.addCliArgument(CliArgument.PASSWORD, password);
        return this;
    }

    public CliCommandBuilder setScriptFile(String path) {
        if (path == null) {
            this.addCliArgument(CliArgument.FILE, null);
            return this;
        }
        return this.setScriptFile(Paths.get(path, new String[0]));
    }

    public CliCommandBuilder setScriptFile(Path path) {
        if (path == null) {
            this.addCliArgument(CliArgument.FILE, null);
        } else {
            if (Files.notExists(path, new LinkOption[0])) {
                throw LauncherMessages.MESSAGES.pathDoesNotExist(path);
            }
            this.addCliArgument(CliArgument.FILE, path.toString());
        }
        return this;
    }

    public CliCommandBuilder setCommand(String command) {
        this.addCliArgument(CliArgument.COMMAND, command);
        return this;
    }

    public CliCommandBuilder setCommands(String ... commands) {
        if (commands == null || commands.length == 0) {
            this.addCliArgument(CliArgument.COMMANDS, null);
            return this;
        }
        return this.setCommands(Arrays.asList(commands));
    }

    public CliCommandBuilder setCommands(Iterable<String> commands) {
        if (commands == null) {
            this.addCliArgument(CliArgument.COMMANDS, null);
            return this;
        }
        StringBuilder cmds = new StringBuilder();
        Iterator<String> iterator = commands.iterator();
        while (iterator.hasNext()) {
            cmds.append(iterator.next());
            if (!iterator.hasNext()) continue;
            cmds.append(',');
        }
        this.addCliArgument(CliArgument.COMMANDS, cmds.toString());
        return this;
    }

    public CliCommandBuilder setTimeout(int timeout) {
        if (timeout > 0) {
            this.addCliArgument(CliArgument.TIMEOUT, Integer.toString(timeout));
        } else {
            this.addCliArgument(CliArgument.TIMEOUT, null);
        }
        return this;
    }

    public CliCommandBuilder setUseGui() {
        if (Environment.isMac()) {
            this.addJavaOption("-Djboss.modules.system.pkgs=com.apple.laf,com.apple.laf.resources");
        } else {
            this.addJavaOption("-Djboss.modules.system.pkgs=com.sun.java.swing");
        }
        this.addCliArgument(CliArgument.GUI);
        return this;
    }

    public CliCommandBuilder addJavaOption(String jvmArg) {
        if (jvmArg != null && !jvmArg.trim().isEmpty()) {
            this.javaOpts.add(jvmArg);
        }
        return this;
    }

    public CliCommandBuilder addJavaOptions(String ... javaOpts) {
        if (javaOpts != null) {
            for (String javaOpt : javaOpts) {
                this.addJavaOption(javaOpt);
            }
        }
        return this;
    }

    public CliCommandBuilder addJavaOptions(Iterable<String> javaOpts) {
        if (javaOpts != null) {
            for (String javaOpt : javaOpts) {
                this.addJavaOption(javaOpt);
            }
        }
        return this;
    }

    public CliCommandBuilder setJavaOptions(Iterable<String> javaOpts) {
        this.javaOpts.clear();
        return this.addJavaOptions(javaOpts);
    }

    public CliCommandBuilder setJavaOptions(String ... javaOpts) {
        this.javaOpts.clear();
        return this.addJavaOptions(javaOpts);
    }

    public List<String> getJavaOptions() {
        return this.javaOpts.asList();
    }

    public CliCommandBuilder addCliArgument(String arg) {
        if (arg != null) {
            Arguments.Argument argument = Arguments.parse(arg);
            CliArgument cliArgument = CliArgument.find(argument.getKey());
            if (cliArgument != null && cliArgument.altKey != null) {
                this.cliArgs.remove(cliArgument.altKey);
            }
            this.cliArgs.set(argument);
        }
        return this;
    }

    public CliCommandBuilder addCliArguments(String ... args) {
        if (args != null) {
            for (String arg : args) {
                this.addCliArgument(arg);
            }
        }
        return this;
    }

    public CliCommandBuilder addCliArguments(Iterable<String> args) {
        if (args != null) {
            for (String arg : args) {
                this.addCliArgument(arg);
            }
        }
        return this;
    }

    public CliCommandBuilder addModuleDir(String moduleDir) {
        this.environment.addModuleDir(moduleDir);
        return this;
    }

    public CliCommandBuilder addModuleDirs(String ... moduleDirs) {
        this.environment.addModuleDirs(moduleDirs);
        return this;
    }

    public CliCommandBuilder addModuleDirs(Iterable<String> moduleDirs) {
        this.environment.addModuleDirs(moduleDirs);
        return this;
    }

    public CliCommandBuilder setModuleDirs(Iterable<String> moduleDirs) {
        this.environment.setModuleDirs(moduleDirs);
        return this;
    }

    public CliCommandBuilder setModuleDirs(String ... moduleDirs) {
        this.environment.setModuleDirs(moduleDirs);
        return this;
    }

    public String getModulePaths() {
        return this.environment.getModulePaths();
    }

    public CliCommandBuilder setJavaHome(String javaHome) {
        this.environment.setJvm(Jvm.of(javaHome));
        return this;
    }

    public CliCommandBuilder setJavaHome(Path javaHome) {
        this.environment.setJvm(Jvm.of(javaHome));
        return this;
    }

    public Path getJavaHome() {
        return this.environment.getJvm().getPath();
    }

    @Override
    public List<String> buildArguments() {
        ArrayList<String> cmd = new ArrayList<String>(this.getJavaOptions());
        if (this.modularLauncher && this.environment.getJvm().isModular()) {
            cmd.addAll(JBossModulesCommandBuilder.DEFAULT_MODULAR_VM_ARGUMENTS);
            for (String optionalModularArgument : JBossModulesCommandBuilder.OPTIONAL_DEFAULT_MODULAR_VM_ARGUMENTS) {
                if (!Jvm.isPackageAvailable(this.environment.getJvm().getPath(), optionalModularArgument)) continue;
                cmd.add(optionalModularArgument);
            }
        }
        if (this.environment.getJvm().enhancedSecurityManagerAvailable()) {
            cmd.add("-Djava.security.manager=allow");
        }
        cmd.add("-jar");
        if (this.modularLauncher) {
            cmd.add(this.environment.getModuleJar().toString());
            cmd.add("-mp");
            cmd.add(this.getModulePaths());
            cmd.add("org.jboss.as.cli");
            cmd.add("-Djboss.home.dir=" + String.valueOf(this.environment.getWildflyHome()));
        } else {
            cmd.add(this.environment.getWildflyHome().resolve(cliClientJar).toString());
        }
        cmd.addAll(this.cliArgs.asList());
        return cmd;
    }

    @Override
    public List<String> build() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.environment.getJvm().getCommand());
        cmd.addAll(this.buildArguments());
        return cmd;
    }

    private CliCommandBuilder addCliArgument(CliArgument cliArgument) {
        if (cliArgument.altKey != null) {
            this.cliArgs.remove(cliArgument.altKey);
        }
        this.cliArgs.set(Arguments.parse(cliArgument.key));
        return this;
    }

    private CliCommandBuilder addCliArgument(CliArgument cliArgument, String value) {
        if (cliArgument.altKey != null) {
            this.cliArgs.remove(cliArgument.altKey);
        }
        this.cliArgs.set(cliArgument.key, value);
        return this;
    }

    private static String formatAddress(String protocol, String hostname, int port) {
        char first = hostname.charAt(0);
        if (first == '[' && hostname.charAt(hostname.length() - 1) != ']') {
            throw LauncherMessages.MESSAGES.invalidHostname(hostname);
        }
        boolean wrapIpv6 = false;
        if (first != '[' && (first == ':' || Character.digit(first, 16) != -1)) {
            int counter = 0;
            for (char c : hostname.toCharArray()) {
                if (c == ':') {
                    ++counter;
                } else if (Character.digit(c, 16) == -1) break;
                if (counter <= 1) continue;
                wrapIpv6 = true;
                break;
            }
        }
        if (protocol == null) {
            if (wrapIpv6) {
                return String.format("[%s]:%d", hostname, port);
            }
            return String.format("%s:%d", hostname, port);
        }
        if (wrapIpv6) {
            return String.format("%s://[%s]:%d", protocol, hostname, port);
        }
        return String.format("%s://%s:%d", protocol, hostname, port);
    }

    static enum CliArgument {
        CONNECT("--connect", "-c"),
        CONTROLLER("--controller", "controller"),
        GUI("--gui"),
        FILE("--file"),
        COMMAND("--command"),
        COMMANDS("--commands"),
        USER("--user", "-u"),
        PASSWORD("--password", "-p"),
        TIMEOUT("--timeout");

        private static final Map<String, CliArgument> ENTRIES;
        private final String key;
        private final String altKey;

        public static CliArgument find(String key) {
            return ENTRIES.get(key);
        }

        public static CliArgument find(Arguments.Argument argument) {
            return ENTRIES.get(argument.getKey());
        }

        private CliArgument(String key) {
            this(key, null);
        }

        private CliArgument(String key, String altKey) {
            this.key = key;
            this.altKey = altKey;
        }

        static {
            HashMap<String, CliArgument> map = new HashMap<String, CliArgument>();
            for (CliArgument arg : CliArgument.values()) {
                map.put(arg.key, arg);
                if (arg.altKey == null) continue;
                map.put(arg.altKey, arg);
            }
            ENTRIES = Collections.unmodifiableMap(map);
        }
    }
}

