/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.notification.Notification;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.ContentServitor;
import org.jboss.as.server.deployment.DeploymentAddHandler;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.as.server.deployment.DeploymentMountProvider;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.ManagedExplodedContentServitor;
import org.jboss.as.server.deployment.ModelContentReference;
import org.jboss.as.server.deployment.PathContentServitor;
import org.jboss.as.server.deployment.RootDeploymentUnitService;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.annotation.AnnotationIndexSupport;
import org.jboss.as.server.deployment.transformation.DeploymentTransformer;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayIndex;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class DeploymentHandlerUtil {
    private static final OperationContext.AttachmentKey<AnnotationIndexSupport> ANNOTATION_INDEX_SUPPORT = OperationContext.AttachmentKey.create(AnnotationIndexSupport.class);
    private static final String MANAGED_CONTENT = "managed-exploded";

    private DeploymentHandlerUtil() {
    }

    public static void deploy(OperationContext context, ModelNode operation, final String deploymentUnitName, final String managementName, final ContentItem ... contents) throws OperationFailedException {
        assert (contents != null) : "contents is null";
        if (context.isNormalServer()) {
            PathAddress deploymentsAddress = context.getCurrentAddress().getParent();
            Resource deploymentsParentResource = context.readResourceFromRoot(deploymentsAddress);
            for (Resource.ResourceEntry deployment : deploymentsParentResource.getChildren("deployment")) {
                ModelNode deploymentModel;
                if (managementName.equals(deployment.getName()) || !deploymentUnitName.equals(DeploymentAttributes.RUNTIME_NAME.resolveModelAttribute(context, deploymentModel = deployment.getModel()).asString()) || !DeploymentAttributes.ENABLED.resolveModelAttribute(context, deploymentModel).asBoolean()) continue;
                throw ServerLogger.ROOT_LOGGER.runtimeNameMustBeUnique(managementName, deploymentUnitName);
            }
            final Resource deployment = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            final ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
            final ManagementResourceRegistration mutableRegistration = context.getResourceRegistrationForUpdate();
            DeploymentResourceSupport.cleanup(deployment);
            ModelNode notificationData = new ModelNode();
            notificationData.get("name").set(managementName);
            notificationData.get("server-booting").set(context.isBooting());
            if (operation.hasDefined(DeploymentAttributes.OWNER.getName())) {
                try {
                    notificationData.get(DeploymentAttributes.OWNER.getName()).set(DeploymentAttributes.OWNER.resolveModelAttribute(context, operation));
                }
                catch (OperationFailedException operationFailedException) {
                    // empty catch block
                }
            }
            notificationData.get("deployment").set(deploymentUnitName);
            context.emit(new Notification("deployment-deployed", context.getCurrentAddress(), ServerLogger.ROOT_LOGGER.deploymentDeployedNotification(managementName, deploymentUnitName), notificationData));
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) {
                    ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
                    ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
                    final ServiceController deploymentController = serviceRegistry.getService(deploymentUnitServiceName);
                    if (deploymentController != null) {
                        deploymentController.setMode(ServiceController.Mode.ACTIVE);
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                deploymentController.setMode(ServiceController.Mode.NEVER);
                            }
                        });
                    } else {
                        DeploymentHandlerUtil.doDeploy(context, deploymentUnitName, managementName, deployment, registration, mutableRegistration, contents);
                        context.completeStep(new OperationContext.ResultHandler(){

                            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                                if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                                    if (context.hasFailureDescription()) {
                                        ServerLogger.ROOT_LOGGER.deploymentRolledBack(deploymentUnitName, DeploymentHandlerUtil.getFormattedFailureDescription(context));
                                    } else {
                                        ServerLogger.ROOT_LOGGER.deploymentRolledBackWithNoMessage(deploymentUnitName);
                                    }
                                } else {
                                    ServerLogger.ROOT_LOGGER.deploymentDeployed(managementName, deploymentUnitName);
                                }
                            }
                        });
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    public static void doDeploy(OperationContext context, String deploymentUnitName, String managementName, Resource deploymentResource, ImmutableManagementResourceRegistration registration, ManagementResourceRegistration mutableRegistration, ContentItem ... contents) {
        Object contentService;
        ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceName contentsServiceName = deploymentUnitServiceName.append(new String[]{"contents"});
        boolean isExplodedContent = false;
        if (contents[0].hash != null) {
            if (contents[0].isArchive) {
                contentService = ContentServitor.addService(serviceTarget, contentsServiceName, contents[0].hash);
            } else {
                isExplodedContent = true;
                contentService = ManagedExplodedContentServitor.addService(context, contentsServiceName, managementName, contents[0].hash);
            }
        } else {
            String path = contents[0].path;
            String relativeTo = contents[0].relativeTo;
            contentService = PathContentServitor.addService(context, serviceTarget, contentsServiceName, path, relativeTo);
        }
        DeploymentOverlayIndex overlays = DeploymentOverlayIndex.createDeploymentOverlayIndex(context);
        AnnotationIndexSupport annotationIndexSupport = DeploymentHandlerUtil.getAnnotationIndexCache(context);
        ServiceBuilder sb = serviceTarget.addService(deploymentUnitServiceName);
        Consumer deploymentUnitConsumer = sb.provides(new ServiceName[]{deploymentUnitServiceName});
        Supplier serverDeploymentRepositorySupplier = sb.requires(DeploymentMountProvider.SERVICE_NAME);
        Supplier pathManagerSupplier = sb.requires(context.getCapabilityServiceName(PathManager.SERVICE_DESCRIPTOR));
        Supplier contentsSupplier = sb.requires(contentsServiceName);
        RootDeploymentUnitService service = new RootDeploymentUnitService(deploymentUnitConsumer, serverDeploymentRepositorySupplier, pathManagerSupplier, contentsSupplier, deploymentUnitName, managementName, null, context.getStability(), registration, mutableRegistration, deploymentResource, context.getCapabilityServiceSupport(), overlays, annotationIndexSupport, isExplodedContent);
        final ServiceController deploymentUnitController = sb.setInstance((Service)service).install();
        contentService.addListener(new LifecycleListener(){

            public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                if (event == LifecycleEvent.REMOVED) {
                    deploymentUnitController.setMode(ServiceController.Mode.REMOVE);
                }
            }
        });
    }

    public static void redeploy(OperationContext context, final String deploymentUnitName, final String managementName, final ContentItem ... contents) throws OperationFailedException {
        assert (contents != null) : "contents is null";
        if (context.isNormalServer()) {
            final Resource deployment = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            final ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
            final ManagementResourceRegistration mutableRegistration = context.getResourceRegistrationForUpdate();
            DeploymentResourceSupport.cleanup(deployment);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
                    context.removeService(deploymentUnitServiceName);
                    context.removeService(deploymentUnitServiceName.append(new String[]{"contents"}));
                    final AtomicBoolean logged = new AtomicBoolean(false);
                    context.addStep(new OperationStepHandler(){

                        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                            DeploymentHandlerUtil.doDeploy(context, deploymentUnitName, managementName, deployment, registration, mutableRegistration, contents);
                            context.completeStep(new OperationContext.ResultHandler(){

                                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                                    if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                                        if (context.hasFailureDescription()) {
                                            ServerLogger.ROOT_LOGGER.redeployRolledBack(deploymentUnitName, DeploymentHandlerUtil.getFormattedFailureDescription(context));
                                            logged.set(true);
                                        } else {
                                            ServerLogger.ROOT_LOGGER.redeployRolledBackWithNoMessage(deploymentUnitName);
                                            logged.set(true);
                                        }
                                    } else {
                                        ServerLogger.ROOT_LOGGER.deploymentRedeployed(deploymentUnitName);
                                    }
                                }
                            });
                        }
                    }, OperationContext.Stage.RUNTIME, true);
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            DeploymentHandlerUtil.doDeploy(context, deploymentUnitName, managementName, deployment, registration, mutableRegistration, contents);
                            if (!logged.get()) {
                                if (context.hasFailureDescription()) {
                                    ServerLogger.ROOT_LOGGER.undeploymentRolledBack(deploymentUnitName, context.getFailureDescription().asString());
                                } else {
                                    ServerLogger.ROOT_LOGGER.undeploymentRolledBackWithNoMessage(deploymentUnitName);
                                }
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    public static void replace(OperationContext context, final ModelNode originalDeployment, final String deploymentUnitName, final String managementName, final String replacedDeploymentUnitName, final ContentItem ... contents) throws OperationFailedException {
        assert (contents != null) : "contents is null";
        if (context.isNormalServer()) {
            PathElement path = PathElement.pathElement((String)"deployment", (String)managementName);
            final Resource deployment = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{path}));
            final ImmutableManagementResourceRegistration registration = context.getResourceRegistration().getSubModel(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{path}));
            final ManagementResourceRegistration mutableRegistration = context.getResourceRegistrationForUpdate().getSubModel(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{path}));
            DeploymentResourceSupport.cleanup(deployment);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceName replacedDeploymentUnitServiceName = Services.deploymentUnitName(replacedDeploymentUnitName);
                    ServiceName replacedContentsServiceName = replacedDeploymentUnitServiceName.append(new String[]{"contents"});
                    context.removeService(replacedContentsServiceName);
                    context.removeService(replacedDeploymentUnitServiceName);
                    DeploymentHandlerUtil.doDeploy(context, deploymentUnitName, managementName, deployment, registration, mutableRegistration, contents);
                    if (originalDeployment.hasDefined(DeploymentAttributes.PERSISTENT.getName()) && !DeploymentAttributes.PERSISTENT.resolveModelAttribute(context, originalDeployment).asBoolean() && DeploymentAttributes.PERSISTENT.resolveModelAttribute(context, operation).asBoolean()) {
                        ModelNode notificationData = new ModelNode();
                        notificationData.get("name").set(managementName);
                        notificationData.get("server-booting").set(context.isBooting());
                        if (operation.hasDefined(DeploymentAttributes.OWNER.getName())) {
                            try {
                                notificationData.get(DeploymentAttributes.OWNER.getName()).set(DeploymentAttributes.OWNER.resolveModelAttribute(context, operation));
                            }
                            catch (OperationFailedException operationFailedException) {
                                // empty catch block
                            }
                        }
                        notificationData.get("deployment").set(deploymentUnitName);
                        PathAddress pathAddress = context.getCurrentAddress().size() == 0 ? PathAddress.pathAddress((String)"deployment", (String)managementName) : context.getCurrentAddress();
                        context.emit(new Notification("deployment-undeployed", pathAddress, ServerLogger.ROOT_LOGGER.deploymentUndeployedNotification(managementName, deploymentUnitName), notificationData));
                    }
                    context.completeStep(new OperationContext.ResultHandler(){

                        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                            if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                                DeploymentResourceSupport.cleanup(deployment);
                                String runtimeName = originalDeployment.require("runtime-name").asString();
                                ContentItem[] contents = DeploymentHandlerUtils.getContents(originalDeployment.require("content"));
                                DeploymentHandlerUtil.doDeploy(context, runtimeName, managementName, deployment, registration, mutableRegistration, contents);
                                if (context.hasFailureDescription()) {
                                    ServerLogger.ROOT_LOGGER.replaceRolledBack(replacedDeploymentUnitName, deploymentUnitName, DeploymentHandlerUtil.getFormattedFailureDescription(context));
                                } else {
                                    ServerLogger.ROOT_LOGGER.replaceRolledBackWithNoMessage(replacedDeploymentUnitName, deploymentUnitName);
                                }
                            } else {
                                ServerLogger.ROOT_LOGGER.deploymentReplaced(replacedDeploymentUnitName, deploymentUnitName);
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    public static void undeploy(OperationContext context, ModelNode operation, final String managementName, final String runtimeName) {
        if (context.isNormalServer()) {
            PathAddress resourceAddress = context.getCurrentAddress().size() == 0 ? PathAddress.pathAddress((String)"deployment", (String)managementName) : PathAddress.EMPTY_ADDRESS;
            final Resource deployment = context.readResourceForUpdate(resourceAddress);
            final ImmutableManagementResourceRegistration registration = context.getResourceRegistration().getSubModel(resourceAddress);
            final ManagementResourceRegistration mutableRegistration = context.getResourceRegistrationForUpdate().getSubModel(resourceAddress);
            DeploymentResourceSupport.cleanup(deployment);
            ModelNode notificationData = new ModelNode();
            notificationData.get("name").set(managementName);
            notificationData.get("server-booting").set(context.isBooting());
            if (operation.hasDefined(DeploymentAttributes.OWNER.getName())) {
                try {
                    notificationData.get(DeploymentAttributes.OWNER.getName()).set(DeploymentAttributes.OWNER.resolveModelAttribute(context, operation));
                }
                catch (OperationFailedException operationFailedException) {
                    // empty catch block
                }
            }
            notificationData.get("deployment").set(runtimeName);
            PathAddress pathAddress = context.getCurrentAddress().size() == 0 ? PathAddress.pathAddress((String)"deployment", (String)managementName) : context.getCurrentAddress();
            context.emit(new Notification("deployment-undeployed", pathAddress, ServerLogger.ROOT_LOGGER.deploymentUndeployedNotification(managementName, runtimeName), notificationData));
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) {
                    ServiceName deploymentUnitServiceName = Services.deploymentUnitName(runtimeName);
                    context.removeService(deploymentUnitServiceName);
                    context.removeService(deploymentUnitServiceName.append(new String[]{"contents"}));
                    context.completeStep(new OperationContext.ResultHandler(){

                        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                            if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                                ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
                                ContentItem[] contents = DeploymentHandlerUtils.getContents(model.require("content"));
                                DeploymentHandlerUtil.doDeploy(context, runtimeName, managementName, deployment, registration, mutableRegistration, contents);
                                if (context.hasFailureDescription()) {
                                    ServerLogger.ROOT_LOGGER.undeploymentRolledBack(runtimeName, DeploymentHandlerUtil.getFormattedFailureDescription(context));
                                } else {
                                    ServerLogger.ROOT_LOGGER.undeploymentRolledBackWithNoMessage(runtimeName);
                                }
                            } else {
                                ServerLogger.ROOT_LOGGER.deploymentUndeployed(managementName, runtimeName);
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    public static boolean isManaged(ModelNode contentItem) {
        return !contentItem.hasDefined(DeploymentAttributes.CONTENT_PATH.getName());
    }

    public static boolean isArchive(ModelNode contentItem) {
        return contentItem.get(DeploymentAttributes.CONTENT_ARCHIVE.getName()).asBoolean(true);
    }

    public static ModelNode getContentItem(Resource resource) {
        return resource.getModel().get(DeploymentAttributes.CONTENT_RESOURCE_ALL.getName()).get(0);
    }

    static Path getExplodedDeploymentRoot(ServerEnvironment serverEnvironment, String deploymentManagementName) {
        return Paths.get(serverEnvironment.getServerDataDir().getAbsolutePath(), new String[0]).resolve(MANAGED_CONTENT).resolve(deploymentManagementName);
    }

    static DeploymentTransformer loadDeploymentTransformer() {
        Iterator<DeploymentTransformer> iter = ServiceLoader.load(DeploymentTransformer.class, DeploymentAddHandler.class.getClassLoader()).iterator();
        return iter.hasNext() ? iter.next() : null;
    }

    static InputStream transformDeploymentBytes(OperationContext context, ModelNode contentItemNode, String name, InputStream in, DeploymentTransformer deploymentTransformer) throws IOException, OperationFailedException {
        InputStream result = in;
        if (deploymentTransformer != null) {
            try {
                result = deploymentTransformer.transform(in, name);
            }
            catch (RuntimeException t) {
                if (!contentItemNode.hasDefined(DeploymentAttributes.CONTENT_INPUT_STREAM_INDEX.getName()) && t.getCause() != null && t.getCause().getCause() != null && t.getCause().getCause() instanceof IOException && t.getCause().getCause().getMessage().contains("during transformation. Error code 3")) {
                    ServerLogger.ROOT_LOGGER.tracef(t, "Ignoring transformation error and using original archive %s", name);
                    result = DeploymentHandlerUtils.getInputStream(context, contentItemNode);
                }
                throw t;
            }
        }
        return result;
    }

    private static String getFormattedFailureDescription(OperationContext context) {
        ModelNode failureDescNode = context.getFailureDescription();
        Object failureDesc = failureDescNode.toString();
        if (((String)failureDesc).contains("\n") && ((String)failureDesc).charAt(0) != '\n') {
            failureDesc = "\n" + (String)failureDesc;
        }
        return failureDesc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] addFromHash(ContentRepository contentRepository, ModelNode contentItemNode, String deploymentName, PathAddress address, OperationContext context) throws OperationFailedException {
        byte[] hash = contentItemNode.require(DeploymentAttributes.CONTENT_HASH.getName()).asBytes();
        ContentReference reference = ModelContentReference.fromModelAddress(address, hash);
        if (contentRepository.syncContent(reference)) return hash;
        if (!context.isBooting()) throw ServerLogger.ROOT_LOGGER.noSuchDeploymentContent(reference.getHexHash());
        if (context.getRunningMode() != RunningMode.ADMIN_ONLY) throw ServerLogger.ROOT_LOGGER.noSuchDeploymentContentAtBoot(reference.getHexHash(), deploymentName);
        ServerLogger.ROOT_LOGGER.reportAdminOnlyMissingDeploymentContent(reference.getHexHash(), deploymentName);
        return hash;
    }

    private static AnnotationIndexSupport getAnnotationIndexCache(OperationContext context) {
        AnnotationIndexSupport result = (AnnotationIndexSupport)context.getAttachment(ANNOTATION_INDEX_SUPPORT);
        if (result == null) {
            result = new AnnotationIndexSupport();
            context.attach(ANNOTATION_INDEX_SUPPORT, (Object)result);
        }
        return result;
    }

    static class ContentItem {
        private final byte[] hash;
        private final String path;
        private final String relativeTo;
        private final boolean isArchive;

        ContentItem(byte[] hash) {
            this(hash, true);
        }

        ContentItem(byte[] hash, boolean isArchive) {
            assert (hash != null) : "hash is null";
            this.hash = hash;
            this.isArchive = isArchive;
            this.path = null;
            this.relativeTo = null;
        }

        ContentItem(String path, String relativeTo, boolean isArchive) {
            assert (path != null) : "path is null";
            this.path = path;
            this.relativeTo = relativeTo;
            this.isArchive = isArchive;
            this.hash = null;
        }

        byte[] getHash() {
            return this.hash;
        }
    }
}

