/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Weigher;
import java.util.LinkedList;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.near.NearCache;
import org.infinispan.client.hotrod.near.NearCacheFactory;
import org.wildfly.clustering.cache.infinispan.CacheKey;
import org.wildfly.clustering.cache.infinispan.remote.near.CaffeineNearCache;
import org.wildfly.clustering.cache.infinispan.remote.near.EvictionListener;
import org.wildfly.clustering.cache.infinispan.remote.near.SimpleKeyWeigher;
import org.wildfly.clustering.session.infinispan.remote.attributes.SessionAttributesKey;
import org.wildfly.clustering.session.infinispan.remote.metadata.SessionAccessMetaDataKey;
import org.wildfly.clustering.session.infinispan.remote.metadata.SessionCreationMetaDataKey;

public class SessionManagerNearCacheFactory
implements NearCacheFactory {
    private final OptionalInt maxActiveSessions;

    public SessionManagerNearCacheFactory(OptionalInt maxActiveSessions) {
        this.maxActiveSessions = maxActiveSessions;
    }

    public <K, V> NearCache<K, V> createNearCache(NearCacheConfiguration config, BiConsumer<K, MetadataValue<V>> removedConsumer) {
        EvictionListener listener = this.maxActiveSessions.isPresent() ? new EvictionListener(removedConsumer, (BiConsumer)new InvalidationListener()) : null;
        Caffeine builder = Caffeine.newBuilder();
        if (listener != null) {
            builder.executor(Runnable::run).maximumWeight((long)this.maxActiveSessions.getAsInt()).weigher((Weigher)new SimpleKeyWeigher(SessionCreationMetaDataKey.class::isInstance)).removalListener((RemovalListener)listener);
        }
        Cache cache = builder.build();
        if (listener != null) {
            listener.accept(cache);
        }
        return new CaffeineNearCache(cache);
    }

    private static class InvalidationListener
    implements BiConsumer<Cache<Object, MetadataValue<Object>>, Map.Entry<Object, Object>> {
        private InvalidationListener() {
        }

        @Override
        public void accept(Cache<Object, MetadataValue<Object>> cache, Map.Entry<Object, Object> entry) {
            Object key = entry.getKey();
            if (key instanceof SessionCreationMetaDataKey) {
                String id = (String)((SessionCreationMetaDataKey)((Object)key)).getId();
                LinkedList<CacheKey> keys = new LinkedList<CacheKey>();
                keys.add(new SessionAccessMetaDataKey(id));
                keys.add(new SessionAttributesKey(id));
                cache.invalidateAll(keys);
            }
        }
    }
}

