/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.core.instmgr.AbstractInstMgrUpdateHandler;
import org.wildfly.core.instmgr.InstMgrResolver;
import org.wildfly.core.instmgr.InstMgrService;
import org.wildfly.core.instmgr.logging.InstMgrLogger;
import org.wildfly.installationmanager.ArtifactChange;
import org.wildfly.installationmanager.MavenOptions;
import org.wildfly.installationmanager.Repository;
import org.wildfly.installationmanager.spi.InstallationManager;
import org.wildfly.installationmanager.spi.InstallationManagerFactory;

public class InstMgrListUpdatesHandler
extends AbstractInstMgrUpdateHandler {
    static final String OPERATION_NAME = "list-updates";
    protected static final AttributeDefinition MAVEN_REPO_FILE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"maven-repo-file", (ModelType)ModelType.INT).setStorageRuntime()).setRequired(false)).build();
    protected static final AttributeDefinition MAVEN_REPO_FILES = ((SimpleListAttributeDefinition.Builder)((SimpleListAttributeDefinition.Builder)((SimpleListAttributeDefinition.Builder)new SimpleListAttributeDefinition.Builder("maven-repo-files", MAVEN_REPO_FILE).setStorageRuntime()).setRequired(false)).setAlternatives(new String[]{"repositories"})).build();
    protected static final AttributeDefinition REPOSITORIES = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("repositories", REPOSITORY).setStorageRuntime()).setRequired(false)).setAlternatives(new String[]{"maven-repo-files"})).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("list-updates", InstMgrResolver.RESOLVER).addParameter(OFFLINE).addParameter(REPOSITORIES).addParameter((AttributeDefinition)LOCAL_CACHE).addParameter(NO_RESOLVE_LOCAL_CACHE).addParameter(USE_DEFAULT_LOCAL_CACHE).addParameter(MAVEN_REPO_FILES).withFlags(new OperationEntry.Flag[]{OperationEntry.Flag.HOST_CONTROLLER_ONLY}).setRuntimeOnly().build();

    public InstMgrListUpdatesHandler(InstMgrService imService, InstallationManagerFactory imf) {
        super(imService, imf);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final boolean offline = OFFLINE.resolveModelAttribute(context, operation).asBoolean(false);
        String pathLocalRepo = LOCAL_CACHE.resolveModelAttribute(context, operation).asStringOrNull();
        final Boolean noResolveLocalCache = NO_RESOLVE_LOCAL_CACHE.resolveModelAttribute(context, operation).asBooleanOrNull();
        final Boolean useDefaultLocalCache = USE_DEFAULT_LOCAL_CACHE.resolveModelAttribute(context, operation).asBooleanOrNull();
        final Path localRepository = pathLocalRepo != null ? Path.of(pathLocalRepo, new String[0]) : null;
        final List mavenRepoFileIndexes = MAVEN_REPO_FILES.resolveModelAttribute(context, operation).asListOrEmpty();
        final List repositoriesMn = REPOSITORIES.resolveModelAttribute(context, operation).asListOrEmpty();
        if (noResolveLocalCache != null && useDefaultLocalCache != null) {
            throw InstMgrLogger.ROOT_LOGGER.noResolveLocalCacheWithUseDefaultLocalCache();
        }
        if (pathLocalRepo != null && useDefaultLocalCache != null && useDefaultLocalCache.booleanValue()) {
            throw InstMgrLogger.ROOT_LOGGER.localCacheWithUseDefaultLocalCache();
        }
        if (pathLocalRepo != null && noResolveLocalCache != null && noResolveLocalCache.booleanValue()) {
            throw InstMgrLogger.ROOT_LOGGER.localCacheWithNoResolveLocalCache();
        }
        if (!mavenRepoFileIndexes.isEmpty() && !repositoriesMn.isEmpty()) {
            throw InstMgrLogger.ROOT_LOGGER.mavenRepoFileWithRepositories();
        }
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.acquireControllerLock();
                try {
                    Path homeDir = InstMgrListUpdatesHandler.this.imService.getHomeDir();
                    boolean noResolveLocalCacheResult = noResolveLocalCache != null ? noResolveLocalCache : (useDefaultLocalCache == null ? localRepository == null : useDefaultLocalCache == false && localRepository == null);
                    MavenOptions mavenOptions = new MavenOptions(localRepository, noResolveLocalCacheResult, offline);
                    InstallationManager im = InstMgrListUpdatesHandler.this.imf.create(homeDir, mavenOptions);
                    final Path listUpdatesWorkDir = InstMgrListUpdatesHandler.this.imService.createTempDir("list-updates-");
                    context.completeStep(new OperationContext.ResultHandler(){

                        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                            if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                                try {
                                    InstMgrListUpdatesHandler.this.imService.deleteTempDir(listUpdatesWorkDir);
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        }
                    });
                    ArrayList<Repository> repositories = new ArrayList<Repository>();
                    if (!mavenRepoFileIndexes.isEmpty()) {
                        InstMgrLogger.ROOT_LOGGER.debug("Adding possible custom patch repositories");
                        repositories.addAll(InstMgrListUpdatesHandler.this.retrieveAllCustomPatchRepositories(im));
                        InstMgrLogger.ROOT_LOGGER.debug("Processing Streams from Operation Context");
                        repositories.addAll(InstMgrListUpdatesHandler.this.getRepositoriesFromOperationStreams(context, mavenRepoFileIndexes, listUpdatesWorkDir));
                    } else {
                        repositories.addAll(InstMgrListUpdatesHandler.this.toRepositories(context, repositoriesMn));
                    }
                    InstMgrLogger.ROOT_LOGGER.debug("Calling SPI to list updates with the following repositories:" + repositories);
                    List updates = im.findUpdates(repositories);
                    ModelNode resultValue = new ModelNode();
                    ModelNode updatesMn = new ModelNode().addEmptyList();
                    if (!updates.isEmpty()) {
                        for (ArtifactChange artifactChange : updates) {
                            ModelNode artifactChangeMn = new ModelNode();
                            artifactChangeMn.get("status").set(artifactChange.getStatus().name().toLowerCase(Locale.ENGLISH));
                            artifactChangeMn.get("name").set(artifactChange.getArtifactName());
                            switch (artifactChange.getStatus()) {
                                case REMOVED: {
                                    artifactChangeMn.get("old-version").set(artifactChange.getOldVersion());
                                    artifactChangeMn.get("new-version");
                                    break;
                                }
                                case INSTALLED: {
                                    artifactChangeMn.get("old-version");
                                    artifactChangeMn.get("new-version").set(artifactChange.getNewVersion());
                                    break;
                                }
                                case UPDATED: {
                                    artifactChangeMn.get("old-version").set(artifactChange.getOldVersion());
                                    artifactChangeMn.get("new-version").set(artifactChange.getNewVersion());
                                    break;
                                }
                                default: {
                                    throw InstMgrLogger.ROOT_LOGGER.unexpectedArtifactChange(artifactChange.toString());
                                }
                            }
                            updatesMn.add(artifactChangeMn);
                        }
                        if (!mavenRepoFileIndexes.isEmpty()) {
                            resultValue.get("updates").set(updatesMn);
                            resultValue.get("work-dir").set(listUpdatesWorkDir.getFileName().toString());
                        } else {
                            InstMgrListUpdatesHandler.this.imService.deleteTempDir(listUpdatesWorkDir);
                            resultValue.get("updates").set(updatesMn);
                        }
                    } else {
                        InstMgrListUpdatesHandler.this.imService.deleteTempDir(listUpdatesWorkDir);
                        resultValue.get("updates").set(updatesMn);
                    }
                    context.getResult().set(resultValue);
                }
                catch (ZipException e) {
                    throw new OperationFailedException(e.getLocalizedMessage());
                }
                catch (RuntimeException | OperationFailedException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

