/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.util;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public interface Supplied<T> {
    public T get(Supplier<T> var1);

    public static <T> Supplied<T> cached() {
        final AtomicReference reference = new AtomicReference();
        return new Supplied<T>(){

            @Override
            public T get(Supplier<T> factory) {
                return reference.updateAndGet(context -> Optional.ofNullable(context).orElseGet(factory));
            }
        };
    }

    public static <T> Supplied<T> simple() {
        return new Supplied<T>(){

            @Override
            public T get(Supplier<T> factory) {
                return factory.get();
            }
        };
    }
}

