/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.util;

import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum UUIDFactory implements Supplier<UUID>
{
    INSECURE{

        @Override
        public UUID get() {
            int i;
            byte[] data = new byte[16];
            ThreadLocalRandom.current().nextBytes(data);
            data[6] = (byte)(data[6] & 0xF);
            data[6] = (byte)(data[6] | 0x40);
            data[8] = (byte)(data[8] & 0x3F);
            data[8] = (byte)(data[8] | 0x80);
            long msb = 0L;
            long lsb = 0L;
            for (i = 0; i < 8; ++i) {
                msb = msb << 8 | (long)(data[i] & 0xFF);
            }
            for (i = 8; i < 16; ++i) {
                lsb = lsb << 8 | (long)(data[i] & 0xFF);
            }
            return new UUID(msb, lsb);
        }
    }
    ,
    SECURE{

        @Override
        public UUID get() {
            return UUID.randomUUID();
        }
    };

}

