/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.util.Map;
import java.util.function.Supplier;
import org.jboss.as.mail.extension.Credentials;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.password.interfaces.ClearPassword;

class ServerConfig {
    private final Supplier<OutboundSocketBinding> outgoingSocketBinding;
    private final Credentials credentials;
    private final InjectedValue<ExceptionSupplier<CredentialSource, Exception>> credentialSourceSupplierInjector = new InjectedValue();
    private boolean sslEnabled = false;
    private boolean tlsEnabled = false;
    private final Map<String, String> properties;

    public ServerConfig(Supplier<OutboundSocketBinding> outgoingSocketBinding, Credentials credentials, boolean ssl, boolean tls, Map<String, String> properties) {
        this.outgoingSocketBinding = outgoingSocketBinding;
        this.credentials = credentials;
        this.sslEnabled = ssl;
        this.tlsEnabled = tls;
        this.properties = properties;
    }

    public OutboundSocketBinding getOutgoingSocketBinding() {
        return this.outgoingSocketBinding != null ? this.outgoingSocketBinding.get() : null;
    }

    public Credentials getCredentials() {
        ExceptionSupplier credentialSourceSupplier = (ExceptionSupplier)this.credentialSourceSupplierInjector.getOptionalValue();
        if (credentialSourceSupplier != null) {
            try {
                CredentialSource credentialSource = (CredentialSource)credentialSourceSupplier.get();
                if (credentialSource == null) {
                    return this.credentials;
                }
                char[] password = ((ClearPassword)((PasswordCredential)credentialSource.getCredential(PasswordCredential.class)).getPassword(ClearPassword.class)).getPassword();
                return new Credentials(this.credentials.getUsername(), new String(password));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.credentials;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Injector<ExceptionSupplier<CredentialSource, Exception>> getCredentialSourceSupplierInjector() {
        return this.credentialSourceSupplierInjector;
    }
}

