/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.scheduler;

import io.github.resilience4j.core.functions.CheckedFunction;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.dispatcher.CommandDispatcher;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.scheduler.CacheEntryScheduler;
import org.wildfly.clustering.server.infinispan.scheduler.CancelCommand;
import org.wildfly.clustering.server.infinispan.scheduler.ContainsCommand;
import org.wildfly.clustering.server.infinispan.scheduler.EntriesCommand;
import org.wildfly.clustering.server.infinispan.scheduler.PrimaryOwnerCommand;
import org.wildfly.clustering.server.infinispan.scheduler.PrimaryOwnerSchedulerConfiguration;
import org.wildfly.clustering.server.infinispan.scheduler.ScheduleCommand;
import org.wildfly.clustering.server.scheduler.Scheduler;
import org.wildfly.clustering.server.util.MapEntry;

public class PrimaryOwnerScheduler<I, M>
implements Scheduler<I, M>,
Function<CompletionStage<Collection<I>>, Stream<I>> {
    private static final Logger LOGGER = Logger.getLogger(PrimaryOwnerScheduler.class);
    private final String name;
    private final CommandDispatcher<CacheContainerGroupMember, CacheEntryScheduler<I, M>> dispatcher;
    private final CheckedFunction<Map.Entry<I, M>, CompletionStage<Void>> primaryOwnerSchedule;
    private final CheckedFunction<I, CompletionStage<Void>> primaryOwnerCancel;
    private final CheckedFunction<I, CompletionStage<Boolean>> primaryOwnerContains;

    public PrimaryOwnerScheduler(PrimaryOwnerSchedulerConfiguration<I, M> configuration) {
        this.name = configuration.getName();
        final CacheEntryScheduler<I, M> scheduler = configuration.getScheduler();
        this.dispatcher = configuration.getCommandDispatcherFactory().createCommandDispatcher(this.name, scheduler, AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return scheduler.getClass().getClassLoader();
            }
        }));
        Function<I, CacheContainerGroupMember> affinity = configuration.getAffinity();
        Retry retry = Retry.of((String)configuration.getName(), (RetryConfig)configuration.getRetryConfig());
        final BiFunction<I, M, ScheduleCommand<I, M>> scheduleCommandFactory = configuration.getScheduleCommandFactory();
        this.primaryOwnerSchedule = Retry.decorateCheckedFunction((Retry)retry, new PrimaryOwnerCommandExecutionFunction(this.dispatcher, affinity, new Function<Map.Entry<I, M>, PrimaryOwnerCommand<I, M, Void>>(){

            @Override
            public PrimaryOwnerCommand<I, M, Void> apply(Map.Entry<I, M> entry) {
                return (PrimaryOwnerCommand)scheduleCommandFactory.apply(entry.getKey(), entry.getValue());
            }
        }));
        this.primaryOwnerCancel = Retry.decorateCheckedFunction((Retry)retry, new PrimaryOwnerCommandExecutionFunction(this.dispatcher, affinity, CancelCommand::new));
        this.primaryOwnerContains = Retry.decorateCheckedFunction((Retry)retry, new PrimaryOwnerCommandExecutionFunction(this.dispatcher, affinity, ContainsCommand::new));
    }

    public void schedule(I id, M metaData) {
        try {
            ((CompletionStage)this.primaryOwnerSchedule.apply((Object)MapEntry.of(id, metaData))).toCompletableFuture().join();
        }
        catch (CancellationException cancellationException) {
        }
        catch (Throwable e) {
            LOGGER.warn((Object)id.toString(), e);
        }
    }

    public void cancel(I id) {
        try {
            ((CompletionStage)this.primaryOwnerCancel.apply(id)).toCompletableFuture().join();
        }
        catch (CancellationException cancellationException) {
        }
        catch (Throwable e) {
            LOGGER.warn((Object)id.toString(), e);
        }
    }

    public boolean contains(I id) {
        try {
            return (Boolean)((CompletionStage)this.primaryOwnerContains.apply(id)).toCompletableFuture().join();
        }
        catch (CancellationException e) {
            return false;
        }
        catch (Throwable e) {
            LOGGER.warn((Object)id.toString(), e);
            return false;
        }
    }

    public Stream<I> stream() {
        try {
            Map results = this.dispatcher.dispatchToGroup(new EntriesCommand());
            return results.isEmpty() ? Stream.empty() : results.values().stream().map(this).flatMap(Function.identity()).distinct();
        }
        catch (IOException e) {
            return Stream.empty();
        }
    }

    @Override
    public Stream<I> apply(CompletionStage<Collection<I>> stage) {
        try {
            return stage.toCompletableFuture().join().stream();
        }
        catch (CompletionException e) {
            LOGGER.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return Stream.empty();
        }
        catch (CancellationException e) {
            return Stream.empty();
        }
    }

    public void close() {
        LOGGER.tracef("Closing command dispatcher for %s primary-owner scheduler", (Object)this.name);
        this.dispatcher.close();
        ((CacheEntryScheduler)this.dispatcher.getContext()).close();
    }

    private static class PrimaryOwnerCommandExecutionFunction<I, M, T, R>
    implements CheckedFunction<T, CompletionStage<R>> {
        private final CommandDispatcher<CacheContainerGroupMember, CacheEntryScheduler<I, M>> dispatcher;
        private final Function<I, CacheContainerGroupMember> affinity;
        private final Function<T, PrimaryOwnerCommand<I, M, R>> commandFactory;

        PrimaryOwnerCommandExecutionFunction(CommandDispatcher<CacheContainerGroupMember, CacheEntryScheduler<I, M>> dispatcher, Function<I, CacheContainerGroupMember> affinity, Function<T, PrimaryOwnerCommand<I, M, R>> commandFactory) {
            this.dispatcher = dispatcher;
            this.affinity = affinity;
            this.commandFactory = commandFactory;
        }

        public CompletionStage<R> apply(T value) throws IOException {
            PrimaryOwnerCommand<I, M, R> command = this.commandFactory.apply(value);
            CacheContainerGroupMember primaryOwner = this.affinity.apply(command.getId());
            LOGGER.tracef("Executing command %s on %s", command, (Object)primaryOwner);
            return this.dispatcher.dispatchToMember(command, (GroupMember)primaryOwner);
        }
    }
}

