/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.LinkedList;
import java.util.List;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.clustering.controller.MetricHandler;
import org.jboss.as.clustering.controller.ModuleServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.RuntimeResourceRegistration;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.clustering.controller.validation.ModuleIdentifierValidatorBuilder;
import org.jboss.as.clustering.jgroups.subsystem.ChannelMetric;
import org.jboss.as.clustering.jgroups.subsystem.ChannelMetricExecutor;
import org.jboss.as.clustering.jgroups.subsystem.ChannelRuntimeResourceRegistration;
import org.jboss.as.clustering.jgroups.subsystem.ChannelServiceConfiguration;
import org.jboss.as.clustering.jgroups.subsystem.ChannelServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.ForkChannelFactoryServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.ForkResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsBindingFactory;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.naming.BinderServiceInstaller;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.jgroups.JChannel;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.server.service.ChannelServiceInstallerProvider;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.clustering.server.service.LegacyClusteringServiceDescriptor;
import org.wildfly.clustering.server.service.ProvidedUnaryServiceInstallerProvider;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;
import org.wildfly.subsystem.service.capture.ServiceValueExecutorRegistry;

public class ChannelResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration>
implements ResourceServiceConfigurator {
    public static final PathElement WILDCARD_PATH = ChannelResourceDefinition.pathElement("*");
    static final UnaryServiceDescriptor<JChannel> CHANNEL = UnaryServiceDescriptor.of((String)"org.wildfly.clustering.jgroups.channel", JGroupsSubsystemResourceDefinition.DEFAULT_CHANNEL);
    static final UnaryServiceDescriptor<Module> CHANNEL_MODULE = UnaryServiceDescriptor.of((String)"org.wildfly.clustering.jgroups.channel-module", JGroupsSubsystemResourceDefinition.DEFAULT_CHANNEL_MODULE);
    static final UnaryServiceDescriptor<ChannelFactory> CHANNEL_SOURCE = UnaryServiceDescriptor.of((String)"org.wildfly.clustering.jgroups.channel-source", JGroupsSubsystemResourceDefinition.DEFAULT_CHANNEL_SOURCE);
    static final UnaryServiceDescriptor<String> CHANNEL_CLUSTER = UnaryServiceDescriptor.of((String)"org.wildfly.clustering.jgroups.channel-cluster", JGroupsSubsystemResourceDefinition.DEFAULT_CHANNEL_CLUSTER);
    static final RuntimeCapability<Void> CHANNEL_CAPABILITY = RuntimeCapability.Builder.of(CHANNEL).setAllowMultipleRegistrations(true).build();
    static final RuntimeCapability<Void> CHANNEL_FACTORY_CAPABILITY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)ChannelFactory.SERVICE_DESCRIPTOR).setAllowMultipleRegistrations(true).build();
    private static final RuntimeCapability<Void> CHANNEL_MODULE_CAPABILITY = RuntimeCapability.Builder.of(CHANNEL_MODULE).build();
    private static final RuntimeCapability<Void> CHANNEL_SOURCE_CAPABILITY = RuntimeCapability.Builder.of(CHANNEL_SOURCE).build();
    private static final RuntimeCapability<Void> CHANNEL_CLUSTER_CAPABILITY = RuntimeCapability.Builder.of(CHANNEL_CLUSTER).build();
    private final ServiceValueExecutorRegistry<JChannel> registry = ServiceValueExecutorRegistry.newInstance();

    public static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"channel", (String)name);
    }

    ChannelResourceDefinition() {
        super(WILDCARD_PATH, (ResourceDescriptionResolver)JGroupsExtension.SUBSYSTEM_RESOLVER.createChildResolver(WILDCARD_PATH));
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        RuntimeCapability commandDispatcherFactory = RuntimeCapability.Builder.of((UnaryServiceDescriptor)ClusteringServiceDescriptor.COMMAND_DISPATCHER_FACTORY).setAllowMultipleRegistrations(true).build();
        RuntimeCapability legacyCommandDispatcherFactory = RuntimeCapability.Builder.of((UnaryServiceDescriptor)LegacyClusteringServiceDescriptor.COMMAND_DISPATCHER_FACTORY).setAllowMultipleRegistrations(true).build();
        RuntimeCapability group = RuntimeCapability.Builder.of((UnaryServiceDescriptor)ClusteringServiceDescriptor.GROUP).setAllowMultipleRegistrations(true).build();
        RuntimeCapability legacyGroup = RuntimeCapability.Builder.of((UnaryServiceDescriptor)LegacyClusteringServiceDescriptor.GROUP).setAllowMultipleRegistrations(true).build();
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addCapabilities(List.of(CHANNEL_CAPABILITY, CHANNEL_FACTORY_CAPABILITY, CHANNEL_MODULE_CAPABILITY, CHANNEL_SOURCE_CAPABILITY, CHANNEL_CLUSTER_CAPABILITY, commandDispatcherFactory, legacyCommandDispatcherFactory, group, legacyGroup)).addRuntimeResourceRegistration((RuntimeResourceRegistration)new ChannelRuntimeResourceRegistration((FunctionExecutorRegistry<JChannel>)this.registry)).setAddOperationTransformation(DefaultStackOperationStepHandler::new);
        ResourceOperationRuntimeHandler handler = ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this);
        new SimpleResourceRegistrar(descriptor, ResourceServiceHandler.of((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{handler})).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        if (registration.isRuntimeOnlyRegistrationValid()) {
            new MetricHandler((MetricExecutor)new ChannelMetricExecutor((FunctionExecutorRegistry<JChannel>)this.registry), ChannelMetric.class).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        }
        new ForkResourceDefinition(this.registry).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        LinkedList<Object> installers = new LinkedList<Object>();
        final String clusterName = Attribute.CLUSTER.resolveModelAttribute((ExpressionResolver)context, model).asString(name);
        String stackName = Attribute.STACK.resolveModelAttribute((ExpressionResolver)context, model).asString();
        final boolean statisticsEnabled = Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        final ServiceDependency channelFactory = ServiceDependency.on((UnaryServiceDescriptor)ChannelFactory.SERVICE_DESCRIPTOR, (String)stackName);
        ChannelServiceConfiguration configuration = new ChannelServiceConfiguration(){

            @Override
            public boolean isStatisticsEnabled() {
                return statisticsEnabled;
            }

            @Override
            public org.wildfly.clustering.jgroups.ChannelFactory getChannelFactory() {
                return (org.wildfly.clustering.jgroups.ChannelFactory)channelFactory.get();
            }

            @Override
            public String getClusterName() {
                return clusterName;
            }

            @Override
            public void accept(RequirementServiceBuilder<?> builder) {
                channelFactory.accept(builder);
            }
        };
        installers.add(new ChannelServiceConfigurator(CHANNEL_CAPABILITY, configuration).configure(context, model));
        installers.add(this.registry.capture(ServiceDependency.on(CHANNEL, (String)name)));
        installers.add(new ForkChannelFactoryServiceConfigurator(CHANNEL_FACTORY_CAPABILITY, UnaryOperator.identity()).configure(context, model));
        installers.add(new ModuleServiceConfigurator(CHANNEL_MODULE_CAPABILITY, Attribute.MODULE.getDefinition()).configure(context, model));
        installers.add((ResourceServiceInstaller)CapabilityServiceInstaller.builder(CHANNEL_SOURCE_CAPABILITY, (ServiceDependency)ServiceDependency.on((UnaryServiceDescriptor)ChannelFactory.SERVICE_DESCRIPTOR, (String)stackName)).build());
        installers.add((ResourceServiceInstaller)CapabilityServiceInstaller.builder(CHANNEL_CLUSTER_CAPABILITY, (Object)clusterName).build());
        installers.add(new BinderServiceInstaller(JGroupsBindingFactory.createChannelBinding(name), context.getCapabilityServiceName(CHANNEL, name)));
        installers.add(new BinderServiceInstaller(JGroupsBindingFactory.createChannelFactoryBinding(name), context.getCapabilityServiceName(ChannelFactory.SERVICE_DESCRIPTOR, name)));
        new ProvidedUnaryServiceInstallerProvider(ChannelServiceInstallerProvider.class, ChannelServiceInstallerProvider.class.getClassLoader()).apply(context.getCapabilityServiceSupport(), name).forEach(installers::add);
        return ResourceServiceInstaller.combine(installers);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        STACK("stack", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setRequired(true)).setAllowExpression(false)).setCapabilityReference((CapabilityReferenceRecorder)org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder.builder(CHANNEL_FACTORY_CAPABILITY, (UnaryServiceDescriptor)ChannelFactory.SERVICE_DESCRIPTOR).build());
            }
        }
        ,
        MODULE("module", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setDefaultValue(new ModelNode("org.wildfly.clustering.server"))).setValidator(new ModuleIdentifierValidatorBuilder().configure((AbstractAttributeDefinitionBuilder)builder).build());
            }
        }
        ,
        CLUSTER("cluster", ModelType.STRING),
        STATISTICS_ENABLED("statistics-enabled", ModelType.BOOLEAN){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setDefaultValue(ModelNode.FALSE);
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }

    private static class DefaultStackOperationStepHandler
    implements OperationStepHandler {
        private final OperationStepHandler handler;

        DefaultStackOperationStepHandler(OperationStepHandler handler) {
            this.handler = handler;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (!operation.hasDefined(Attribute.STACK.getName())) {
                PathAddress subsystemAddress = context.getCurrentAddress().getParent();
                Resource root = context.readResourceFromRoot(subsystemAddress.getParent(), false);
                if (!root.hasChild(subsystemAddress.getLastElement())) {
                    context.addStep(operation, (OperationStepHandler)this, context.getCurrentStage());
                    return;
                }
                Resource subsystem = context.readResourceFromRoot(subsystemAddress, false);
                ModelNode subsystemModel = subsystem.getModel();
                if (subsystemModel.hasDefined(JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_CHANNEL.getName())) {
                    String defaultChannel = subsystemModel.get(JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_CHANNEL.getName()).asString();
                    if (!context.getCurrentAddressValue().equals(defaultChannel)) {
                        PathElement defaultChannelPath = ChannelResourceDefinition.pathElement(defaultChannel);
                        if (!subsystem.hasChild(defaultChannelPath)) {
                            context.addStep(operation, (OperationStepHandler)this, context.getCurrentStage());
                            return;
                        }
                        Resource channel = context.readResourceFromRoot(subsystemAddress.append(new PathElement[]{defaultChannelPath}), false);
                        ModelNode channelModel = channel.getModel();
                        String defaultStack = channelModel.get(Attribute.STACK.getName()).asString();
                        operation.get(Attribute.STACK.getName()).set(defaultStack);
                    }
                }
            }
            this.handler.execute(context, operation);
        }
    }
}

