/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AmqpInterceptor;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class AmqpSendReceiveInterceptorTest
extends AmqpClientTestSupport {
    private static final String ADDRESS = "address";
    private static final String MESSAGE_ID = "messageId";
    private static final String CORRELATION_ID = "correlationId";
    private static final String MESSAGE_TEXT = "messageText";
    private static final String DURABLE = "durable";
    private static final String PRIORITY = "priority";
    private static final String REPLY_TO = "replyTo";
    private static final String TIME_TO_LIVE = "timeToLive";

    @Test
    @Timeout(value=60L)
    public void testCreateQueueReceiver() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)new AmqpInterceptor(){

            public boolean intercept(AMQPMessage message, RemotingConnection connection) throws ActiveMQException {
                latch.countDown();
                return true;
            }
        });
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getTestName());
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("msg1");
        message.setText("Test-Message");
        sender.send(message);
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        final CountDownLatch latch2 = new CountDownLatch(1);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)new AmqpInterceptor(){

            public boolean intercept(AMQPMessage packet, RemotingConnection connection) throws ActiveMQException {
                latch2.countDown();
                return true;
            }
        });
        AmqpReceiver receiver = session.createReceiver(this.getTestName());
        receiver.flow(2);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)amqpMessage);
        Assertions.assertEquals((long)latch2.getCount(), (long)0L);
        sender.close();
        receiver.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testRejectMessageWithIncomingInterceptor() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)new AmqpInterceptor(){

            public boolean intercept(AMQPMessage message, RemotingConnection connection) throws ActiveMQException {
                latch.countDown();
                return false;
            }
        });
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getTestName());
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("msg1");
        message.setText("Test-Message");
        try {
            sender.send(message);
            Assertions.fail((String)"Sending message should have thrown exception here.");
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)"Interceptor rejected message [condition = failed]", (Object)e.getMessage());
        }
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        AmqpReceiver receiver = session.createReceiver(this.getTestName());
        receiver.flow(2);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNull((Object)amqpMessage);
        sender.close();
        receiver.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testRejectMessageWithOutgoingInterceptor() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getTestName());
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("msg1");
        message.setText("Test-Message");
        sender.send(message);
        final CountDownLatch latch = new CountDownLatch(1);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)new AmqpInterceptor(){

            public boolean intercept(AMQPMessage packet, RemotingConnection connection) throws ActiveMQException {
                latch.countDown();
                return false;
            }
        });
        AmqpReceiver receiver = session.createReceiver(this.getTestName());
        receiver.flow(2);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNull((Object)amqpMessage);
        Assertions.assertEquals((long)latch.getCount(), (long)0L);
        sender.close();
        receiver.close();
        connection.close();
    }

    private boolean checkMessageProperties(AMQPMessage message, Map<String, Object> expectedProperties) {
        Assertions.assertNotNull((Object)message);
        Assertions.assertNotNull((Object)this.server.getNodeID());
        Assertions.assertNotNull((Object)message.getConnectionID());
        Assertions.assertEquals((Object)message.getAddress(), (Object)expectedProperties.get(ADDRESS));
        Assertions.assertEquals((Object)message.isDurable(), (Object)expectedProperties.get(DURABLE));
        Properties props = message.getProperties();
        Assertions.assertEquals((Object)props.getCorrelationId(), (Object)expectedProperties.get(CORRELATION_ID));
        Assertions.assertEquals((Object)props.getReplyTo(), (Object)expectedProperties.get(REPLY_TO));
        Assertions.assertEquals((Object)props.getMessageId(), (Object)expectedProperties.get(MESSAGE_ID));
        Header header = message.getHeader();
        Assertions.assertEquals((Object)header.getDurable(), (Object)expectedProperties.get(DURABLE));
        Assertions.assertEquals((Object)header.getTtl().toString(), (Object)expectedProperties.get(TIME_TO_LIVE).toString());
        Assertions.assertEquals((Object)header.getPriority().toString(), (Object)expectedProperties.get(PRIORITY).toString());
        return true;
    }

    @Test
    @Timeout(value=60L)
    public void testCheckInterceptedMessageProperties() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        String addressQueue = this.getTestName();
        String messageId = "lala200";
        String correlationId = "lala-corrId";
        String msgText = "Test intercepted message";
        boolean durableMsg = false;
        int priority = 8;
        long timeToLive = 10000L;
        String replyTo = "reply-to-myQueue";
        final HashMap<String, Object> expectedProperties = new HashMap<String, Object>();
        expectedProperties.put(ADDRESS, addressQueue);
        expectedProperties.put(MESSAGE_ID, "lala200");
        expectedProperties.put(CORRELATION_ID, "lala-corrId");
        expectedProperties.put(MESSAGE_TEXT, "Test intercepted message");
        expectedProperties.put(DURABLE, false);
        expectedProperties.put(PRIORITY, (short)8);
        expectedProperties.put(REPLY_TO, "reply-to-myQueue");
        expectedProperties.put(TIME_TO_LIVE, 10000L);
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)new AmqpInterceptor(){

            public boolean intercept(AMQPMessage message, RemotingConnection connection) throws ActiveMQException {
                latch.countDown();
                return AmqpSendReceiveInterceptorTest.this.checkMessageProperties(message, expectedProperties);
            }
        });
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getTestName());
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("lala200");
        message.setCorrelationId("lala-corrId");
        message.setText("Test intercepted message");
        message.setDurable(false);
        message.setPriority((short)8);
        message.setReplyToAddress("reply-to-myQueue");
        message.setTimeToLive(10000L);
        sender.send(message);
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        final CountDownLatch latch2 = new CountDownLatch(1);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)new AmqpInterceptor(){

            public boolean intercept(AMQPMessage packet, RemotingConnection connection) throws ActiveMQException {
                latch2.countDown();
                return AmqpSendReceiveInterceptorTest.this.checkMessageProperties(packet, expectedProperties);
            }
        });
        AmqpReceiver receiver = session.createReceiver(this.getTestName());
        receiver.flow(2);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)amqpMessage);
        Assertions.assertEquals((long)latch2.getCount(), (long)0L);
        sender.close();
        receiver.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testCheckRemotingConnection() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final boolean[] passed = new boolean[]{false};
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)new AmqpInterceptor(){

            public boolean intercept(AMQPMessage message, RemotingConnection connection) throws ActiveMQException {
                passed[0] = connection != null;
                latch.countDown();
                return true;
            }
        });
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getTestName());
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("msg1");
        message.setText("Test-Message");
        sender.send(message);
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)passed[0], (String)"connection not set");
        final CountDownLatch latch2 = new CountDownLatch(1);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)new AmqpInterceptor(){

            public boolean intercept(AMQPMessage packet, RemotingConnection connection) throws ActiveMQException {
                passed[0] = connection != null;
                latch2.countDown();
                return true;
            }
        });
        AmqpReceiver receiver = session.createReceiver(this.getTestName());
        receiver.flow(2);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)amqpMessage);
        Assertions.assertEquals((long)latch2.getCount(), (long)0L);
        Assertions.assertTrue((boolean)passed[0], (String)"connection not set");
        sender.close();
        receiver.close();
        connection.close();
    }
}

