/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.jms.provider.amqp.message.AmqpDestinationHelper;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class ClientDefinedAnycastConsumerTest
extends AmqpClientTestSupport {
    SimpleString address = SimpleString.of((String)"testAddress");

    @Test
    @Timeout(value=60L)
    public void testConsumeFromSingleQueueOnAddressSameName() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        Source source = new Source();
        source.setAddress(this.address.toString());
        source.setCapabilities(new Symbol[]{AmqpDestinationHelper.QUEUE_CAPABILITY});
        AmqpReceiver receiver = session.createReceiver(source);
        this.sendMessages(this.address.toString(), 1);
        receiver.flow(1);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)amqpMessage);
        Assertions.assertEquals((int)1, (int)((QueueImpl)this.server.getPostOffice().getBinding(this.address).getBindable()).getConsumerCount());
        receiver.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testConsumeFromSingleQueueOnAddressSameNameNegativeValidation() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        Source source = new Source();
        source.setAddress(this.address.toString());
        source.setCapabilities(new Symbol[]{AmqpDestinationHelper.TOPIC_CAPABILITY});
        AmqpReceiver receiver = session.createReceiver(source);
        this.sendMessages(this.address.toString(), 1);
        receiver.flow(1);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)amqpMessage);
        Bindings bindings = this.server.getPostOffice().getBindingsForAddress(this.address);
        Assertions.assertEquals((int)1, (int)bindings.getBindings().size());
        bindings.getBindings().forEach(binding -> {
            Queue localQueue = ((LocalQueueBinding)binding).getQueue();
            Assertions.assertEquals((int)1, (int)localQueue.getConsumerCount());
            Assertions.assertEquals((Object)RoutingType.MULTICAST, (Object)localQueue.getRoutingType());
        });
        receiver.close();
        connection.close();
    }
}

