/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameter;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.apache.qpid.jms.message.JmsTextMessage;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFacade;
import org.apache.qpid.proton.amqp.Symbol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class IngressTimestampTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private final SimpleString QUEUE = SimpleString.of((String)"ConsumerTestQueue");
    @Parameter(index=0)
    public boolean restart;
    @Parameter(index=1)
    public boolean large;

    @Parameters(name="restart={0}, large={1}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({true, true}, {false, false}, {true, false}, {false, true});
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true, true);
        this.server.start();
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setEnableIngressTimestamp(true));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.QUEUE).setRoutingType(RoutingType.ANYCAST));
    }

    @TestTemplate
    public void testSendCoreReceiveAMQP() throws Throwable {
        this.internalSendReceive(Protocol.CORE, Protocol.AMQP);
    }

    @TestTemplate
    public void testSendAMQPReceiveAMQP() throws Throwable {
        this.internalSendReceive(Protocol.AMQP, Protocol.AMQP);
    }

    @TestTemplate
    public void testSendOpenWireReceiveAMQP() throws Throwable {
        this.internalSendReceive(Protocol.OPENWIRE, Protocol.AMQP);
    }

    @TestTemplate
    public void testSendCoreReceiveCore() throws Throwable {
        this.internalSendReceive(Protocol.CORE, Protocol.CORE);
    }

    @TestTemplate
    public void testSendAMQPReceiveCore() throws Throwable {
        this.internalSendReceive(Protocol.AMQP, Protocol.CORE);
    }

    @TestTemplate
    public void testSendOpenWireReceiveCore() throws Throwable {
        this.internalSendReceive(Protocol.OPENWIRE, Protocol.CORE);
    }

    @TestTemplate
    public void testSendCoreReceiveOpenwire() throws Throwable {
        this.internalSendReceive(Protocol.CORE, Protocol.OPENWIRE);
    }

    @TestTemplate
    public void testSendAMQPReceiveOpenWire() throws Throwable {
        this.internalSendReceive(Protocol.AMQP, Protocol.OPENWIRE);
    }

    @TestTemplate
    public void testSendOpenWireReceiveOpenWire() throws Throwable {
        this.internalSendReceive(Protocol.OPENWIRE, Protocol.OPENWIRE);
    }

    private void internalSendReceive(Protocol protocolSender, Protocol protocolConsumer) throws Throwable {
        long afterSend;
        long beforeSend;
        Queue queue;
        Session session;
        ConnectionFactory factorySend = this.createFactory(protocolSender);
        ConnectionFactory factoryConsume = protocolConsumer == protocolSender ? factorySend : this.createFactory(protocolConsumer);
        try (Connection connection = factorySend.createConnection();){
            session = connection.createSession(false, 1);
            try {
                queue = session.createQueue(this.QUEUE.toString());
                try (MessageProducer producer = session.createProducer((Destination)queue);){
                    producer.setDeliveryMode(2);
                    TextMessage msg = session.createTextMessage(this.getMessagePayload());
                    beforeSend = System.currentTimeMillis();
                    producer.send((Message)msg);
                    afterSend = System.currentTimeMillis();
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        if (this.restart) {
            this.server.stop();
            this.server.start();
            Assertions.assertTrue((boolean)this.server.waitForActivation(3L, TimeUnit.SECONDS));
        }
        connection = factoryConsume.createConnection();
        try {
            connection.start();
            session = connection.createSession(false, 1);
            try {
                queue = session.createQueue(this.QUEUE.toString());
                try (MessageConsumer consumer = session.createConsumer((Destination)queue);){
                    TextMessage message = (TextMessage)consumer.receive(1000L);
                    Assertions.assertNotNull((Object)message);
                    Enumeration e = message.getPropertyNames();
                    while (e.hasMoreElements()) {
                        System.out.println(e.nextElement());
                    }
                    Object ingressTimestampHeader = null;
                    if (protocolConsumer == Protocol.AMQP) {
                        Method getMessageAnnotation = AmqpJmsMessageFacade.class.getDeclaredMethod("getMessageAnnotation", Symbol.class);
                        getMessageAnnotation.setAccessible(true);
                        ingressTimestampHeader = getMessageAnnotation.invoke((Object)((JmsTextMessage)message).getFacade(), Symbol.getSymbol((String)"x-opt-ingress-time"));
                    } else {
                        ingressTimestampHeader = message.getObjectProperty(org.apache.activemq.artemis.api.core.Message.HDR_INGRESS_TIMESTAMP.toString());
                    }
                    Assertions.assertNotNull((Object)ingressTimestampHeader);
                    Assertions.assertTrue((boolean)(ingressTimestampHeader instanceof Long));
                    long ingressTimestamp = (Long)ingressTimestampHeader;
                    Assertions.assertTrue((ingressTimestamp >= beforeSend && ingressTimestamp <= afterSend ? 1 : 0) != 0, (String)("Ingress timstamp " + ingressTimestamp + " should be >= " + beforeSend + " and <= " + afterSend));
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private String getMessagePayload() {
        StringBuilder result = new StringBuilder();
        if (this.large) {
            for (int i = 0; i < 2048000; ++i) {
                result.append("AB");
            }
        } else {
            result.append("AB");
        }
        return result.toString();
    }

    private ConnectionFactory createFactory(Protocol protocol) {
        switch (protocol) {
            case CORE: {
                return new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory();
            }
            case AMQP: {
                return new JmsConnectionFactory("amqp://localhost:61616");
            }
            case OPENWIRE: {
                return new ActiveMQConnectionFactory("tcp://localhost:61616");
            }
        }
        return null;
    }

    private static enum Protocol {
        CORE,
        AMQP,
        OPENWIRE;

    }
}

