/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class JMSOrderTest
extends JMSTestBase {
    String protocol;
    boolean exclusive;
    ConnectionFactory protocolCF;

    public JMSOrderTest(String protocol, boolean exclusive) {
        this.protocol = protocol;
        this.exclusive = exclusive;
    }

    @BeforeEach
    public void setupCF() {
        this.protocolCF = CFUtil.createConnectionFactory(this.protocol, "tcp://localhost:61616");
    }

    @Parameters(name="protocol={0}&exclusive={1}")
    public static Collection getParameters() {
        return Arrays.asList({"AMQP", true}, {"AMQP", false}, {"OPENWIRE", true}, {"OPENWIRE", false}, {"CORE", true}, {"CORE", false});
    }

    @Override
    protected void extraServerConfig(ActiveMQServer server) {
        if (this.exclusive) {
            server.getConfiguration().getAddressSettings().put("#", new AddressSettings().setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true)).setDeadLetterAddress(SimpleString.of((String)"ActiveMQ.DLQ")).setDefaultExclusiveQueue(Boolean.valueOf(true)));
        }
    }

    protected void sendToAmqQueue(int count) throws Exception {
        Connection activemqConnection = this.protocolCF.createConnection();
        Session amqSession = activemqConnection.createSession(false, 1);
        jakarta.jms.Queue amqTestQueue = amqSession.createQueue(this.name);
        this.sendMessages(activemqConnection, (Destination)amqTestQueue, count);
        activemqConnection.close();
    }

    public void sendMessages(Connection connection, Destination destination, int count) throws Exception {
        Session session = connection.createSession(false, 1);
        MessageProducer p = session.createProducer(destination);
        for (int i = 1; i <= count; ++i) {
            TextMessage message = session.createTextMessage();
            message.setText("TextMessage: " + i);
            message.setIntProperty("nr", i);
            p.send((Message)message);
        }
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=60L)
    public void testReceiveSomeThenRollback() throws Exception {
        try (Connection connection = this.protocolCF.createConnection();){
            int i;
            connection.start();
            int totalCount = 5;
            int consumeBeforeRollback = 2;
            this.sendToAmqQueue(totalCount);
            Session session = connection.createSession(true, 0);
            jakarta.jms.Queue queue = session.createQueue(this.name);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            for (int i2 = 1; i2 <= consumeBeforeRollback; ++i2) {
                Message message = consumer.receive(3000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((int)i2, (int)message.getIntProperty("nr"), (String)"Unexpected message number");
            }
            session.rollback();
            ArrayList<Integer> messageNumbers = new ArrayList<Integer>();
            for (i = 1; i <= totalCount; ++i) {
                Message message = consumer.receive(3000L);
                Assertions.assertNotNull((Object)message, (String)("Failed to receive message: " + i));
                int msgNum = message.getIntProperty("nr");
                messageNumbers.add(msgNum);
            }
            session.commit();
            Assertions.assertEquals((int)totalCount, (int)messageNumbers.size(), (String)"Unexpected size of list");
            for (i = 0; i < messageNumbers.size(); ++i) {
                Assertions.assertEquals((Integer)(i + 1), (Integer)((Integer)messageNumbers.get(i)), (String)("Unexpected order of messages: " + messageNumbers));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=60L)
    public void testReceiveSomeThenClose() throws Exception {
        try (Connection connection = this.protocolCF.createConnection();){
            int i;
            connection.start();
            int totalCount = 5;
            int consumeBeforeRollback = 2;
            this.sendToAmqQueue(totalCount);
            Session session = connection.createSession(true, 0);
            jakarta.jms.Queue queue = session.createQueue(this.name);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            for (int i2 = 1; i2 <= consumeBeforeRollback; ++i2) {
                Message message = consumer.receive(3000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((int)i2, (int)message.getIntProperty("nr"), (String)"Unexpected message number");
            }
            session.close();
            session = connection.createSession(true, 0);
            queue = session.createQueue(this.name);
            consumer = session.createConsumer((Destination)queue);
            ArrayList<Integer> messageNumbers = new ArrayList<Integer>();
            for (i = 1; i <= totalCount; ++i) {
                Message message = consumer.receive(3000L);
                Assertions.assertNotNull((Object)message, (String)("Failed to receive message: " + i));
                int msgNum = message.getIntProperty("nr");
                messageNumbers.add(msgNum);
            }
            session.commit();
            Assertions.assertEquals((int)totalCount, (int)messageNumbers.size(), (String)"Unexpected size of list");
            for (i = 0; i < messageNumbers.size(); ++i) {
                Assertions.assertEquals((Integer)(i + 1), (Integer)((Integer)messageNumbers.get(i)), (String)("Unexpected order of messages: " + messageNumbers));
            }
        }
    }

    protected void sendToAmqQueueOutOfOrder(int totalCount) throws Exception {
        Connection activemqConnection = this.protocolCF.createConnection();
        Session amqSession = activemqConnection.createSession(false, 1);
        jakarta.jms.Queue amqTestQueue = amqSession.createQueue(this.name);
        for (int i = 1; i <= totalCount; i += 2) {
            Session sessionA = activemqConnection.createSession(true, 0);
            Session sessionB = activemqConnection.createSession(true, 0);
            MessageProducer pA = sessionA.createProducer((Destination)amqTestQueue);
            MessageProducer pB = sessionB.createProducer((Destination)amqTestQueue);
            TextMessage message = sessionA.createTextMessage();
            message.setText("TextMessage: " + i + "1");
            message.setIntProperty("nr", i + 1);
            pA.send((Message)message);
            message = sessionB.createTextMessage();
            message.setText("TextMessage: " + i);
            message.setIntProperty("nr", i);
            pB.send((Message)message);
            sessionB.commit();
            sessionA.commit();
            sessionA.close();
            sessionB.close();
        }
        activemqConnection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=30L)
    public void testReceiveOutOfOrderProducers() throws Exception {
        try (Connection connection = this.protocolCF.createConnection();){
            Message message;
            int i;
            connection.start();
            int totalCount = 4;
            int consumeBeforeRollback = 2;
            this.sendToAmqQueueOutOfOrder(totalCount);
            Session session = connection.createSession(true, 0);
            jakarta.jms.Queue queue = session.createQueue(this.name);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            ArrayList<Integer> messageNumbers = new ArrayList<Integer>();
            for (i = 1; i <= consumeBeforeRollback; ++i) {
                message = consumer.receive(3000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((int)i, (int)message.getIntProperty("nr"), (String)"Unexpected message number");
                messageNumbers.add(message.getIntProperty("nr"));
            }
            for (i = 0; i < messageNumbers.size(); ++i) {
                Assertions.assertEquals((Integer)(i + 1), (Integer)((Integer)messageNumbers.get(i)), (String)("Unexpected order of messages: " + messageNumbers));
            }
            session.close();
            session = connection.createSession(true, 0);
            queue = session.createQueue(this.name);
            consumer = session.createConsumer((Destination)queue);
            messageNumbers = new ArrayList();
            for (i = 1; i <= totalCount; ++i) {
                message = consumer.receive(3000L);
                Assertions.assertNotNull((Object)message, (String)("Failed to receive message: " + i));
                int msgNum = message.getIntProperty("nr");
                messageNumbers.add(msgNum);
            }
            session.commit();
            Assertions.assertEquals((int)totalCount, (int)messageNumbers.size(), (String)"Unexpected size of list");
            for (i = 0; i < messageNumbers.size(); ++i) {
                Assertions.assertEquals((Integer)(i + 1), (Integer)((Integer)messageNumbers.get(i)), (String)("Unexpected order of messages: " + messageNumbers));
            }
        }
    }

    @TestTemplate
    public void testMultipleConsumersRollback() throws Exception {
        this.internalMultipleConsumers(true);
    }

    @TestTemplate
    public void testMultipleConsumersClose() throws Exception {
        this.internalMultipleConsumers(false);
    }

    private void internalMultipleConsumers(boolean rollback) throws Exception {
        jakarta.jms.Queue jmsQueue;
        Queue serverQueue = this.server.createQueue(QueueConfiguration.of((String)this.getName()).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        int numberOfMessages = 100;
        int numberOfConsumers = 3;
        ConnectionFactory factory = CFUtil.createConnectionFactory(this.protocol, "tcp://localhost:61616");
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(false, 1);
            jmsQueue = session.createQueue(this.getName());
            MessageProducer producer = session.createProducer((Destination)jmsQueue);
            for (int i = 0; i < numberOfMessages; ++i) {
                TextMessage message = session.createTextMessage("test " + i);
                message.setIntProperty("i", i);
                producer.send((Message)message);
            }
        }
        Wait.assertEquals((long)numberOfMessages, () -> ((Queue)serverQueue).getMessageCount());
        AtomicBoolean running = new AtomicBoolean(true);
        AtomicInteger errors = new AtomicInteger(0);
        Runnable r = () -> {
            try (Connection c = factory.createConnection();){
                Session s = c.createSession(true, 0);
                MessageConsumer cs = s.createConsumer((Destination)jmsQueue);
                c.start();
                int rollbacks = 0;
                while (running.get()) {
                    TextMessage txt = (TextMessage)cs.receive(500L);
                    if (txt != null) {
                        if (!rollback) continue;
                        s.rollback();
                        if (++rollbacks < 3) continue;
                        break;
                    }
                    return;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                errors.incrementAndGet();
                running.set(false);
            }
        };
        Thread[] threads = new Thread[numberOfConsumers];
        for (int i = 0; i < numberOfConsumers; ++i) {
            threads[i] = new Thread(r, "consumer " + i);
            threads[i].start();
        }
        for (Thread t : threads) {
            t.join();
        }
        Assertions.assertEquals((int)0, (int)errors.get());
        Wait.assertEquals((long)numberOfMessages, () -> ((Queue)serverQueue).getMessageCount());
        try (Connection c = factory.createConnection();){
            Session s = c.createSession(true, 0);
            MessageConsumer cs = s.createConsumer((Destination)jmsQueue);
            c.start();
            for (int i = 0; i < numberOfMessages; ++i) {
                TextMessage message = (TextMessage)cs.receive(1000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((int)i, (int)message.getIntProperty("i"));
            }
            Assertions.assertNull((Object)cs.receiveNoWait());
        }
    }
}

