/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidFilterExpressionException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SessionCreateConsumerTest
extends ActiveMQTestBase {
    private final String queueName = "ClientSessionCreateConsumerTestQ";
    private ServerLocator locator;
    private ActiveMQServer service;
    private ClientSessionInternal clientSession;
    private ClientSessionFactory cf;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.locator = this.createInVMNonHALocator();
        super.setUp();
        this.service = this.createServer(false);
        this.service.start();
        this.locator.setProducerMaxRate(99).setBlockOnNonDurableSend(true).setBlockOnNonDurableSend(true);
        this.cf = this.createSessionFactory(this.locator);
        this.clientSession = (ClientSessionInternal)this.addClientSession(this.cf.createSession(false, true, true));
    }

    @Test
    public void testCreateConsumer() throws Exception {
        this.clientSession.createQueue(QueueConfiguration.of((String)"ClientSessionCreateConsumerTestQ").setDurable(Boolean.valueOf(false)));
        ClientConsumer consumer = this.clientSession.createConsumer("ClientSessionCreateConsumerTestQ");
        Assertions.assertNotNull((Object)consumer);
    }

    @Test
    public void testCreateConsumerNoQ() throws Exception {
        try {
            this.clientSession.createConsumer("ClientSessionCreateConsumerTestQ");
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQNonExistentQueueException activeMQNonExistentQueueException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
    }

    @Test
    public void testCreateConsumerWithFilter() throws Exception {
        this.clientSession.createQueue(QueueConfiguration.of((String)"ClientSessionCreateConsumerTestQ").setDurable(Boolean.valueOf(false)));
        ClientConsumer consumer = this.clientSession.createConsumer("ClientSessionCreateConsumerTestQ", "foo=bar");
        Assertions.assertNotNull((Object)consumer);
    }

    @Test
    public void testCreateConsumerWithInvalidFilter() throws Exception {
        this.clientSession.createQueue(QueueConfiguration.of((String)"ClientSessionCreateConsumerTestQ").setDurable(Boolean.valueOf(false)));
        try {
            this.clientSession.createConsumer("ClientSessionCreateConsumerTestQ", "this is not valid filter");
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQInvalidFilterExpressionException activeMQInvalidFilterExpressionException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
    }

    @Test
    public void testCreateConsumerWithBrowseOnly() throws Exception {
        this.clientSession.createQueue(QueueConfiguration.of((String)"ClientSessionCreateConsumerTestQ").setDurable(Boolean.valueOf(false)));
        ClientConsumer consumer = this.clientSession.createConsumer("ClientSessionCreateConsumerTestQ", null, true);
        Assertions.assertNotNull((Object)consumer);
    }

    @Test
    public void testCreateConsumerWithOverrides() throws Exception {
        this.clientSession.createQueue(QueueConfiguration.of((String)"ClientSessionCreateConsumerTestQ").setDurable(Boolean.valueOf(false)));
        ClientConsumer consumer = this.clientSession.createConsumer("ClientSessionCreateConsumerTestQ", null, 100, 100, false);
        Assertions.assertNotNull((Object)consumer);
    }
}

