/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.bridge;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.MessageFlowRecord;
import org.apache.activemq.artemis.core.server.cluster.RemoteQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.impl.BridgeImpl;
import org.apache.activemq.artemis.core.server.cluster.impl.BridgeTestAccessor;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionBridge;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionImpl;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClusteredBridgeReconnectTest
extends ClusterTestBase {
    @Test
    public void testReconnectBridge() throws Exception {
        ClientMessage msg;
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        this.createQueue(1, "queues.testaddress", "queue0", null, true);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        ClientSession session0 = this.sfs[0].createSession();
        ClientSession session1 = this.sfs[0].createSession();
        session0.start();
        session1.start();
        ClientProducer producer = session0.createProducer("queues.testaddress");
        int NUMBER_OF_MESSAGES = 100;
        int REPEATS = 5;
        Assertions.assertEquals((int)1, (int)this.servers[0].getClusterManager().getClusterConnections().size());
        ClusterConnectionImpl connection = this.servers[0].getClusterManager().getClusterConnections().toArray(new ClusterConnectionImpl[0])[0];
        Assertions.assertEquals((int)1, (int)connection.getRecords().size());
        MessageFlowRecord record = connection.getRecords().values().toArray(new MessageFlowRecord[1])[0];
        ClusterConnectionBridge bridge = (ClusterConnectionBridge)record.getBridge();
        Wait.assertEquals((int)2, () -> bridge.getSessionFactory().getServerLocator().getTopology().getMembers().size());
        ArrayList originalmembers = new ArrayList(bridge.getSessionFactory().getServerLocator().getTopology().getMembers());
        AtomicInteger errors = new AtomicInteger(0);
        for (int repeat = 0; repeat < REPEATS; ++repeat) {
            CountDownLatch latchSent = new CountDownLatch(1);
            Thread t = new Thread(() -> {
                try {
                    for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
                        ClientMessage msg = session0.createMessage(true);
                        producer.send((Message)msg);
                        latchSent.countDown();
                        if (i % 10 != 0) continue;
                        session0.commit();
                    }
                    session0.commit();
                }
                catch (Exception e) {
                    errors.incrementAndGet();
                    e.printStackTrace();
                }
            });
            t.start();
            ArtemisExecutor executorFail = this.servers[0].getExecutorFactory().getExecutor();
            Assertions.assertTrue((boolean)latchSent.await(10L, TimeUnit.SECONDS));
            Wait.waitFor(() -> ClusteredBridgeReconnectTest.lambda$testReconnectBridge$4(bridge, (Executor)executorFail), (long)500L, (long)1L);
            Wait.assertEquals((Long)0L, () -> ((Queue)bridge.getQueue()).getMessageCount(), (long)5000L, (long)1L);
            Wait.assertEquals((int)0, () -> ((Queue)bridge.getQueue()).getDeliveringCount(), (long)5000L, (long)1L);
            t.join(5000L);
        }
        Assertions.assertEquals((int)0, (int)errors.get());
        Wait.assertEquals((int)2, () -> bridge.getSessionFactory().getServerLocator().getTopology().getMembers().size());
        ArrayList afterReconnectedMembers = new ArrayList(bridge.getSessionFactory().getServerLocator().getTopology().getMembers());
        boolean allFound = true;
        for (TopologyMemberImpl originalMember : originalmembers) {
            boolean found = false;
            for (TopologyMember reconnectedMember : afterReconnectedMembers) {
                if (!originalMember.equals((Object)reconnectedMember)) continue;
                found = true;
                break;
            }
            if (found) continue;
            allFound = false;
        }
        Assertions.assertTrue((boolean)allFound, (String)"The topology is slightly different after a reconnect");
        int cons0Count = 0;
        int cons1Count = 0;
        while ((msg = this.consumers[0].getConsumer().receiveImmediate()) != null) {
            ++cons0Count;
            msg.acknowledge();
            session0.commit();
        }
        while ((msg = this.consumers[1].getConsumer().receiveImmediate()) != null) {
            ++cons1Count;
            msg.acknowledge();
            session1.commit();
        }
        Assertions.assertEquals((int)(NUMBER_OF_MESSAGES * REPEATS), (int)(cons0Count + cons1Count), (String)("cons0 = " + cons0Count + ", cons1 = " + cons1Count));
        session0.commit();
        session1.commit();
        connection = this.servers[0].getClusterManager().getClusterConnections().toArray(new ClusterConnectionImpl[0])[0];
        Assertions.assertEquals((int)1, (int)connection.getRecords().size());
        Assertions.assertNotNull((Object)bridge.getSessionFactory());
        this.stopServers(0, 1);
    }

    @Test
    public void testClusterBridgeAddRemoteBinding() throws Exception {
        ClientMessage msg;
        String ADDRESS = "queues.testaddress";
        String QUEUE = UUID.randomUUID().toString();
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress", QUEUE, null, false);
        this.addConsumer(0, 0, QUEUE, null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 0, 0, true);
        this.waitForBindings(0, "queues.testaddress", 0, 0, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        ClientSession session0 = this.sfs[0].createSession();
        ClientSession session1 = this.sfs[1].createSession();
        session0.start();
        session1.start();
        ClientProducer producer1 = session1.createProducer("queues.testaddress");
        int NUMBER_OF_MESSAGES = 10;
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            msg = session1.createMessage(true);
            producer1.send((Message)msg);
            session1.commit();
        }
        int cons0Count = 0;
        while ((msg = this.consumers[0].getConsumer().receive(1000L)) != null) {
            ++cons0Count;
            msg.acknowledge();
            session0.commit();
        }
        Assertions.assertEquals((int)NUMBER_OF_MESSAGES, (int)cons0Count);
        this.removeConsumer(0);
        this.servers[0].getManagementService().enableNotifications(false);
        this.servers[0].destroyQueue(SimpleString.of((String)QUEUE));
        this.servers[0].getManagementService().enableNotifications(true);
        this.createQueue(0, "queues.testaddress", QUEUE, null, false);
        this.addConsumer(0, 0, QUEUE, null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 0, 0, true);
        this.waitForBindings(0, "queues.testaddress", 0, 0, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            ClientMessage msg2 = session1.createMessage(true);
            producer1.send((Message)msg2);
            session1.commit();
        }
        cons0Count = 0;
        while ((msg = this.consumers[0].getConsumer().receive(2000L)) != null) {
            ++cons0Count;
            msg.acknowledge();
            session0.commit();
        }
        Assertions.assertEquals((int)NUMBER_OF_MESSAGES, (int)cons0Count);
        this.stopServers(0, 1);
    }

    @Test
    public void testPauseAddressBlockingSnFQueue() throws Exception {
        int i;
        int i2;
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setRedistributionDelay(0L);
        this.servers[0].getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        this.servers[1].getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        ClientSession session0 = this.sfs[0].createSession();
        ClientSession session1 = this.sfs[1].createSession();
        session0.start();
        session1.start();
        this.createQueue(0, "queues.testaddress", "queue1", null, true);
        this.createQueue(1, "queues.testaddress", "queue1", null, true);
        ClientConsumer consumer1 = session1.createConsumer("queue1");
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.waitForBindings(1, "queues.testaddress", 1, 0, false);
        int num = 10;
        ClientProducer goodProducer0 = session0.createProducer("queues.testaddress");
        for (i2 = 0; i2 < 10; ++i2) {
            ClientMessage msg = session0.createMessage(true);
            msg.putStringProperty("origin", "from producer 0");
            goodProducer0.send((Message)msg);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            ClientMessage m = consumer1.receive(5000L);
            Assertions.assertNotNull((Object)m);
            String propValue = m.getStringProperty("origin");
            Assertions.assertEquals((Object)"from producer 0", (Object)propValue);
            m.acknowledge();
        }
        Assertions.assertNull((Object)consumer1.receiveImmediate());
        String addressControlResourceName = "address.queues.testaddress";
        Object resource = this.servers[0].getManagementService().getResource(addressControlResourceName);
        AddressControl addressControl0 = (AddressControl)resource;
        addressControl0.pause();
        Bindings bindings0 = this.servers[0].getPostOffice().getBindingsForAddress(SimpleString.of((String)"queues.testaddress"));
        Assertions.assertNotNull((Object)bindings0);
        Assertions.assertEquals((int)2, (int)bindings0.getBindings().size());
        boolean localBindingPaused = false;
        boolean remoteBindingPaused = true;
        for (Binding bd : bindings0.getBindings()) {
            if (bd instanceof LocalQueueBinding) {
                localBindingPaused = ((LocalQueueBinding)bd).getQueue().isPaused();
            }
            if (!(bd instanceof RemoteQueueBinding)) continue;
            remoteBindingPaused = ((RemoteQueueBinding)bd).getQueue().isPaused();
        }
        Assertions.assertTrue((boolean)localBindingPaused);
        Assertions.assertFalse((boolean)remoteBindingPaused);
        for (i = 0; i < 10; ++i) {
            ClientMessage msg = session0.createMessage(true);
            msg.putStringProperty("origin", "from producer 0");
            goodProducer0.send((Message)msg);
        }
        for (i = 0; i < 10; ++i) {
            ClientMessage m = consumer1.receive(5000L);
            Assertions.assertNotNull((Object)m);
            String propValue = m.getStringProperty("origin");
            Assertions.assertEquals((Object)"from producer 0", (Object)propValue);
            m.acknowledge();
        }
        Assertions.assertNull((Object)consumer1.receiveImmediate());
        this.stopServers(0, 1);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.closeAllConsumers();
        this.closeAllSessionFactories();
        this.closeAllServerLocatorsFactories();
        super.tearDown();
    }

    public boolean isNetty() {
        return true;
    }

    private static /* synthetic */ boolean lambda$testReconnectBridge$4(ClusterConnectionBridge bridge, Executor executorFail) throws Exception {
        return BridgeTestAccessor.withinRefs((BridgeImpl)bridge, refs -> {
            Map map = refs;
            synchronized (map) {
                if (refs.size() > 0) {
                    executorFail.execute(() -> bridge.connectionFailed(new ActiveMQException("bye"), false));
                    return true;
                }
                return false;
            }
        });
    }
}

