/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoWayTwoNodeClusterTest
extends ClusterTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.setupServers();
        this.setupClusters();
    }

    protected void setupServers() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
    }

    protected void setupClusters() {
        this.setupClusterConnection("cluster0", 0, 1, "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), false);
        this.setupClusterConnection("cluster1", 1, 0, "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), false);
    }

    protected boolean isNetty() {
        return false;
    }

    @Test
    @Timeout(value=60L)
    public void testClusterRestartWithConfigChanged() throws Exception {
        long msgCount1;
        long msgCount0;
        Configuration config0 = this.servers[0].getConfiguration();
        Configuration config1 = this.servers[1].getConfiguration();
        this.configureBeforeStart(config0, config1);
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues", "queue0", null, true);
        this.createQueue(1, "queues", "queue0", null, true);
        this.waitForBindings(0, "queues", 1, 0, true);
        this.waitForBindings(1, "queues", 1, 0, true);
        this.waitForBindings(0, "queues", 1, 0, false);
        this.waitForBindings(1, "queues", 1, 0, false);
        ClientSessionFactory sf0 = this.sfs[0];
        ClientSession session0 = sf0.createSession(false, false);
        ClientProducer producer = session0.createProducer("queues");
        int numSent = 200;
        for (int i = 0; i < 200; ++i) {
            ClientMessage msg = this.createTextMessage(session0, true, 5000);
            producer.send((Message)msg);
            if (i % 50 != 0) continue;
            session0.commit();
        }
        session0.commit();
        session0.close();
        while ((msgCount0 = (long)this.getMessageCount(this.servers[0], "queues")) + (msgCount1 = (long)this.getMessageCount(this.servers[1], "queues")) < 200L) {
            Thread.sleep(100L);
        }
        Queue queue0 = this.servers[0].locateQueue(SimpleString.of((String)"queue0"));
        Assertions.assertTrue((boolean)queue0.getPageSubscription().isPaging());
        this.closeAllSessionFactories();
        this.stopServers(0, 1);
        AddressSettings addressSettings0 = (AddressSettings)config0.getAddressSettings().get("#");
        AddressSettings addressSettings1 = (AddressSettings)config1.getAddressSettings().get("#");
        addressSettings0.setMaxSizeBytes(-1L);
        addressSettings1.setMaxSizeBytes(-1L);
        this.startServers(0, 1);
        this.waitForBindings(0, "queues", 1, 0, true);
        this.waitForBindings(1, "queues", 1, 0, true);
        this.waitForBindings(0, "queues", 1, 0, false);
        this.waitForBindings(1, "queues", 1, 0, false);
        this.setupSessionFactory(0, this.isNetty());
        this.addConsumer(0, 0, "queue0", null);
        this.waitForBindings(0, "queues", 1, 1, true);
        for (int i = 0; i < 200; ++i) {
            ClientMessage m = this.consumers[0].consumer.receive(5000L);
            Assertions.assertNotNull((Object)m, (String)("failed to receive message " + i));
        }
    }

    private void configureBeforeStart(Configuration ... serverConfigs) {
        for (Configuration config : serverConfigs) {
            config.setPersistenceEnabled(true);
            config.setMessageCounterEnabled(true);
            config.setJournalFileSize(0x1400000);
            config.setJournalMinFiles(20);
            config.setJournalCompactPercentage(50);
            Map addressSettingsMap0 = config.getAddressSettings();
            AddressSettings addrSettings = (AddressSettings)addressSettingsMap0.get("#");
            if (addrSettings == null) {
                addrSettings = new AddressSettings();
                addressSettingsMap0.put("#", addrSettings);
            }
            addrSettings.setDeadLetterAddress(SimpleString.of((String)"jms.queue.DLQ"));
            addrSettings.setExpiryAddress(SimpleString.of((String)"jms.queue.ExpiryQueue"));
            addrSettings.setRedeliveryDelay(30L);
            addrSettings.setMaxDeliveryAttempts(5);
            addrSettings.setMaxSizeBytes(0x100000L);
            addrSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
            addrSettings.setPageSizeBytes(524288);
            addrSettings.setMessageCounterHistoryDayLimit(10);
            addrSettings.setRedistributionDelay(1000L).setMaxReadPageBytes(-1).setMaxReadPageMessages(-1);
        }
    }

    @Test
    public void testStartStop() throws Exception {
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues", "queue0", null, false);
        this.createQueue(1, "queues", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(0, "queues", 1, 1, true);
        this.waitForBindings(1, "queues", 1, 1, true);
        this.waitForBindings(0, "queues", 1, 1, false);
        this.waitForBindings(1, "queues", 1, 1, false);
        this.send(0, "queues", 10, false, null);
        this.verifyReceiveRoundRobin(10, 0, 1);
        this.verifyNotReceive(0, 1);
        this.stopServers(0, 1);
    }

    @Test
    public void testStartPauseStartOther() throws Exception {
        this.startServers(0);
        this.setupSessionFactory(0, this.isNetty());
        this.createQueue(0, "queues", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.startServers(1);
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(1, "queues", "queue0", null, false);
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(0, "queues", 1, 1, true);
        this.waitForBindings(1, "queues", 1, 1, true);
        this.waitForBindings(0, "queues", 1, 1, false);
        this.waitForBindings(1, "queues", 1, 1, false);
        this.send(0, "queues", 10, false, null);
        this.verifyReceiveRoundRobin(10, 0, 1);
        this.verifyNotReceive(0, 1);
        this.stopServers(0, 1);
    }

    @Test
    public void testRestartServers() throws Throwable {
        String name = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName("ThreadOnTestRestartTest");
            this.startServers(0, 1);
            TwoWayTwoNodeClusterTest.waitForTopology(this.servers[0], 2);
            TwoWayTwoNodeClusterTest.waitForTopology(this.servers[1], 2);
            for (int i = 0; i < 10; ++i) {
                logger.debug("Sleep #test {}", (Object)i);
                logger.debug("#stop #test #{}", (Object)i);
                Thread.sleep(500L);
                this.stopServers(1);
                TwoWayTwoNodeClusterTest.waitForTopology(this.servers[0], 1, -1, 2000L);
                logger.debug("#start #test #{}", (Object)i);
                this.startServers(1);
                TwoWayTwoNodeClusterTest.waitForTopology(this.servers[0], 2, -1, 2000L);
                TwoWayTwoNodeClusterTest.waitForTopology(this.servers[1], 2, -1, 2000L);
            }
        }
        finally {
            Thread.currentThread().setName(name);
        }
    }

    @Test
    public void testStopStart() throws Exception {
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues", "queue0", null, true);
        this.createQueue(1, "queues", "queue0", null, true);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(0, "queues", 1, 1, true);
        this.waitForBindings(1, "queues", 1, 1, true);
        this.waitForBindings(0, "queues", 1, 1, false);
        this.waitForBindings(1, "queues", 1, 1, false);
        this.send(0, "queues", 10, false, null);
        this.verifyReceiveRoundRobin(10, 0, 1);
        this.verifyNotReceive(0, 1);
        this.removeConsumer(1);
        this.closeSessionFactory(1);
        this.stopServers(1);
        TwoWayTwoNodeClusterTest.waitForTopology(this.servers[0], 1, -1, 2000L);
        logger.debug(this.clusterDescription(this.servers[0]));
        this.startServers(1);
        logger.debug(this.clusterDescription(this.servers[0]));
        logger.debug(this.clusterDescription(this.servers[1]));
        this.setupSessionFactory(1, this.isNetty());
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(0, "queues", 1, 1, true);
        this.waitForBindings(1, "queues", 1, 1, true);
        this.waitForBindings(1, "queues", 1, 1, false);
        this.waitForBindings(0, "queues", 1, 1, false);
        this.send(0, "queues", 10, false, null);
        this.verifyReceiveRoundRobin(10, 0, 1);
        this.verifyNotReceive(0, 1);
        this.stopServers(0, 1);
    }
}

