/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.topology;

import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.topology.TopologyClusterTestBase;

public class HAClientTopologyWithDiscoveryTest
extends TopologyClusterTestBase {
    protected final String groupAddress = HAClientTopologyWithDiscoveryTest.getUDPDiscoveryAddress();
    protected final int groupPort = HAClientTopologyWithDiscoveryTest.getUDPDiscoveryPort();

    @Override
    protected boolean isNetty() {
        return false;
    }

    @Override
    protected void setupCluster() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
    }

    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.setupDiscoveryClusterConnection("cluster0", 0, "dg1", "queues", messageLoadBalancingType, 1, this.isNetty());
        this.setupDiscoveryClusterConnection("cluster1", 1, "dg1", "queues", messageLoadBalancingType, 1, this.isNetty());
        this.setupDiscoveryClusterConnection("cluster2", 2, "dg1", "queues", messageLoadBalancingType, 1, this.isNetty());
        this.setupDiscoveryClusterConnection("cluster3", 3, "dg1", "queues", messageLoadBalancingType, 1, this.isNetty());
        this.setupDiscoveryClusterConnection("cluster4", 4, "dg1", "queues", messageLoadBalancingType, 1, this.isNetty());
    }

    @Override
    protected void setupServers() throws Exception {
        this.setupPrimaryServerWithDiscovery(0, this.groupAddress, this.groupPort, this.isFileStorage(), this.isNetty(), false);
        this.setupPrimaryServerWithDiscovery(1, this.groupAddress, this.groupPort, this.isFileStorage(), this.isNetty(), false);
        this.setupPrimaryServerWithDiscovery(2, this.groupAddress, this.groupPort, this.isFileStorage(), this.isNetty(), false);
        this.setupPrimaryServerWithDiscovery(3, this.groupAddress, this.groupPort, this.isFileStorage(), this.isNetty(), false);
        this.setupPrimaryServerWithDiscovery(4, this.groupAddress, this.groupPort, this.isFileStorage(), this.isNetty(), false);
    }

    @Override
    protected ServerLocator createHAServerLocator() {
        ServerLocator locator = ActiveMQClient.createServerLocatorWithHA((DiscoveryGroupConfiguration)new DiscoveryGroupConfiguration().setBroadcastEndpointFactory((BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(this.groupAddress).setGroupPort(this.groupPort)));
        locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true);
        this.addServerLocator(locator);
        return locator;
    }
}

