/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQTextMessage;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class GroupingTest
extends JMSTestBase {
    private Queue queue;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.queue = this.createQueue("TestQueue");
    }

    protected void setProperty(Message message) {
        ((ActiveMQMessage)message).getCoreMessage().putStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_GROUP_ID, SimpleString.of((String)"foo"));
    }

    protected ConnectionFactory getCF() throws Exception {
        return this.cf;
    }

    @Test
    public void testGrouping() throws Exception {
        int j;
        ConnectionFactory fact = this.getCF();
        Connection connection = fact.createConnection();
        Session session = connection.createSession(false, 2);
        MessageProducer producer = session.createProducer((Destination)this.queue);
        MessageConsumer consumer1 = session.createConsumer((Destination)this.queue);
        MessageConsumer consumer2 = session.createConsumer((Destination)this.queue);
        MessageConsumer consumer3 = session.createConsumer((Destination)this.queue);
        connection.start();
        String jmsxgroupID = null;
        for (j = 0; j < 100; ++j) {
            TextMessage message = session.createTextMessage();
            message.setText("Message" + j);
            this.setProperty((Message)message);
            producer.send((Message)message);
            String prop = message.getStringProperty("JMSXGroupID");
            Assertions.assertNotNull((Object)prop);
            if (jmsxgroupID != null) {
                Assertions.assertEquals((Object)jmsxgroupID, (Object)prop);
                continue;
            }
            jmsxgroupID = prop;
        }
        for (j = 0; j < 100; ++j) {
            TextMessage tm = (TextMessage)consumer1.receive(10000L);
            Assertions.assertNotNull((Object)tm);
            Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
            Assertions.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), jmsxgroupID);
        }
        connection.close();
    }

    @Test
    public void testGroupingWithJMS2Producer() throws Exception {
        int j;
        ConnectionFactory fact = this.getCF();
        Assumptions.assumeFalse((boolean)((ActiveMQConnectionFactory)fact).isAutoGroup(), (String)"only makes sense withOUT auto-group");
        Assumptions.assumeTrue((((ActiveMQConnectionFactory)fact).getGroupID() == null ? 1 : 0) != 0, (String)"only makes sense withOUT explicit group-id");
        String groupID = UUID.randomUUID().toString();
        JMSContext ctx = this.addContext(this.getCF().createContext(0));
        JMSProducer producer = ctx.createProducer().setProperty("JMSXGroupID", groupID);
        JMSConsumer consumer1 = ctx.createConsumer((Destination)this.queue);
        JMSConsumer consumer2 = ctx.createConsumer((Destination)this.queue);
        JMSConsumer consumer3 = ctx.createConsumer((Destination)this.queue);
        ctx.start();
        for (j = 0; j < 100; ++j) {
            TextMessage message = ctx.createTextMessage("Message" + j);
            producer.send((Destination)this.queue, (Message)message);
            String prop = message.getStringProperty("JMSXGroupID");
            Assertions.assertNotNull((Object)prop);
            Assertions.assertEquals((Object)groupID, (Object)prop);
        }
        ctx.commit();
        for (j = 0; j < 100; ++j) {
            TextMessage tm = (TextMessage)consumer1.receive(10000L);
            Assertions.assertNotNull((Object)tm);
            tm.acknowledge();
            Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
            Assertions.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)groupID);
            tm = (TextMessage)consumer2.receiveNoWait();
            Assertions.assertNull((Object)tm);
            tm = (TextMessage)consumer3.receiveNoWait();
            Assertions.assertNull((Object)tm);
        }
        ctx.commit();
        ctx.close();
    }

    @Test
    public void testManyGroups() throws Exception {
        ConnectionFactory fact = this.getCF();
        Assumptions.assumeFalse((boolean)((ActiveMQConnectionFactory)fact).isAutoGroup(), (String)"only makes sense withOUT auto-group");
        Connection connection = fact.createConnection();
        Session session = connection.createSession(false, 2);
        MessageProducer producer = session.createProducer((Destination)this.queue);
        MessageConsumer consumer1 = session.createConsumer((Destination)this.queue);
        MessageConsumer consumer2 = session.createConsumer((Destination)this.queue);
        MessageConsumer consumer3 = session.createConsumer((Destination)this.queue);
        connection.start();
        for (int j = 0; j < 1000; ++j) {
            TextMessage message = session.createTextMessage();
            message.setText("Message" + j);
            message.setStringProperty("_AMQ_GROUP_ID", "" + j % 10);
            producer.send((Message)message);
            String prop = message.getStringProperty("JMSXGroupID");
            Assertions.assertNotNull((Object)prop);
        }
        int msg1 = this.flushMessages(consumer1);
        int msg2 = this.flushMessages(consumer2);
        int msg3 = this.flushMessages(consumer3);
        Assertions.assertNotSame((Object)0, (Object)msg1);
        Assertions.assertNotSame((Object)0, (Object)msg2);
        Assertions.assertNotSame((Object)0, (Object)msg2);
        consumer1.close();
        consumer2.close();
        consumer3.close();
        connection.close();
    }

    @Test
    public void testGroupingRollbackOnClose() throws Exception {
        TextMessage tm;
        int j;
        ActiveMQConnectionFactory fact = (ActiveMQConnectionFactory)this.getCF();
        fact.setConsumerWindowSize(1000);
        fact.setTransactionBatchSize(0);
        Connection connection = fact.createConnection();
        RemotingConnection rc = (RemotingConnection)this.server.getRemotingService().getConnections().iterator().next();
        Connection connection2 = fact.createConnection();
        Session session = connection.createSession(true, 0);
        Session session2 = connection2.createSession(true, 0);
        MessageProducer producer = session.createProducer((Destination)this.queue);
        MessageConsumer consumer1 = session.createConsumer((Destination)this.queue);
        MessageConsumer consumer2 = session2.createConsumer((Destination)this.queue);
        connection.start();
        connection2.start();
        String jmsxgroupID = null;
        for (j = 0; j < 100; ++j) {
            TextMessage message = session.createTextMessage();
            message.setText("Message" + j);
            this.setProperty((Message)message);
            producer.send((Message)message);
            String prop = message.getStringProperty("JMSXGroupID");
            Assertions.assertNotNull((Object)prop);
            if (jmsxgroupID != null) {
                Assertions.assertEquals((Object)jmsxgroupID, (Object)prop);
                continue;
            }
            jmsxgroupID = prop;
        }
        session.commit();
        for (j = 0; j < 1; ++j) {
            tm = (TextMessage)consumer1.receive(10000L);
            Assertions.assertNotNull((Object)tm);
            Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
            Assertions.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)jmsxgroupID);
        }
        rc.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
        for (j = 0; j < 10; ++j) {
            tm = (TextMessage)consumer2.receive(10000L);
            Assertions.assertNotNull((Object)tm);
            long text = ((ActiveMQTextMessage)tm).getCoreMessage().getMessageID();
            Assertions.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)jmsxgroupID);
        }
        connection.close();
        connection2.close();
    }

    private int flushMessages(MessageConsumer consumer) throws JMSException {
        TextMessage msg;
        int received = 0;
        while ((msg = (TextMessage)consumer.receiveNoWait()) != null) {
            msg.acknowledge();
            ++received;
        }
        return received;
    }

    @Test
    public void testGroupBuckets() throws Exception {
        TextMessage tm;
        int j;
        ConnectionFactory fact = this.getCF();
        Assumptions.assumeFalse((boolean)((ActiveMQConnectionFactory)fact).isAutoGroup(), (String)"only makes sense withOUT auto-group");
        Assumptions.assumeTrue((((ActiveMQConnectionFactory)fact).getGroupID() == null ? 1 : 0) != 0, (String)"only makes sense withOUT explicit group-id");
        String testQueueName = this.getName() + "_bucket_group";
        this.server.createQueue(QueueConfiguration.of((String)testQueueName).setRoutingType(RoutingType.ANYCAST).setGroupBuckets(Integer.valueOf(2)));
        JMSContext ctx = this.addContext(this.getCF().createContext(0));
        Queue testQueue = ctx.createQueue(testQueueName);
        String groupID1 = "groupA";
        String groupID2 = "groupB";
        String groupID3 = "groupC";
        Assertions.assertEquals((int)(("groupA".hashCode() & Integer.MAX_VALUE) % 2), (int)0);
        Assertions.assertEquals((int)(("groupB".hashCode() & Integer.MAX_VALUE) % 2), (int)1);
        Assertions.assertEquals((int)(("groupC".hashCode() & Integer.MAX_VALUE) % 2), (int)0);
        JMSProducer producer1 = ctx.createProducer().setProperty("JMSXGroupID", "groupA");
        JMSProducer producer2 = ctx.createProducer().setProperty("JMSXGroupID", "groupB");
        JMSProducer producer3 = ctx.createProducer().setProperty("JMSXGroupID", "groupC");
        JMSConsumer consumer1 = ctx.createConsumer((Destination)testQueue);
        JMSConsumer consumer2 = ctx.createConsumer((Destination)testQueue);
        JMSConsumer consumer3 = ctx.createConsumer((Destination)testQueue);
        ctx.start();
        for (j = 0; j < 10; ++j) {
            this.send(ctx, testQueue, "groupA", producer1, j);
        }
        for (j = 10; j < 20; ++j) {
            this.send(ctx, testQueue, "groupB", producer2, j);
        }
        for (j = 20; j < 30; ++j) {
            this.send(ctx, testQueue, "groupC", producer3, j);
        }
        ctx.commit();
        for (j = 0; j < 10; ++j) {
            tm = (TextMessage)consumer1.receive(10000L);
            Assertions.assertNotNull((Object)tm);
            tm.acknowledge();
            Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
            Assertions.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupA");
            tm = (TextMessage)consumer2.receive(10000L);
            Assertions.assertNotNull((Object)tm);
            tm.acknowledge();
            Assertions.assertEquals((Object)("Message" + (j + 10)), (Object)tm.getText());
            Assertions.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupB");
            Assertions.assertNull((Object)consumer3.receiveNoWait());
        }
        for (j = 20; j < 30; ++j) {
            tm = (TextMessage)consumer1.receive(10000L);
            Assertions.assertNotNull((Object)tm);
            tm.acknowledge();
            Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
            Assertions.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupC");
            Assertions.assertNull((Object)consumer2.receiveNoWait());
            Assertions.assertNull((Object)consumer3.receiveNoWait());
        }
        ctx.commit();
        ctx.close();
    }

    @Test
    public void testGroupRebalance() throws Exception {
        TextMessage tm;
        int j;
        TextMessage tm2;
        int j2;
        ConnectionFactory fact = this.getCF();
        Assumptions.assumeFalse((boolean)((ActiveMQConnectionFactory)fact).isAutoGroup(), (String)"only makes sense withOUT auto-group");
        Assumptions.assumeTrue((((ActiveMQConnectionFactory)fact).getGroupID() == null ? 1 : 0) != 0, (String)"only makes sense withOUT explicit group-id");
        String testQueueName = this.getName() + "_group_rebalance";
        this.server.createQueue(QueueConfiguration.of((String)testQueueName).setRoutingType(RoutingType.ANYCAST).setGroupRebalance(Boolean.valueOf(true)));
        JMSContext ctx = this.addContext(this.getCF().createContext(0));
        Queue testQueue = ctx.createQueue(testQueueName);
        String groupID1 = "groupA";
        String groupID2 = "groupB";
        String groupID3 = "groupC";
        JMSProducer producer1 = ctx.createProducer().setProperty("JMSXGroupID", "groupA");
        JMSProducer producer2 = ctx.createProducer().setProperty("JMSXGroupID", "groupB");
        JMSProducer producer3 = ctx.createProducer().setProperty("JMSXGroupID", "groupC");
        JMSConsumer consumer1 = ctx.createConsumer((Destination)testQueue);
        JMSConsumer consumer2 = ctx.createConsumer((Destination)testQueue);
        ctx.start();
        for (j2 = 0; j2 < 10; ++j2) {
            this.send(ctx, testQueue, "groupA", producer1, j2);
        }
        for (j2 = 10; j2 < 20; ++j2) {
            this.send(ctx, testQueue, "groupB", producer2, j2);
        }
        for (j2 = 20; j2 < 30; ++j2) {
            this.send(ctx, testQueue, "groupC", producer3, j2);
        }
        ctx.commit();
        for (j2 = 0; j2 < 10; ++j2) {
            tm2 = (TextMessage)consumer1.receive(10000L);
            Assertions.assertNotNull((Object)tm2);
            tm2.acknowledge();
            Assertions.assertEquals((Object)("Message" + j2), (Object)tm2.getText());
            Assertions.assertEquals((Object)tm2.getStringProperty("JMSXGroupID"), (Object)"groupA");
        }
        for (j2 = 10; j2 < 20; ++j2) {
            tm2 = (TextMessage)consumer2.receive(10000L);
            Assertions.assertNotNull((Object)tm2);
            tm2.acknowledge();
            Assertions.assertEquals((Object)("Message" + j2), (Object)tm2.getText());
            Assertions.assertEquals((Object)tm2.getStringProperty("JMSXGroupID"), (Object)"groupB");
        }
        for (j2 = 20; j2 < 30; ++j2) {
            tm2 = (TextMessage)consumer1.receive(10000L);
            Assertions.assertNotNull((Object)tm2);
            tm2.acknowledge();
            Assertions.assertEquals((Object)("Message" + j2), (Object)tm2.getText());
            Assertions.assertEquals((Object)tm2.getStringProperty("JMSXGroupID"), (Object)"groupC");
        }
        ctx.commit();
        JMSConsumer consumer3 = ctx.createConsumer((Destination)testQueue);
        for (j = 0; j < 10; ++j) {
            this.send(ctx, testQueue, "groupA", producer1, j);
        }
        for (j = 10; j < 20; ++j) {
            this.send(ctx, testQueue, "groupB", producer2, j);
        }
        for (j = 20; j < 30; ++j) {
            this.send(ctx, testQueue, "groupC", producer3, j);
        }
        ctx.commit();
        for (j = 0; j < 10; ++j) {
            tm = (TextMessage)consumer1.receive(10000L);
            Assertions.assertNotNull((Object)tm);
            tm.acknowledge();
            Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
            Assertions.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupA");
        }
        for (j = 10; j < 20; ++j) {
            tm = (TextMessage)consumer2.receive(10000L);
            Assertions.assertNotNull((Object)tm);
            tm.acknowledge();
            Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
            Assertions.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupB");
        }
        for (j = 20; j < 30; ++j) {
            tm = (TextMessage)consumer3.receive(10000L);
            Assertions.assertNotNull((Object)tm);
            tm.acknowledge();
            Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
            Assertions.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupC");
        }
        ctx.commit();
        ctx.close();
    }

    @Test
    public void testGroupRebalancePauseDispatch() throws Exception {
        TextMessage tm;
        int j;
        TextMessage tm2;
        int j2;
        ConnectionFactory fact = this.getCF();
        Assumptions.assumeFalse((boolean)((ActiveMQConnectionFactory)fact).isAutoGroup(), (String)"only makes sense withOUT auto-group");
        Assumptions.assumeTrue((((ActiveMQConnectionFactory)fact).getGroupID() == null ? 1 : 0) != 0, (String)"only makes sense withOUT explicit group-id");
        String testQueueName = this.getName() + "_group_rebalance";
        this.server.createQueue(QueueConfiguration.of((String)testQueueName).setRoutingType(RoutingType.ANYCAST).setGroupRebalance(Boolean.valueOf(true)).setGroupRebalancePauseDispatch(Boolean.valueOf(true)));
        JMSContext ctx = this.addContext(this.getCF().createContext(0));
        Queue testQueue = ctx.createQueue(testQueueName);
        String groupID1 = "groupA";
        String groupID2 = "groupB";
        String groupID3 = "groupC";
        JMSProducer producer1 = ctx.createProducer().setProperty("JMSXGroupID", "groupA");
        JMSProducer producer2 = ctx.createProducer().setProperty("JMSXGroupID", "groupB");
        JMSProducer producer3 = ctx.createProducer().setProperty("JMSXGroupID", "groupC");
        JMSConsumer consumer1 = ctx.createConsumer((Destination)testQueue);
        JMSConsumer consumer2 = ctx.createConsumer((Destination)testQueue);
        ctx.start();
        for (j2 = 0; j2 < 10; ++j2) {
            this.send(ctx, testQueue, "groupA", producer1, j2);
        }
        for (j2 = 10; j2 < 20; ++j2) {
            this.send(ctx, testQueue, "groupB", producer2, j2);
        }
        for (j2 = 20; j2 < 30; ++j2) {
            this.send(ctx, testQueue, "groupC", producer3, j2);
        }
        ctx.commit();
        for (j2 = 0; j2 < 10; ++j2) {
            tm2 = (TextMessage)consumer1.receive(10000L);
            Assertions.assertNotNull((Object)tm2);
            tm2.acknowledge();
            Assertions.assertEquals((Object)("Message" + j2), (Object)tm2.getText());
            Assertions.assertEquals((Object)tm2.getStringProperty("JMSXGroupID"), (Object)"groupA");
        }
        ctx.commit();
        for (j2 = 10; j2 < 20; ++j2) {
            tm2 = (TextMessage)consumer2.receive(10000L);
            Assertions.assertNotNull((Object)tm2);
            tm2.acknowledge();
            Assertions.assertEquals((Object)("Message" + j2), (Object)tm2.getText());
            Assertions.assertEquals((Object)tm2.getStringProperty("JMSXGroupID"), (Object)"groupB");
        }
        ctx.commit();
        JMSConsumer consumer3 = ctx.createConsumer((Destination)testQueue);
        for (j = 0; j < 10; ++j) {
            this.send(ctx, testQueue, "groupA", producer1, j);
        }
        for (j = 10; j < 20; ++j) {
            this.send(ctx, testQueue, "groupB", producer2, j);
        }
        for (j = 20; j < 30; ++j) {
            this.send(ctx, testQueue, "groupC", producer3, j);
        }
        ctx.commit();
        Assertions.assertNull((Object)consumer2.receiveNoWait());
        Assertions.assertNull((Object)consumer3.receiveNoWait());
        for (j = 20; j < 30; ++j) {
            tm = (TextMessage)consumer1.receive(10000L);
            Assertions.assertNotNull((Object)tm);
            tm.acknowledge();
            Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
            Assertions.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupC");
        }
        ctx.commit();
        for (j = 0; j < 10; ++j) {
            tm = (TextMessage)consumer1.receive(10000L);
            Assertions.assertNotNull((Object)tm);
            tm.acknowledge();
            Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
            Assertions.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupA");
        }
        for (j = 10; j < 20; ++j) {
            tm = (TextMessage)consumer2.receive(10000L);
            Assertions.assertNotNull((Object)tm);
            tm.acknowledge();
            Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
            Assertions.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupB");
        }
        for (j = 20; j < 30; ++j) {
            tm = (TextMessage)consumer3.receive(10000L);
            Assertions.assertNotNull((Object)tm);
            tm.acknowledge();
            Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
            Assertions.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupC");
        }
        ctx.commit();
        ctx.close();
    }

    @Test
    public void testGroupFirstKey() throws Exception {
        TextMessage tm;
        int j;
        String customFirstGroupKey = "my-custom-key";
        ConnectionFactory fact = this.getCF();
        Assumptions.assumeFalse((boolean)((ActiveMQConnectionFactory)fact).isAutoGroup(), (String)"only makes sense withOUT auto-group");
        Assumptions.assumeTrue((((ActiveMQConnectionFactory)fact).getGroupID() == null ? 1 : 0) != 0, (String)"only makes sense withOUT explicit group-id");
        String testQueueName = this.getName() + "_group_first_key";
        this.server.createQueue(QueueConfiguration.of((String)testQueueName).setRoutingType(RoutingType.ANYCAST).setGroupRebalance(Boolean.valueOf(true)).setGroupFirstKey(customFirstGroupKey));
        JMSContext ctx = this.addContext(this.getCF().createContext(0));
        Queue testQueue = ctx.createQueue(testQueueName);
        String groupID1 = "groupA";
        String groupID2 = "groupB";
        String groupID3 = "groupC";
        JMSProducer producer1 = ctx.createProducer().setProperty("JMSXGroupID", "groupA");
        JMSProducer producer2 = ctx.createProducer().setProperty("JMSXGroupID", "groupB");
        JMSProducer producer3 = ctx.createProducer().setProperty("JMSXGroupID", "groupC");
        JMSConsumer consumer1 = ctx.createConsumer((Destination)testQueue);
        JMSConsumer consumer2 = ctx.createConsumer((Destination)testQueue);
        ctx.start();
        for (j = 0; j < 10; ++j) {
            this.send(ctx, testQueue, "groupA", producer1, j);
        }
        for (j = 10; j < 20; ++j) {
            this.send(ctx, testQueue, "groupB", producer2, j);
        }
        for (j = 20; j < 30; ++j) {
            this.send(ctx, testQueue, "groupC", producer3, j);
        }
        ctx.commit();
        for (j = 0; j < 10; ++j) {
            tm = (TextMessage)consumer1.receive(10000L);
            Assertions.assertNotNull((Object)tm);
            tm.acknowledge();
            Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
            Assertions.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupA");
            if (j == 0) {
                Assertions.assertTrue((boolean)tm.getBooleanProperty(customFirstGroupKey));
                continue;
            }
            Assertions.assertFalse((boolean)tm.propertyExists(customFirstGroupKey));
        }
        for (j = 10; j < 20; ++j) {
            tm = (TextMessage)consumer2.receive(10000L);
            Assertions.assertNotNull((Object)tm);
            tm.acknowledge();
            Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
            Assertions.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupB");
            if (j == 10) {
                Assertions.assertTrue((boolean)tm.getBooleanProperty(customFirstGroupKey));
                continue;
            }
            Assertions.assertFalse((boolean)tm.propertyExists(customFirstGroupKey));
        }
        for (j = 20; j < 30; ++j) {
            tm = (TextMessage)consumer1.receive(10000L);
            Assertions.assertNotNull((Object)tm);
            tm.acknowledge();
            Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
            Assertions.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupC");
            if (j == 20) {
                Assertions.assertTrue((boolean)tm.getBooleanProperty(customFirstGroupKey));
                continue;
            }
            Assertions.assertFalse((boolean)tm.propertyExists(customFirstGroupKey));
        }
        ctx.commit();
        ctx.close();
    }

    @Test
    public void testGroupDisable() throws Exception {
        int j;
        ConnectionFactory fact = this.getCF();
        Assumptions.assumeFalse((boolean)((ActiveMQConnectionFactory)fact).isAutoGroup(), (String)"only makes sense withOUT auto-group");
        Assumptions.assumeTrue((((ActiveMQConnectionFactory)fact).getGroupID() == null ? 1 : 0) != 0, (String)"only makes sense withOUT explicit group-id");
        String testQueueName = this.getName() + "_group_disable";
        this.server.createQueue(QueueConfiguration.of((String)testQueueName).setRoutingType(RoutingType.ANYCAST).setGroupBuckets(Integer.valueOf(0)));
        JMSContext ctx = this.addContext(this.getCF().createContext(0));
        Queue testQueue = ctx.createQueue(testQueueName);
        String groupID1 = "groupA";
        String groupID2 = "groupB";
        String groupID3 = "groupC";
        JMSProducer producer1 = ctx.createProducer().setProperty("JMSXGroupID", "groupA");
        JMSProducer producer2 = ctx.createProducer().setProperty("JMSXGroupID", "groupB");
        JMSProducer producer3 = ctx.createProducer().setProperty("JMSXGroupID", "groupC");
        JMSConsumer consumer1 = ctx.createConsumer((Destination)testQueue);
        JMSConsumer consumer2 = ctx.createConsumer((Destination)testQueue);
        JMSConsumer consumer3 = ctx.createConsumer((Destination)testQueue);
        ctx.start();
        for (j = 0; j < 10; ++j) {
            this.send(ctx, testQueue, "groupA", producer1, j);
        }
        for (j = 10; j < 20; ++j) {
            this.send(ctx, testQueue, "groupB", producer2, j);
        }
        for (j = 20; j < 30; ++j) {
            this.send(ctx, testQueue, "groupC", producer3, j);
        }
        ctx.commit();
        for (j = 0; j < 30; ++j) {
            TextMessage tm = (TextMessage)consumer1.receive(10000L);
            Assertions.assertNotNull((Object)tm);
            tm.acknowledge();
            Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
            Assertions.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)(j < 10 ? "groupA" : (j < 20 ? "groupB" : "groupC")));
            tm = (TextMessage)consumer2.receive(10000L);
            Assertions.assertNotNull((Object)tm);
            tm.acknowledge();
            Assertions.assertEquals((Object)("Message" + ++j), (Object)tm.getText());
            Assertions.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)(j < 10 ? "groupA" : (j < 20 ? "groupB" : "groupC")));
            tm = (TextMessage)consumer3.receive(10000L);
            Assertions.assertNotNull((Object)tm);
            tm.acknowledge();
            Assertions.assertEquals((Object)("Message" + ++j), (Object)tm.getText());
            Assertions.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)(j < 10 ? "groupA" : (j < 20 ? "groupB" : "groupC")));
        }
        ctx.commit();
        ctx.close();
    }

    private void send(JMSContext ctx, Queue testQueue, String groupID1, JMSProducer producer1, int j) throws JMSException {
        TextMessage message = ctx.createTextMessage("Message" + j);
        producer1.send((Destination)testQueue, (Message)message);
        String prop = message.getStringProperty("JMSXGroupID");
        Assertions.assertNotNull((Object)prop);
        Assertions.assertEquals((Object)groupID1, (Object)prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupBucketUsingAddressQueueParameters() throws Exception {
        ConnectionFactory fact = this.getCF();
        try (Connection connection = fact.createConnection();){
            Session session = connection.createSession(false, 2);
            String testQueueName = this.getName() + "group_bucket_param";
            Queue queue = session.createQueue(testQueueName + "?group-buckets=4");
            Assertions.assertEquals((Object)testQueueName, (Object)queue.getQueueName());
            ActiveMQDestination a = (ActiveMQDestination)queue;
            Assertions.assertEquals((Integer)4, (Integer)a.getQueueAttributes().getGroupBuckets());
            Assertions.assertEquals((Integer)4, (Integer)a.getQueueConfiguration().getGroupBuckets());
            MessageProducer producer = session.createProducer((Destination)queue);
            QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.of((String)testQueueName));
            Assertions.assertEquals((int)4, (int)queueBinding.getQueue().getGroupBuckets());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupRebalanceUsingAddressQueueParameters() throws Exception {
        ConnectionFactory fact = this.getCF();
        try (Connection connection = fact.createConnection();){
            Session session = connection.createSession(false, 2);
            String testQueueName = this.getName() + "group_rebalance_param";
            Queue queue = session.createQueue(testQueueName + "?group-rebalance=true");
            Assertions.assertEquals((Object)testQueueName, (Object)queue.getQueueName());
            ActiveMQDestination a = (ActiveMQDestination)queue;
            Assertions.assertTrue((boolean)a.getQueueAttributes().getGroupRebalance());
            Assertions.assertTrue((boolean)a.getQueueConfiguration().isGroupRebalance());
            MessageProducer producer = session.createProducer((Destination)queue);
            QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.of((String)testQueueName));
            Assertions.assertTrue((boolean)queueBinding.getQueue().isGroupRebalance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupFirstKeyUsingAddressQueueParameters() throws Exception {
        ConnectionFactory fact = this.getCF();
        try (Connection connection = fact.createConnection();){
            Session session = connection.createSession(false, 2);
            String testQueueName = this.getName() + "group_first_key_param";
            Queue queue = session.createQueue(testQueueName + "?group-first-key=my-custom-key");
            Assertions.assertEquals((Object)testQueueName, (Object)queue.getQueueName());
            ActiveMQDestination a = (ActiveMQDestination)queue;
            Assertions.assertEquals((Object)"my-custom-key", (Object)a.getQueueAttributes().getGroupFirstKey().toString());
            MessageProducer producer = session.createProducer((Destination)queue);
            QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.of((String)testQueueName));
            Assertions.assertEquals((Object)"my-custom-key", (Object)queueBinding.getQueue().getGroupFirstKey().toString());
        }
    }
}

