/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.multiprotocol;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.jms.multiprotocol.MultiprotocolJMSClientTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSMessageGroupsTest
extends MultiprotocolJMSClientTestSupport {
    protected static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int ITERATIONS = 10;
    private static final int MESSAGE_COUNT = 10;
    private static final int MESSAGE_SIZE = 10240;
    private static final int RECEIVE_TIMEOUT = 1000;
    private static final String JMSX_GROUP_ID = "JmsGroupsTest";

    @Override
    protected void configureAddressPolicy(ActiveMQServer server) {
        super.configureAddressPolicy(server);
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        addressSettings.setAutoCreateQueues(Boolean.valueOf(this.isAutoCreateQueues()));
        addressSettings.setAutoCreateAddresses(Boolean.valueOf(this.isAutoCreateAddresses()));
        addressSettings.setDeadLetterAddress(SimpleString.of((String)this.getDeadLetterAddress()));
        addressSettings.setExpiryAddress(SimpleString.of((String)this.getDeadLetterAddress()));
        addressSettings.setDefaultGroupFirstKey(SimpleString.of((String)"JMSXFirstInGroupID"));
        server.getConfiguration().getAddressSettings().put("GroupFirst.#", addressSettings);
    }

    @Test
    @Timeout(value=60L)
    public void testMessageGroupsAMQPProducerAMQPConsumer() throws Exception {
        this.testMessageGroups(this.AMQPConnection, this.AMQPConnection);
    }

    @Test
    @Timeout(value=60L)
    public void testMessageGroupsCoreProducerCoreConsumer() throws Exception {
        this.testMessageGroups(this.CoreConnection, this.CoreConnection);
    }

    @Test
    @Timeout(value=60L)
    public void testMessageGroupsCoreProducerAMQPConsumer() throws Exception {
        this.testMessageGroups(this.CoreConnection, this.AMQPConnection);
    }

    @Test
    @Timeout(value=60L)
    public void testMessageGroupsAMQPProducerCoreConsumer() throws Exception {
        this.testMessageGroups(this.AMQPConnection, this.CoreConnection);
    }

    @Test
    @Timeout(value=60L)
    public void testMessageGroupsOpenWireProducerOpenWireConsumer() throws Exception {
        this.testMessageGroups(this.OpenWireConnection, this.OpenWireConnection);
    }

    @Test
    @Timeout(value=60L)
    public void testMessageGroupsCoreProducerOpenWireConsumer() throws Exception {
        this.testMessageGroups(this.CoreConnection, this.OpenWireConnection);
    }

    @Test
    @Timeout(value=60L)
    public void testMessageGroupsOpenWireProducerCoreConsumer() throws Exception {
        this.testMessageGroups(this.OpenWireConnection, this.CoreConnection);
    }

    @Test
    @Timeout(value=60L)
    public void testMessageGroupsAMQPProducerOpenWireConsumer() throws Exception {
        this.testMessageGroups(this.AMQPConnection, this.OpenWireConnection);
    }

    @Test
    @Timeout(value=60L)
    public void testMessageGroupsOpenWireProducerAMQPConsumer() throws Exception {
        this.testMessageGroups(this.OpenWireConnection, this.AMQPConnection);
    }

    public void testMessageGroups(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.testGroupSeqIsNeverLost(producerConnectionSupplier, consumerConnectionSupplier);
        this.testGroupSeqCloseGroup(producerConnectionSupplier, consumerConnectionSupplier);
        this.testGroupFirst(producerConnectionSupplier, consumerConnectionSupplier);
        this.testGroupFirstDefaultOff(producerConnectionSupplier, consumerConnectionSupplier);
    }

    public void testGroupSeqCloseGroup(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.of((String)this.getQueueName()));
        try (Connection producerConnection = producerConnectionSupplier.createConnection();
             Session producerSession = producerConnection.createSession(false, 1);
             MessageProducer producer = producerSession.createProducer((Destination)producerSession.createQueue(this.getQueueName()));
             Connection consumerConnection = producerConnectionSupplier.createConnection();
             Session consumerSession = consumerConnection.createSession(false, 1);
             MessageConsumer consumer1 = consumerSession.createConsumer((Destination)consumerSession.createQueue(this.getQueueName()));
             MessageConsumer consumer2 = consumerSession.createConsumer((Destination)consumerSession.createQueue(this.getQueueName()));
             MessageConsumer consumer3 = consumerSession.createConsumer((Destination)consumerSession.createQueue(this.getQueueName()));){
            producerConnection.start();
            consumerConnection.start();
            this.sendAndConsumeAndThenCloseGroup(producerSession, producer, consumer1, consumer2, consumer3, queueBinding);
            this.sendAndConsumeAndThenCloseGroup(producerSession, producer, consumer2, consumer3, consumer1, queueBinding);
            this.sendAndConsumeAndThenCloseGroup(producerSession, producer, consumer3, consumer1, consumer1, queueBinding);
        }
    }

    private void sendAndConsumeAndThenCloseGroup(Session producerSession, MessageProducer producer, MessageConsumer expectedGroupConsumer, MessageConsumer consumerA, MessageConsumer consumerB, QueueBinding queueBinding) throws JMSException {
        int j;
        for (j = 1; j <= 10; ++j) {
            TextMessage message = producerSession.createTextMessage();
            message.setStringProperty("JMSXGroupID", JMSX_GROUP_ID);
            message.setIntProperty("JMSXGroupSeq", j);
            message.setText("Message" + j);
            producer.send((Message)message);
        }
        for (j = 1; j <= 10; ++j) {
            TextMessage tm = (TextMessage)expectedGroupConsumer.receive(1000L);
            Assertions.assertNotNull((Object)tm);
            Assertions.assertEquals((Object)JMSX_GROUP_ID, (Object)tm.getStringProperty("JMSXGroupID"));
            Assertions.assertEquals((int)j, (int)tm.getIntProperty("JMSXGroupSeq"));
            Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
            Assertions.assertNull((Object)consumerA.receiveNoWait());
            Assertions.assertNull((Object)consumerB.receiveNoWait());
        }
        Assertions.assertEquals((int)1, (int)queueBinding.getQueue().getGroupCount());
        TextMessage message = producerSession.createTextMessage();
        message.setStringProperty("JMSXGroupID", JMSX_GROUP_ID);
        message.setIntProperty("JMSXGroupSeq", -1);
        message.setText("Message group close");
        producer.send((Message)message);
        TextMessage receivedGroupCloseMessage = (TextMessage)expectedGroupConsumer.receive(1000L);
        Assertions.assertNotNull((Object)receivedGroupCloseMessage);
        Assertions.assertEquals((Object)JMSX_GROUP_ID, (Object)receivedGroupCloseMessage.getStringProperty("JMSXGroupID"));
        Assertions.assertEquals((int)-1, (int)receivedGroupCloseMessage.getIntProperty("JMSXGroupSeq"));
        Assertions.assertEquals((Object)"Message group close", (Object)receivedGroupCloseMessage.getText(), (String)"group close should goto the existing group consumer");
        Assertions.assertNull((Object)consumerA.receiveNoWait());
        Assertions.assertNull((Object)consumerB.receiveNoWait());
        Assertions.assertEquals((int)0, (int)queueBinding.getQueue().getGroupCount());
    }

    public void testGroupSeqIsNeverLost(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        AtomicInteger sequenceCounter = new AtomicInteger();
        AtomicInteger consumedSequenceCounter = new AtomicInteger();
        String queueName = this.getQueueName();
        for (int i = 0; i < 10; ++i) {
            try (Connection producerConnection = producerConnectionSupplier.createConnection();
                 Connection consumerConnection = consumerConnectionSupplier.createConnection();){
                this.sendMessagesToBroker(queueName, producerConnection, 10, sequenceCounter);
                this.readMessagesOnBroker(queueName, consumerConnection, 10, consumedSequenceCounter, null);
                continue;
            }
        }
    }

    public void testGroupFirst(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        AtomicInteger sequenceCounter = new AtomicInteger();
        AtomicInteger consumedSequenceCounter = new AtomicInteger();
        String queueName = "GroupFirst." + this.getQueueName();
        for (int i = 0; i < 10; ++i) {
            try (Connection producerConnection = producerConnectionSupplier.createConnection();
                 Connection consumerConnection = consumerConnectionSupplier.createConnection();){
                this.sendMessagesToBroker(queueName, producerConnection, 10, sequenceCounter);
                this.readMessagesOnBroker(queueName, consumerConnection, 10, consumedSequenceCounter, this::groupFirstCheck);
                continue;
            }
        }
    }

    private void groupFirstCheck(int i, Message message) {
        try {
            if (i == 0) {
                Assertions.assertTrue((boolean)message.getBooleanProperty("JMSXFirstInGroupID"), (String)"Message should be marked with first in Group");
            } else {
                Assertions.assertFalse((boolean)message.propertyExists("JMSXFirstInGroupID"), (String)"Message should NOT be marked with first in Group");
            }
        }
        catch (JMSException e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    public void testGroupFirstDefaultOff(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        AtomicInteger sequenceCounter = new AtomicInteger();
        AtomicInteger consumedSequenceCounter = new AtomicInteger();
        String queueName = this.getQueueName();
        for (int i = 0; i < 10; ++i) {
            try (Connection producerConnection = producerConnectionSupplier.createConnection();
                 Connection consumerConnection = consumerConnectionSupplier.createConnection();){
                this.sendMessagesToBroker(queueName, producerConnection, 10, sequenceCounter);
                this.readMessagesOnBroker(queueName, consumerConnection, 10, consumedSequenceCounter, this::groupFirstOffCheck);
                continue;
            }
        }
    }

    private void groupFirstOffCheck(int i, Message message) {
        try {
            Assertions.assertFalse((boolean)message.propertyExists("JMSXFirstInGroupID"), (String)"Message should NOT be marked with first in Group");
        }
        catch (JMSException e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    protected void readMessagesOnBroker(String queueName, Connection connection, int count, AtomicInteger sequence, BiConsumer<Integer, Message> additionalCheck) throws Exception {
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue(queueName);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        for (int i = 0; i < 10; ++i) {
            Message message = consumer.receive(1000L);
            Assertions.assertNotNull((Object)message);
            logger.debug("Read message #{}: type = {}", (Object)i, (Object)message.getClass().getSimpleName());
            String gid = message.getStringProperty("JMSXGroupID");
            int seq = message.getIntProperty("JMSXGroupSeq");
            logger.debug("Message assigned JMSXGroupID := {}", (Object)gid);
            logger.debug("Message assigned JMSXGroupSeq := {}", (Object)seq);
            Assertions.assertEquals((int)sequence.incrementAndGet(), (int)seq, (String)"Sequence order should match");
            if (additionalCheck == null) continue;
            additionalCheck.accept(i, message);
        }
        session.close();
    }

    protected void sendMessagesToBroker(String queueName, Connection connection, int count, AtomicInteger sequence) throws Exception {
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue(queueName);
        MessageProducer producer = session.createProducer((Destination)queue);
        byte[] buffer = new byte[10240];
        for (count = 0; count < 10240; ++count) {
            String s = String.valueOf(count % 10);
            Character c = Character.valueOf(s.charAt(0));
            char value = c.charValue();
            buffer[count] = (byte)value;
        }
        logger.debug("Sending {} messages to destination: {}", (Object)10, (Object)queue);
        for (int i = 1; i <= 10; ++i) {
            BytesMessage message = session.createBytesMessage();
            message.setJMSDeliveryMode(2);
            message.setStringProperty("JMSXGroupID", JMSX_GROUP_ID);
            message.setIntProperty("JMSXGroupSeq", sequence.incrementAndGet());
            message.writeBytes(buffer);
            producer.send((Message)message);
        }
        session.close();
    }
}

