/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.multiprotocol;

import jakarta.jms.Connection;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.jms.multiprotocol.MultiprotocolJMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class JMSNotificationTest
extends MultiprotocolJMSClientTestSupport {
    private ClientConsumer notificationConsumer;
    private String clientID;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.clientID = RandomUtil.randomString();
        ServerLocator locator = this.addServerLocator(this.createInVMNonHALocator());
        ClientSessionFactory sf = this.addSessionFactory(locator.createSessionFactory());
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        session.start();
        SimpleString notificationQueue = RandomUtil.randomSimpleString();
        session.createQueue(QueueConfiguration.of((SimpleString)notificationQueue).setAddress(ActiveMQDefaultConfiguration.getDefaultManagementNotificationAddress()).setDurable(Boolean.valueOf(false)));
        this.notificationConsumer = this.addClientConsumer(session.createConsumer(notificationQueue));
    }

    private void flush() throws ActiveMQException {
        ClientMessage message;
        while ((message = this.notificationConsumer.receiveImmediate()) != null) {
        }
    }

    @Override
    protected void addConfiguration(ActiveMQServer server) throws Exception {
        server.getConfiguration().addAcceptorConfiguration("invm", "vm://0");
    }

    @Test
    @Timeout(value=30L)
    public void testConsumerNotificationAMQP() throws Exception {
        this.testConsumerNotifications(this.createConnection(this.getBrokerQpidJMSConnectionURI(), null, null, this.clientID, true));
    }

    @Test
    @Timeout(value=30L)
    public void testConsumerNotificationCore() throws Exception {
        this.testConsumerNotifications(this.createCoreConnection(this.getBrokerCoreJMSConnectionString(), null, null, this.clientID, true));
    }

    @Test
    @Timeout(value=30L)
    public void testConsumerNotificationOpenWire() throws Exception {
        this.testConsumerNotifications(this.createOpenWireConnection(this.getBrokerOpenWireJMSConnectionString(), null, null, this.clientID, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConsumerNotifications(Connection connection) throws Exception {
        String subscriptionName = "mySub";
        try {
            this.flush();
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            this.flush();
            TopicSubscriber consumer = session.createDurableSubscriber(topic, "mySub");
            ClientMessage m = this.receiveNotification(CoreNotificationType.CONSUMER_CREATED, this.notificationConsumer);
            this.validateClientIdOnNotification((Message)m, CoreNotificationType.CONSUMER_CREATED);
            String consumerID = this.validatePropertyOnNotification((Message)m, CoreNotificationType.CONSUMER_CREATED, ManagementHelper.HDR_CONSUMER_NAME, null, false);
            consumer.close();
            m = this.receiveNotification(CoreNotificationType.CONSUMER_CLOSED, this.notificationConsumer);
            this.validateClientIdOnNotification((Message)m, CoreNotificationType.CONSUMER_CLOSED);
            this.validatePropertyOnNotification((Message)m, CoreNotificationType.CONSUMER_CLOSED, ManagementHelper.HDR_CONSUMER_NAME, consumerID, true);
            session.unsubscribe("mySub");
        }
        finally {
            connection.close();
        }
    }

    ClientMessage receiveNotification(CoreNotificationType notificationType, ClientConsumer consumer) throws Exception {
        ClientMessage message;
        String receivedType;
        do {
            if ((message = consumer.receive(1000L)) != null) continue;
            return null;
        } while (!String.valueOf(receivedType = message.getStringProperty(ManagementHelper.HDR_NOTIFICATION_TYPE)).equals(notificationType.toString()));
        return message;
    }

    @Test
    @Timeout(value=30L)
    public void testSessionNotificationAMQP() throws Exception {
        this.testSessionNotification(this.createConnection(this.getBrokerQpidJMSConnectionURI(), null, null, this.clientID, true));
    }

    @Test
    @Timeout(value=30L)
    public void testSessionNotificationCore() throws Exception {
        this.testSessionNotification(this.createCoreConnection(this.getBrokerCoreJMSConnectionString(), null, null, this.clientID, true));
    }

    @Test
    @Timeout(value=30L)
    public void testSessionNotificationOpenWire() throws Exception {
        this.testSessionNotification(this.createOpenWireConnection(this.getBrokerOpenWireJMSConnectionString(), null, null, this.clientID, true));
    }

    private void testSessionNotification(Connection connection) throws Exception {
        try {
            this.flush();
            Session session = connection.createSession(false, 1);
            this.validateClientIdOnNotification((Message)this.notificationConsumer.receive(1000L), CoreNotificationType.SESSION_CREATED);
            session.close();
            this.validateClientIdOnNotification((Message)this.notificationConsumer.receive(1000L), CoreNotificationType.SESSION_CLOSED);
        }
        finally {
            connection.close();
        }
    }

    private void validateClientIdOnNotification(Message m, CoreNotificationType notificationType) {
        this.validatePropertyOnNotification(m, notificationType, ManagementHelper.HDR_CLIENT_ID, this.clientID, true);
    }

    private String validatePropertyOnNotification(Message m, CoreNotificationType notificationType, SimpleString propertyName, String propertyValue, boolean checkValue) {
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)notificationType.toString(), (Object)m.getStringProperty(ManagementHelper.HDR_NOTIFICATION_TYPE));
        Assertions.assertTrue((boolean)m.getPropertyNames().contains(propertyName));
        if (checkValue) {
            Assertions.assertEquals((Object)propertyValue, (Object)m.getStringProperty(propertyName));
        }
        return m.getStringProperty(propertyName);
    }
}

