/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5.spec;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.utils.Wait;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class SubscriptionTests
extends MQTT5TestSupport {
    @Test
    @Timeout(value=60L)
    public void testSharedSubscriptionRespectQoS() throws Exception {
        String TOPIC = "myTopic";
        String SUB_NAME = "myShare";
        String SHARED_SUB = "$share/myShare/myTopic";
        int MESSAGE_COUNT = 100;
        final AtomicInteger consumer1MessagesReceived = new AtomicInteger(0);
        final AtomicInteger consumer2MessagesReceived = new AtomicInteger(0);
        MqttClient consumer1 = this.createPahoClient("consumer1");
        consumer1.connect();
        consumer1.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String incomingTopic, MqttMessage message) throws Exception {
                if (message.getQos() == 0) {
                    consumer1MessagesReceived.incrementAndGet();
                } else {
                    Assertions.fail((String)("Wrong QoS for consumer 1: " + message.getId() + " " + message.getQos()));
                }
            }
        });
        consumer1.subscribe("$share/myShare/myTopic", 0);
        Queue sharedSubQueue = this.server.locateQueue("myShare".concat(".").concat("myTopic"));
        Assertions.assertNotNull((Object)sharedSubQueue);
        Assertions.assertEquals((Object)"myTopic", (Object)sharedSubQueue.getAddress().toString());
        MqttClient consumer2 = this.createPahoClient("consumer2");
        consumer2.connect();
        consumer2.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String incomingTopic, MqttMessage message) throws Exception {
                if (message.getQos() == 1) {
                    consumer2MessagesReceived.incrementAndGet();
                } else {
                    Assertions.fail((String)("Wrong QoS for consumer 2: " + message.getId() + " " + message.getQos()));
                }
            }
        });
        consumer2.subscribe("$share/myShare/myTopic", 1);
        Assertions.assertEquals((int)2, (int)sharedSubQueue.getConsumerCount());
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        for (int i = 0; i < 100; ++i) {
            producer.publish("myTopic", new byte[0], 1, false);
        }
        producer.disconnect();
        producer.close();
        Wait.assertTrue(() -> consumer1MessagesReceived.get() > 0, (long)2000L, (long)100L);
        Wait.assertTrue(() -> consumer2MessagesReceived.get() > 0, (long)2000L, (long)100L);
        Wait.assertEquals((int)100, () -> consumer1MessagesReceived.get() + consumer2MessagesReceived.get(), (long)2000L, (long)100L);
        consumer1.disconnect();
        consumer1.close();
        consumer2.disconnect();
        consumer2.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSharedSubscriptionWithAck() throws Exception {
        String TOPIC = "myTopic";
        String SUB_NAME = "myShare";
        String SHARED_SUB = "$share/myShare/myTopic";
        CountDownLatch ackLatch = new CountDownLatch(1);
        CountDownLatch negativeAckLatch = new CountDownLatch(1);
        MqttClient consumer1 = this.createPahoClient("consumer1");
        consumer1.connect();
        consumer1.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, ackLatch));
        consumer1.subscribe("$share/myShare/myTopic", 1);
        Queue sharedSubQueue = this.server.locateQueue("myShare".concat(".").concat("myTopic"));
        Assertions.assertNotNull((Object)sharedSubQueue);
        Assertions.assertEquals((Object)"myTopic", (Object)sharedSubQueue.getAddress().toString());
        Assertions.assertEquals((int)1, (int)sharedSubQueue.getConsumerCount());
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish("myTopic", new byte[0], 1, false);
        producer.disconnect();
        producer.close();
        MqttClient consumer2 = this.createPahoClient("consumer2");
        consumer2.connect();
        consumer2.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, negativeAckLatch));
        consumer2.subscribe("$share/myShare/myTopic", 1);
        Assertions.assertTrue((boolean)ackLatch.await(2L, TimeUnit.SECONDS));
        Assertions.assertFalse((boolean)negativeAckLatch.await(2L, TimeUnit.SECONDS));
        consumer1.disconnect();
        consumer1.close();
        consumer2.disconnect();
        consumer2.close();
    }
}

