/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5.websocket;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class BasicWebSocketTests
extends MQTT5TestSupport {
    @Test
    @Timeout(value=60L)
    public void testSimpleSendReceive() throws Exception {
        String topic = RandomUtil.randomString();
        final byte[] body = RandomUtil.randomBytes((int)32);
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient subscriber = this.createPahoClient("ws", "subscriber");
        subscriber.connect();
        subscriber.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) {
                ActiveMQTestBase.assertEqualsByteArrays(body, message.getPayload());
                latch.countDown();
            }
        });
        subscriber.subscribe(topic, 1);
        MqttClient producer = this.createPahoClient("ws", "producer");
        producer.connect();
        producer.publish(topic, body, 1, false);
        Assertions.assertTrue((boolean)latch.await(500L, TimeUnit.MILLISECONDS));
    }
}

