/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.File;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.cli.commands.tools.PrintData;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.openwire.OpenWireTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.failover.FailoverTransport;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefetchRedeliveryCountOpenwireTest
extends OpenWireTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.realStore = true;
        super.setUp();
    }

    @Override
    protected void configureAddressSettings(Map<String, AddressSettings> addressSettingsMap) {
        super.configureAddressSettings(addressSettingsMap);
        addressSettingsMap.put("exampleQueue", new AddressSettings().setAutoCreateQueues(Boolean.valueOf(false)).setAutoCreateAddresses(Boolean.valueOf(false)).setDeadLetterAddress(SimpleString.of((String)"ActiveMQ.DLQ")).setAutoCreateAddresses(Boolean.valueOf(true)).setMaxDeliveryAttempts(2));
        addressSettingsMap.put("exampleQueueTwo", new AddressSettings().setAutoCreateQueues(Boolean.valueOf(false)).setAutoCreateAddresses(Boolean.valueOf(false)).setDeadLetterAddress(SimpleString.of((String)"ActiveMQ.DLQ")).setAutoCreateAddresses(Boolean.valueOf(true)).setMaxDeliveryAttempts(-1));
    }

    @Override
    protected void extraServerConfig(Configuration serverConfig) {
    }

    @Test
    @Timeout(value=60L)
    public void testConsumerSingleMessageLoopExclusive() throws Exception {
        this.doTestConsumerSingleMessageLoop(true);
    }

    @Test
    @Timeout(value=60L)
    public void testConsumerSingleMessageLoopNonExclusive() throws Exception {
        this.doTestConsumerSingleMessageLoop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestConsumerSingleMessageLoop(boolean exclusive) throws Exception {
        Connection exConn = null;
        SimpleString durableQueue = SimpleString.of((String)"exampleQueue");
        this.server.createQueue(QueueConfiguration.of((SimpleString)durableQueue).setRoutingType(RoutingType.ANYCAST).setExclusive(Boolean.valueOf(exclusive)));
        try {
            int i;
            ActiveMQConnectionFactory exFact = new ActiveMQConnectionFactory();
            exFact.setWatchTopicAdvisories(false);
            ActiveMQQueue queue = new ActiveMQQueue("exampleQueue");
            exConn = exFact.createConnection();
            exConn.start();
            Session session = exConn.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage message = session.createTextMessage("This is a text message");
            int numMessages = 20;
            for (i = 0; i < numMessages; ++i) {
                producer.send((Message)message);
            }
            for (i = 0; i < numMessages; ++i) {
                MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
                TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
                Assertions.assertNotNull((Object)messageReceived);
                Assertions.assertEquals((Object)"This is a text message", (Object)messageReceived.getText());
                messageConsumer.close();
            }
        }
        finally {
            if (exConn != null) {
                exConn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testExclusiveConsumerOrderOnReconnectionLargePrefetch() throws Exception {
        Connection exConn = null;
        SimpleString durableQueue = SimpleString.of((String)"exampleQueueTwo");
        this.server.createQueue(QueueConfiguration.of((SimpleString)durableQueue).setRoutingType(RoutingType.ANYCAST).setExclusive(Boolean.valueOf(true)));
        try {
            ActiveMQConnectionFactory exFact = new ActiveMQConnectionFactory();
            exFact.setWatchTopicAdvisories(false);
            ActiveMQPrefetchPolicy prefetchPastMaxDeliveriesInLoop = new ActiveMQPrefetchPolicy();
            prefetchPastMaxDeliveriesInLoop.setAll(2000);
            exFact.setPrefetchPolicy(prefetchPastMaxDeliveriesInLoop);
            RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
            redeliveryPolicy.setMaximumRedeliveries(4000);
            exFact.setRedeliveryPolicy(redeliveryPolicy);
            ActiveMQQueue queue = new ActiveMQQueue("exampleQueueTwo");
            exConn = exFact.createConnection();
            exConn.start();
            Session session = exConn.createSession(true, 1);
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage message = session.createTextMessage("This is a text message");
            int numMessages = 10000;
            for (int i = 0; i < numMessages; ++i) {
                message.setIntProperty("SEQ", i);
                producer.send((Message)message);
            }
            session.commit();
            exConn.close();
            int batch = 200;
            for (int i = 0; i < numMessages; i += 200) {
                exConn = exFact.createConnection();
                exConn.start();
                session = exConn.createSession(true, 0);
                MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
                for (int j = 0; j < 200; ++j) {
                    TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
                    Assertions.assertNotNull((Object)messageReceived, (String)("null @ i=" + i));
                    Assertions.assertEquals((int)(i + j), (int)messageReceived.getIntProperty("SEQ"));
                    Assertions.assertEquals((Object)"This is a text message", (Object)messageReceived.getText());
                }
                session.commit();
                ((FailoverTransport)((ActiveMQConnection)exConn).getTransport().narrow(FailoverTransport.class)).stop();
                exConn.close();
            }
        }
        finally {
            if (exConn != null) {
                exConn.close();
            }
        }
    }

    @Test
    @Timeout(value=60L)
    public void testServerSideRollbackOnCloseOrder() throws Exception {
        ArrayList errors = new ArrayList();
        SimpleString durableQueue = SimpleString.of((String)"exampleQueueTwo");
        this.server.createQueue(QueueConfiguration.of((SimpleString)durableQueue).setRoutingType(RoutingType.ANYCAST).setExclusive(Boolean.valueOf(true)));
        ActiveMQQueue queue = new ActiveMQQueue(durableQueue.toString());
        ActiveMQConnectionFactory exFact = new ActiveMQConnectionFactory("failover:(tcp://localhost:61616?closeAsync=false)?startupMaxReconnectAttempts=10&maxReconnectAttempts=0&timeout=1000");
        exFact.setWatchTopicAdvisories(false);
        exFact.setConnectResponseTimeout(10000);
        ActiveMQPrefetchPolicy prefetchPastMaxDeliveriesInLoop = new ActiveMQPrefetchPolicy();
        prefetchPastMaxDeliveriesInLoop.setAll(2000);
        exFact.setPrefetchPolicy(prefetchPastMaxDeliveriesInLoop);
        RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
        redeliveryPolicy.setRedeliveryDelay(0L);
        redeliveryPolicy.setMaximumRedeliveries(-1);
        exFact.setRedeliveryPolicy(redeliveryPolicy);
        Connection exConn = exFact.createConnection();
        exConn.start();
        Session session = exConn.createSession(true, 1);
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage message = session.createTextMessage("This is a text message");
        int numMessages = 1000;
        for (int i = 0; i < numMessages; ++i) {
            message.setIntProperty("SEQ", i);
            producer.send((Message)message);
        }
        session.commit();
        exConn.close();
        int numConsumers = 2;
        ExecutorService executorService = Executors.newCachedThreadPool();
        int numLoadProducers = 2;
        this.underLoad(2, () -> PrefetchRedeliveryCountOpenwireTest.lambda$testServerSideRollbackOnCloseOrder$1(numMessages, exFact, (Queue)queue, errors, executorService));
        Assertions.assertTrue((boolean)errors.isEmpty());
    }

    @Test
    @Timeout(value=60L)
    public void testExclusiveConsumerBatchOrderUnderLoad() throws Exception {
        ArrayList errors = new ArrayList();
        SimpleString durableQueue = SimpleString.of((String)"exampleQueueTwo");
        this.server.createQueue(QueueConfiguration.of((SimpleString)durableQueue).setRoutingType(RoutingType.ANYCAST).setExclusive(Boolean.valueOf(true)));
        ActiveMQQueue queue = new ActiveMQQueue(durableQueue.toString());
        ActiveMQConnectionFactory exFact = new ActiveMQConnectionFactory("failover:(tcp://localhost:61616?closeAsync=false)?startupMaxReconnectAttempts=10&maxReconnectAttempts=0&timeout=1000");
        exFact.setWatchTopicAdvisories(false);
        exFact.setConnectResponseTimeout(10000);
        ActiveMQPrefetchPolicy prefetchPastMaxDeliveriesInLoop = new ActiveMQPrefetchPolicy();
        prefetchPastMaxDeliveriesInLoop.setAll(2000);
        exFact.setPrefetchPolicy(prefetchPastMaxDeliveriesInLoop);
        RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
        redeliveryPolicy.setRedeliveryDelay(0L);
        redeliveryPolicy.setMaximumRedeliveries(-1);
        exFact.setRedeliveryPolicy(redeliveryPolicy);
        Connection exConn = exFact.createConnection();
        exConn.start();
        Session session = exConn.createSession(true, 1);
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage message = session.createTextMessage("This is a text message");
        int numMessages = 10000;
        for (int i = 0; i < numMessages; ++i) {
            message.setIntProperty("SEQ", i);
            producer.send((Message)message);
        }
        session.commit();
        exConn.close();
        int numConsumers = 4;
        ExecutorService executorService = Executors.newCachedThreadPool();
        int numLoadProducers = 4;
        this.underLoad(4, () -> this.lambda$testExclusiveConsumerBatchOrderUnderLoad$5(durableQueue, exFact, (Queue)queue, errors, executorService));
        Assertions.assertTrue((boolean)errors.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void underLoad(int numProducers, Runnable r) throws Exception {
        Queue queue;
        org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory cf;
        org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory connectionFactory;
        SimpleString durableQueue = SimpleString.of((String)"exampleQueue");
        this.server.createQueue(QueueConfiguration.of((SimpleString)durableQueue).setRoutingType(RoutingType.ANYCAST));
        ExecutorService executor = Executors.newFixedThreadPool(numProducers + 1);
        boolean useCoreForLoad = true;
        if (useCoreForLoad) {
            connectionFactory = new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory();
            connectionFactory.setConfirmationWindowSize(1000000);
            connectionFactory.setBlockOnDurableSend(true);
            connectionFactory.setBlockOnNonDurableSend(true);
            cf = connectionFactory;
            queue = connectionFactory.createContext().createQueue(durableQueue.toString());
        } else {
            connectionFactory = new ActiveMQConnectionFactory("failover:(tcp://localhost:61616)?startupMaxReconnectAttempts=0&maxReconnectAttempts=0&timeout=1000");
            connectionFactory.setWatchTopicAdvisories(false);
            connectionFactory.setCloseTimeout(1);
            connectionFactory.setSendTimeout(2000);
            cf = connectionFactory;
            queue = new ActiveMQQueue(durableQueue.toString());
        }
        Queue destination = queue;
        org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory connectionFactory2 = cf;
        AtomicBoolean done = new AtomicBoolean();
        Runnable producerTask = () -> PrefetchRedeliveryCountOpenwireTest.lambda$underLoad$6((ConnectionFactory)connectionFactory2, destination, done);
        for (int i = 0; i < numProducers; ++i) {
            executor.submit(producerTask);
        }
        executor.submit(() -> PrefetchRedeliveryCountOpenwireTest.lambda$underLoad$7((ConnectionFactory)connectionFactory2, destination, done));
        try {
            r.run();
        }
        finally {
            done.set(true);
            executor.shutdown();
            if (!executor.awaitTermination(30L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
            logger.info("LOAD ADDED: " + this.server.locateQueue(durableQueue).getMessagesAdded());
        }
    }

    @Test
    @Timeout(value=120L)
    public void testExclusiveConsumerTransactionalBatchOnReconnectionLargePrefetch() throws Exception {
        this.doTestExclusiveConsumerTransactionalBatchOnReconnectionLargePrefetch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestExclusiveConsumerTransactionalBatchOnReconnectionLargePrefetch() throws Exception {
        Connection exConn = null;
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        SimpleString durableQueue = SimpleString.of((String)"exampleQueueTwo");
        this.server.createQueue(QueueConfiguration.of((SimpleString)durableQueue).setRoutingType(RoutingType.ANYCAST).setExclusive(Boolean.valueOf(true)));
        AtomicInteger batchConsumed = new AtomicInteger(0);
        try {
            ActiveMQConnectionFactory exFact = new ActiveMQConnectionFactory();
            exFact.setWatchTopicAdvisories(false);
            RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
            redeliveryPolicy.setMaximumRedeliveries(4000);
            exFact.setRedeliveryPolicy(redeliveryPolicy);
            ActiveMQQueue queue = new ActiveMQQueue("exampleQueueTwo");
            exConn = exFact.createConnection();
            exConn.start();
            Session session = exConn.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage message = session.createTextMessage("This is a text message");
            int numMessages = 1000;
            for (int i = 0; i < numMessages; ++i) {
                message.setIntProperty("SEQ", i);
                producer.send((Message)message);
            }
            session.close();
            exConn.close();
            int batch = 200;
            AtomicBoolean done = new AtomicBoolean(false);
            while (!done.get()) {
                exConn = exFact.createConnection();
                ((ActiveMQConnection)exConn).setCloseTimeout(1);
                exConn.start();
                session = exConn.createSession(true, 0);
                MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
                int received = 0;
                for (int j = 0; j < 200; ++j) {
                    TextMessage messageReceived = (TextMessage)messageConsumer.receive(2000L);
                    if (messageReceived == null) {
                        done.set(true);
                        break;
                    }
                    batchConsumed.incrementAndGet();
                    Assertions.assertEquals((Object)"This is a text message", (Object)messageReceived.getText());
                    int receivedSeq = messageReceived.getIntProperty("SEQ");
                    Assertions.assertEquals((int)(200 * (receivedSeq / 200) + j), (int)receivedSeq, (String)("@:" + ++received + ", out of order"));
                }
                CountDownLatch latch = new CountDownLatch(1);
                Session finalSession = session;
                executorService.submit(() -> {
                    try {
                        latch.countDown();
                        finalSession.commit();
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                });
                latch.await(1L, TimeUnit.SECONDS);
                ((FailoverTransport)((ActiveMQConnection)exConn).getTransport().narrow(FailoverTransport.class)).stop();
                Connection finalConToClose = exConn;
                executorService.submit(() -> {
                    try {
                        finalConToClose.close();
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                });
            }
        }
        finally {
            if (exConn != null) {
                exConn.close();
            }
            executorService.shutdownNow();
        }
        logger.info("Done after: {}, queue: {}", (Object)batchConsumed.get(), (Object)this.server.locateQueue(durableQueue));
        try {
            Wait.assertEquals((long)0L, () -> this.server.locateQueue(durableQueue).getDeliveringCount(), (long)1000L);
        }
        catch (Throwable e) {
            final AtomicBoolean doOut = new AtomicBoolean(false);
            PrintStream out = new PrintStream(System.out){

                @Override
                public void println(String s) {
                    if (doOut.get()) {
                        super.println(s);
                    } else if (s.startsWith("### Failed Transactions")) {
                        doOut.set(true);
                        super.println(s);
                    }
                }
            };
            PrintData.printData((File)this.server.getConfiguration().getBindingsLocation(), (File)this.server.getConfiguration().getJournalLocation(), (File)this.server.getConfiguration().getPagingLocation(), (PrintStream)out, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (int)-1);
            throw e;
        }
    }

    private static /* synthetic */ void lambda$underLoad$7(ConnectionFactory connectionFactory, Queue destination, AtomicBoolean done) {
        try (Connection exConn = connectionFactory.createConnection();){
            exConn.start();
            Session session = exConn.createSession(false, 1);
            MessageConsumer messageConsumer = session.createConsumer((Destination)destination);
            while (!done.get()) {
                messageConsumer.receive(200L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void lambda$underLoad$6(ConnectionFactory connectionFactory, Queue destination, AtomicBoolean done) {
        try (Connection exConn = connectionFactory.createConnection();){
            exConn.start();
            Session session = exConn.createSession(true, 0);
            MessageProducer producer = session.createProducer((Destination)destination);
            TextMessage message = session.createTextMessage("This is a text message");
            int count = 1;
            while (!done.get()) {
                producer.send((Message)message);
                if (count++ % 100 != 0) continue;
                session.commit();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$testExclusiveConsumerBatchOrderUnderLoad$5(SimpleString durableQueue, ActiveMQConnectionFactory exFact, Queue queue, ArrayList errors, ExecutorService executorService) {
        AtomicBoolean done = new AtomicBoolean(false);
        AtomicInteger receivedCount = new AtomicInteger();
        AtomicInteger inProgressBatch = new AtomicInteger();
        int batch = 200;
        ExecutorService commitExecutor = Executors.newCachedThreadPool();
        Runnable consumerTask = () -> {
            Connection toCloseOnError = null;
            while (!done.get() && this.server.locateQueue(durableQueue).getMessageCount() > 0L) {
                try {
                    Connection consumerConnection = exFact.createConnection();
                    try {
                        TextMessage messageReceived;
                        int i;
                        toCloseOnError = consumerConnection;
                        ((ActiveMQConnection)consumerConnection).setCloseTimeout(1);
                        consumerConnection.start();
                        Session consumerConnectionSession = consumerConnection.createSession(true, 0);
                        MessageConsumer messageConsumer = consumerConnectionSession.createConsumer((Destination)queue);
                        for (i = 0; i < 200 && (messageReceived = (TextMessage)messageConsumer.receive(2000L)) != null; ++i) {
                            receivedCount.incrementAndGet();
                            int receivedSeq = messageReceived.getIntProperty("SEQ");
                            int currentBatch = receivedSeq / 200;
                            if (i == 0 && inProgressBatch.get() != currentBatch) {
                                if (inProgressBatch.get() + 1 != currentBatch) {
                                    done.set(true);
                                    throw new AssertionError((Object)("@:" + receivedCount.get() + ", batch out of sequence, expected: " + (inProgressBatch.get() + 1) + ", but have: " + currentBatch + " @" + receivedSeq + ", Message: " + messageReceived));
                                }
                                inProgressBatch.incrementAndGet();
                                logger.info("@:" + receivedCount.get() + ", current batch increment to: " + inProgressBatch.get() + ", Received Seq: " + receivedSeq + ", Message: " + messageReceived);
                            }
                            Assertions.assertEquals((long)(200L * (long)inProgressBatch.get() + (long)i), (long)receivedSeq, (String)("@:" + receivedCount.get() + " batch out of order"));
                        }
                        if (i != 200) continue;
                        CountDownLatch latch = new CountDownLatch(1);
                        Session finalSession = consumerConnectionSession;
                        commitExecutor.submit(() -> {
                            try {
                                latch.countDown();
                                finalSession.commit();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        });
                        latch.await(1L, TimeUnit.SECONDS);
                        TimeUnit.MILLISECONDS.sleep(15L);
                        try {
                            ((TcpTransport)((ActiveMQConnection)consumerConnection).getTransport().narrow(TcpTransport.class)).stop();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    finally {
                        if (consumerConnection == null) continue;
                        consumerConnection.close();
                    }
                }
                catch (InterruptedException | NullPointerException | ConcurrentModificationException consumerConnection) {
                }
                catch (JMSException consumerConnection) {
                }
                catch (Throwable unexpected) {
                    unexpected.printStackTrace();
                    errors.add(unexpected);
                    done.set(true);
                }
                finally {
                    if (toCloseOnError == null) continue;
                    try {
                        toCloseOnError.close();
                    }
                    catch (Throwable receivedSeq) {}
                }
            }
        };
        for (int i = 0; i < 4; ++i) {
            executorService.submit(consumerTask);
        }
        executorService.shutdown();
        try {
            Wait.assertEquals((long)0L, () -> {
                if (!errors.isEmpty()) {
                    return -1L;
                }
                return this.server.locateQueue(durableQueue).getMessageCount();
            }, (long)30000L);
        }
        catch (Throwable t) {
            errors.add(t);
        }
        finally {
            done.set(true);
            commitExecutor.shutdownNow();
            executorService.shutdownNow();
        }
        Assertions.assertTrue((boolean)errors.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$testServerSideRollbackOnCloseOrder$1(int numMessages, ActiveMQConnectionFactory exFact, Queue queue, ArrayList errors, ExecutorService executorService) {
        AtomicBoolean done = new AtomicBoolean(false);
        AtomicInteger receivedCount = new AtomicInteger();
        AtomicInteger inProgressBatch = new AtomicInteger();
        int batch = 100;
        ExecutorService commitExecutor = Executors.newCachedThreadPool();
        Runnable consumerTask = () -> {
            Connection toCloseOnError = null;
            while (!done.get() && receivedCount.get() < 20 * numMessages) {
                try {
                    Connection consumerConnection = exFact.createConnection();
                    try {
                        int i;
                        toCloseOnError = consumerConnection;
                        ((ActiveMQConnection)consumerConnection).setCloseTimeout(1);
                        consumerConnection.start();
                        Session consumerConnectionSession = consumerConnection.createSession(true, 0);
                        MessageConsumer messageConsumer = consumerConnectionSession.createConsumer((Destination)queue);
                        TextMessage messageReceived = null;
                        for (i = 0; i < 100 && (messageReceived = (TextMessage)messageConsumer.receive(2000L)) != null; ++i) {
                            receivedCount.incrementAndGet();
                            int receivedSeq = messageReceived.getIntProperty("SEQ");
                            int currentBatch = receivedSeq / 100;
                            if (i == 0 && inProgressBatch.get() != currentBatch) {
                                if (inProgressBatch.get() + 1 != currentBatch) {
                                    done.set(true);
                                    throw new AssertionError((Object)("@:" + receivedCount.get() + ", batch out of sequence, expected: " + (inProgressBatch.get() + 1) + ", but have: " + currentBatch + " @" + receivedSeq + ", Message: " + messageReceived));
                                }
                                inProgressBatch.incrementAndGet();
                                logger.info("@:" + receivedCount.get() + ", current batch increment to: " + inProgressBatch.get() + ", Received Seq: " + receivedSeq + ", Message: " + messageReceived);
                            }
                            Assertions.assertEquals((long)(100L * (long)inProgressBatch.get() + (long)i), (long)receivedSeq, (String)("@:" + receivedCount.get() + " batch out of order"));
                        }
                        if (i != 100) continue;
                        Transport transport = ((ActiveMQConnection)consumerConnection).getTransport();
                        LocalTransactionId txId = new LocalTransactionId(((ActiveMQConnection)consumerConnection).getConnectionInfo().getConnectionId(), (long)receivedCount.get());
                        TransactionInfo tx = new TransactionInfo(((ActiveMQConnection)consumerConnection).getConnectionInfo().getConnectionId(), (TransactionId)txId, 0);
                        transport.request((Object)tx);
                        MessageAck ack = new MessageAck();
                        ActiveMQMessage mqMessage = (ActiveMQMessage)messageReceived;
                        ack.setDestination(mqMessage.getDestination());
                        ack.setMessageID(mqMessage.getMessageId());
                        ack.setMessageCount(100);
                        ack.setTransactionId(tx.getTransactionId());
                        ack.setConsumerId(((ActiveMQMessageConsumer)messageConsumer).getConsumerId());
                        transport.request((Object)ack);
                        try {
                            ((TcpTransport)((ActiveMQConnection)consumerConnection).getTransport().narrow(TcpTransport.class)).stop();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    finally {
                        if (consumerConnection == null) continue;
                        consumerConnection.close();
                    }
                }
                catch (NullPointerException | ConcurrentModificationException consumerConnection) {
                }
                catch (JMSException consumerConnection) {
                }
                catch (Throwable unexpected) {
                    unexpected.printStackTrace();
                    errors.add(unexpected);
                    done.set(true);
                }
                finally {
                    if (toCloseOnError == null) continue;
                    try {
                        toCloseOnError.close();
                    }
                    catch (Throwable receivedSeq) {}
                }
            }
        };
        for (int i = 0; i < 2; ++i) {
            executorService.submit(consumerTask);
        }
        executorService.shutdown();
        try {
            Assertions.assertTrue((boolean)executorService.awaitTermination(30L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)errors.isEmpty());
        }
        catch (Throwable t) {
            errors.add(t);
        }
        finally {
            done.set(true);
            commitExecutor.shutdownNow();
            executorService.shutdownNow();
        }
        Assertions.assertTrue((boolean)errors.isEmpty(), (String)("errors: " + errors));
    }
}

