/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.ActiveMQSessionCreationException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.settings.impl.ResourceLimitSettings;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.integration.security.SecurityTest;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ResourceLimitTestWithCerts
extends ActiveMQTestBase {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ResourceLimitSettings limit = new ResourceLimitSettings();
        limit.setMaxConnections(1);
        limit.setMaxQueues(1);
        limit.setMatch(SimpleString.of((String)"first"));
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("CertLogin");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true).addResourceLimitSettings(limit), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("keyStorePath", "server-keystore.jks");
        params.put("keyStorePassword", "securepass");
        params.put("trustStorePath", "client-ca-truststore.jks");
        params.put("trustStorePassword", "securepass");
        params.put("needClientAuth", true);
        server.getConfiguration().addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params));
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("programmers", true, true, true, true, true, true, true, true, true, true, false, false));
        server.getConfiguration().putSecurityRoles("#", roles);
        server.start();
    }

    @Test
    public void testSessionLimitForUser() throws Exception {
        ClientSession extraClientSession;
        ClientSessionFactory extraClientSessionFactory;
        TransportConfiguration tc = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
        tc.getParams().put("sslEnabled", true);
        tc.getParams().put("trustStorePath", "server-ca-truststore.jks");
        tc.getParams().put("trustStorePassword", "securepass");
        tc.getParams().put("keyStorePath", "client-keystore.jks");
        tc.getParams().put("keyStorePassword", "securepass");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{tc}));
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession clientSession = cf.createSession();
        try {
            extraClientSessionFactory = locator.createSessionFactory();
            extraClientSession = extraClientSessionFactory.createSession();
            Assertions.fail((String)"creating a session factory here should fail");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof ActiveMQSessionCreationException));
        }
        clientSession.close();
        clientSession = cf.createSession();
        try {
            extraClientSessionFactory = locator.createSessionFactory();
            extraClientSession = extraClientSessionFactory.createSession();
            Assertions.fail((String)"creating a session factory here should fail");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof ActiveMQSessionCreationException));
        }
        clientSession.close();
        cf.close();
    }

    @Test
    public void testQueueLimitForUser() throws Exception {
        TransportConfiguration tc = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
        tc.getParams().put("sslEnabled", true);
        tc.getParams().put("trustStorePath", "server-ca-truststore.jks");
        tc.getParams().put("trustStorePassword", "securepass");
        tc.getParams().put("keyStorePath", "client-keystore.jks");
        tc.getParams().put("keyStorePassword", "securepass");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{tc}));
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession clientSession = cf.createSession();
        clientSession.createQueue(QueueConfiguration.of((String)"queue").setAddress("address").setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        try {
            clientSession.createQueue(QueueConfiguration.of((String)"anotherQueue").setAddress("address").setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            Assertions.fail((String)"Should have thrown an ActiveMQSecurityException");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof ActiveMQSecurityException));
        }
        clientSession.deleteQueue("queue");
        clientSession.createQueue(QueueConfiguration.of((String)"queue").setAddress("address").setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        try {
            clientSession.createQueue(QueueConfiguration.of((String)"anotherQueue").setAddress("address").setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            Assertions.fail((String)"Should have thrown an ActiveMQSecurityException");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof ActiveMQSecurityException));
        }
        try {
            clientSession.createSharedQueue(QueueConfiguration.of((String)"anotherQueue").setAddress("address").setDurable(Boolean.valueOf(false)));
            Assertions.fail((String)"Should have thrown an ActiveMQSecurityException");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof ActiveMQSecurityException));
        }
    }

    static {
        URL resource;
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = SecurityTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }
}

