/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.transports.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptor;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnector;
import org.apache.activemq.artemis.core.remoting.impl.ssl.SSLSupport;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class NettyConnectorWithHTTPUpgradeTest
extends ActiveMQTestBase {
    private Boolean useSSL = false;
    private static final SimpleString QUEUE = SimpleString.of((String)"NettyConnectorWithHTTPUpgradeTest");
    private static final int HTTP_PORT = 8789;
    private Configuration conf;
    private ActiveMQServer server;
    private ServerLocator locator;
    private String acceptorName;
    private NioEventLoopGroup bossGroup;
    private NioEventLoopGroup workerGroup;
    private String SERVER_SIDE_KEYSTORE = "server-keystore.jks";
    private String CLIENT_SIDE_TRUSTSTORE = "server-ca-truststore.jks";
    private final String PASSWORD = "securepass";

    @Parameters(name="useSSL={0}")
    public static Collection getParameters() {
        return Arrays.asList({true}, {false});
    }

    public NettyConnectorWithHTTPUpgradeTest(Boolean useSSL) {
        this.useSSL = useSSL;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        HashMap<String, Comparable<Boolean>> httpAcceptorParams = new HashMap<String, Comparable<Boolean>>();
        httpAcceptorParams.put("httpUpgradeEnabled", Boolean.valueOf(true));
        httpAcceptorParams.put("port", Integer.valueOf(8789));
        this.acceptorName = RandomUtil.randomString();
        this.conf = this.createDefaultNettyConfig().addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, httpAcceptorParams, this.acceptorName));
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.conf, (boolean)false));
        this.server.start();
        HashMap<String, Object> httpConnectorParams = new HashMap<String, Object>();
        httpConnectorParams.put("httpUpgradeEnabled", true);
        httpConnectorParams.put("port", 8789);
        if (this.useSSL.booleanValue()) {
            httpConnectorParams.put("sslEnabled", true);
            httpConnectorParams.put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
            httpConnectorParams.put("trustStorePassword", "securepass");
        }
        this.locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(NETTY_CONNECTOR_FACTORY, httpConnectorParams)});
        this.addServerLocator(this.locator);
        this.startWebServer(8789);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.stopWebServer();
        super.tearDown();
    }

    @TestTemplate
    public void sendAndReceiveOverHTTPPort() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.getBodyBuffer().writeString("sendAndReceiveOverHTTPPort");
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(QUEUE);
        session.start();
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = consumer.receive();
            Assertions.assertNotNull((Object)message2);
            Assertions.assertEquals((Object)"sendAndReceiveOverHTTPPort", (Object)message2.getBodyBuffer().readString());
            message2.acknowledge();
        }
        session.close();
    }

    @TestTemplate
    public void HTTPUpgradeConnectorUsingNormalAcceptor() throws Exception {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("httpUpgradeEnabled", true);
        long start = System.currentTimeMillis();
        this.locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(NETTY_CONNECTOR_FACTORY, params)});
        Exception e = null;
        try {
            this.createSessionFactory(this.locator);
            Assertions.fail();
        }
        catch (Exception x) {
            e = x;
        }
        Assertions.assertTrue((System.currentTimeMillis() - start < 30000L ? (byte)1 : 0) != 0);
        Assertions.assertNotNull((Object)e);
        Assertions.assertTrue((boolean)(e instanceof ActiveMQNotConnectedException));
        Assertions.assertTrue((((ActiveMQException)((Object)e)).getType() == ActiveMQExceptionType.NOT_CONNECTED ? (byte)1 : 0) != 0);
    }

    private void startWebServer(int port) throws Exception {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        final SSLContext context = this.useSSL != false ? new SSLSupport().setKeystorePath(this.SERVER_SIDE_KEYSTORE).setKeystorePassword("securepass").createContext() : null;
        ((ServerBootstrap)b.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                if (NettyConnectorWithHTTPUpgradeTest.this.useSSL.booleanValue()) {
                    SSLEngine engine = context.createSSLEngine();
                    engine.setUseClientMode(false);
                    SslHandler handler = new SslHandler(engine);
                    p.addLast("ssl", (ChannelHandler)handler);
                }
                p.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
                p.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
                p.addLast("http-upgrade-handler", (ChannelHandler)new SimpleChannelInboundHandler<Object>(){

                    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
                        if (msg instanceof HttpRequest) {
                            HttpRequest request = (HttpRequest)msg;
                            for (Map.Entry entry : request.headers()) {
                                System.out.println(entry);
                            }
                            String upgrade = request.headers().get((CharSequence)HttpHeaderNames.UPGRADE);
                            String secretKey = request.headers().get("Sec-ActiveMQRemoting-Key");
                            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
                            response.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)upgrade);
                            response.headers().set("Sec-ActiveMQRemoting-Accept", (Object)NettyConnector.createExpectedResponse((String)"CF70DEB8-70F9-4FBA-8B4F-DFC3E723B4CD", (String)secretKey));
                            ctx.writeAndFlush((Object)response);
                            ctx.pipeline().remove("decoder");
                            ctx.pipeline().remove("encoder");
                            ctx.pipeline().remove((ChannelHandler)this);
                            System.out.println("HTTP handshake sent, transferring channel");
                            NettyAcceptor acceptor = (NettyAcceptor)NettyConnectorWithHTTPUpgradeTest.this.server.getRemotingService().getAcceptor(NettyConnectorWithHTTPUpgradeTest.this.acceptorName);
                            acceptor.transfer(ctx.channel());
                        }
                    }
                });
            }

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                ctx.flush();
            }
        });
        b.bind(port).sync();
    }

    private void stopWebServer() {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }
}

