/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.client.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.Transport;

public final class UnmodifiableProxy {
    private static ArrayList<String> denylist = new ArrayList();

    private UnmodifiableProxy() {
    }

    public static Transport transportProxy(Transport target) {
        Transport wrap = UnmodifiableProxy.wrap(Transport.class, target);
        return wrap;
    }

    public static Sasl saslProxy(Sasl target) {
        return UnmodifiableProxy.wrap(Sasl.class, target);
    }

    public static Connection connectionProxy(Connection target) {
        return UnmodifiableProxy.wrap(Connection.class, target);
    }

    public static Session sessionProxy(Session target) {
        return UnmodifiableProxy.wrap(Session.class, target);
    }

    public static Delivery deliveryProxy(Delivery target) {
        return UnmodifiableProxy.wrap(Delivery.class, target);
    }

    public static Link linkProxy(Link target) {
        return UnmodifiableProxy.wrap(Link.class, target);
    }

    public static Receiver receiverProxy(Receiver target) {
        return UnmodifiableProxy.wrap(Receiver.class, target);
    }

    public static Sender senderProxy(Sender target) {
        return UnmodifiableProxy.wrap(Sender.class, target);
    }

    private static boolean isProtonType(Class<?> clazz) {
        String packageName = clazz.getPackage().getName();
        return packageName.startsWith("org.apache.qpid.proton.");
    }

    private static <T> T wrap(Class<T> type, Object target) {
        return type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (o, method, objects) -> {
            if ("toString".equals(method.getName()) && method.getParameterTypes().length == 0) {
                return "Unmodifiable proxy -> (" + method.invoke(target, objects) + ")";
            }
            if (method.getParameterTypes().length > 0) {
                throw new UnsupportedOperationException("Cannot mutate outside the Client work thread");
            }
            if (denylist.contains(method.getName())) {
                throw new UnsupportedOperationException("Cannot mutate outside the Client work thread");
            }
            Class<Object> returnType = method.getReturnType();
            try {
                Map result = method.invoke(target, objects);
                if (result == null) {
                    return null;
                }
                if (!(returnType.isPrimitive() || returnType.isArray() || Object.class.equals(returnType))) {
                    if (returnType.isAssignableFrom(ByteBuffer.class)) {
                        result = null;
                    } else if (returnType.isAssignableFrom(Map.class)) {
                        result = Collections.unmodifiableMap(result);
                    } else if (UnmodifiableProxy.isProtonType(returnType) && returnType.isInterface() && !returnType.getName().equals("org.apache.qpid.proton.amqp.transport.Source") && !returnType.getName().equals("org.apache.qpid.proton.amqp.messaging.Source") && !returnType.getName().equals("org.apache.qpid.proton.amqp.transport.Target") && !returnType.getName().equals("org.apache.qpid.proton.amqp.messaging.Target")) {
                        result = UnmodifiableProxy.wrap(returnType, result);
                    }
                }
                return result;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }));
    }

    static {
        denylist.add("close");
        denylist.add("free");
        denylist.add("open");
        denylist.add("sasl");
        denylist.add("session");
        denylist.add("close_head");
        denylist.add("close_tail");
        denylist.add("outputConsumed");
        denylist.add("process");
        denylist.add("processInput");
        denylist.add("unbind");
        denylist.add("settle");
        denylist.add("clear");
        denylist.add("detach");
        denylist.add("abort");
    }
}

