/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.activemq.artemis.wildfly.integration.recovery;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.xa.XAResource;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.service.extensions.xa.recovery.ActiveMQXAResourceWrapper;
import org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig;
import org.apache.activemq.artemis.utils.VersionLoader;
import org.jboss.activemq.artemis.wildfly.integration.WildFlyActiveMQXAResourceWrapper;
import org.jboss.activemq.artemis.wildfly.integration.recovery.WildFlyActiveMQLogger;
import org.jboss.activemq.artemis.wildfly.integration.recovery.WildFlyRecoveryDiscovery;
import org.jboss.tm.XAResourceRecovery;

public class WildFlyActiveMQRecoveryRegistry
implements XAResourceRecovery {
    private static final String PRODUCT_NAME = "ActiveMQ Artemis";
    private static final WildFlyActiveMQRecoveryRegistry theInstance = new WildFlyActiveMQRecoveryRegistry();
    private final ConcurrentHashMap<XARecoveryConfig, WildFlyRecoveryDiscovery> configSet = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, WildFlyActiveMQXAResourceWrapper> recoveries = new ConcurrentHashMap();
    private final Set<WildFlyRecoveryDiscovery> failedDiscoverySet = new HashSet<WildFlyRecoveryDiscovery>();

    private WildFlyActiveMQRecoveryRegistry() {
    }

    public XAResource[] getXAResources() {
        try {
            this.checkFailures();
            WildFlyActiveMQXAResourceWrapper[] resourceArray = new WildFlyActiveMQXAResourceWrapper[this.recoveries.size()];
            for (WildFlyActiveMQXAResourceWrapper wildFlyActiveMQXAResourceWrapper : this.recoveries.values()) {
                if (!wildFlyActiveMQXAResourceWrapper.isObsolete()) continue;
                wildFlyActiveMQXAResourceWrapper.update();
            }
            resourceArray = this.recoveries.values().toArray(resourceArray);
            if (WildFlyActiveMQLogger.LOGGER.isDebugEnabled()) {
                WildFlyActiveMQLogger.LOGGER.debug("\n=======================================================================================");
                WildFlyActiveMQLogger.LOGGER.debug("Returning the following list on getXAREsources:");
                for (Map.Entry entry : this.recoveries.entrySet()) {
                    WildFlyActiveMQLogger.LOGGER.debug("server-id=" + (String)entry.getKey() + ", value=" + entry.getValue());
                }
                WildFlyActiveMQLogger.LOGGER.debug("=======================================================================================\n");
            }
            return resourceArray;
        }
        catch (Throwable e) {
            WildFlyActiveMQLogger.LOGGER.warn(e.getMessage(), e);
            return new XAResource[0];
        }
    }

    public static WildFlyActiveMQRecoveryRegistry getInstance() {
        return theInstance;
    }

    public void register(XARecoveryConfig resourceConfig) {
        WildFlyRecoveryDiscovery newInstance = new WildFlyRecoveryDiscovery(resourceConfig);
        WildFlyRecoveryDiscovery discoveryRecord = this.configSet.putIfAbsent(resourceConfig, newInstance);
        if (discoveryRecord == null) {
            discoveryRecord = newInstance;
            discoveryRecord.start(false);
        }
        discoveryRecord.incrementUsage();
    }

    public void unRegister(XARecoveryConfig resourceConfig) {
        WildFlyRecoveryDiscovery discoveryRecord = this.configSet.get(resourceConfig);
        if (discoveryRecord != null && discoveryRecord.decrementUsage() == 0 && (discoveryRecord = this.configSet.remove(resourceConfig)) != null) {
            discoveryRecord.stop();
        }
    }

    public void stop() {
        for (WildFlyRecoveryDiscovery recoveryDiscovery : this.configSet.values()) {
            recoveryDiscovery.stop();
        }
        for (WildFlyActiveMQXAResourceWrapper wrapper : this.recoveries.values()) {
            ((ActiveMQXAResourceWrapper)wrapper.getResource()).close();
        }
        this.recoveries.clear();
        this.configSet.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failedDiscovery(WildFlyRecoveryDiscovery failedDiscovery) {
        Set<WildFlyRecoveryDiscovery> set = this.failedDiscoverySet;
        synchronized (set) {
            this.failedDiscoverySet.add(failedDiscovery);
        }
    }

    public void nodeUp(XARecoveryConfig listeningConfig, String nodeID, TransportConfiguration[] networkConfiguration, String username, String password, Map<String, String> properties) {
        XARecoveryConfig config = new XARecoveryConfig(true, networkConfiguration, username, password, properties, listeningConfig.getClientProtocolManager(), listeningConfig.getLocatorConfig());
        WildFlyActiveMQXAResourceWrapper wrapper = this.recoveries.get(nodeID);
        if (wrapper == null) {
            if (WildFlyActiveMQLogger.LOGGER.isDebugEnabled()) {
                WildFlyActiveMQLogger.LOGGER.debug(nodeID + " being registered towards " + Arrays.toString(networkConfiguration));
            }
            ActiveMQXAResourceWrapper xaResource = new ActiveMQXAResourceWrapper(new XARecoveryConfig[]{config});
            HashMap<String, Object> xaResourceProperties = new HashMap<String, Object>();
            xaResourceProperties.put("ACTIVEMQ_JNDI_ID", properties.get("JNDI_NAME"));
            xaResourceProperties.put("ACTIVEMQ_NODE_ID", nodeID);
            xaResourceProperties.put("ACTIVEMQ_PRODUCT_NAME", PRODUCT_NAME);
            xaResourceProperties.put("ACTIVEMQ_PRODUCT_VERSION", VersionLoader.getVersion().getFullVersion());
            wrapper = new WildFlyActiveMQXAResourceWrapper((XAResource)xaResource, xaResourceProperties);
            this.recoveries.put(nodeID, wrapper);
        } else if (this.isNetworkConfigurationUpdateRequired(listeningConfig.getTransportConfig(), networkConfiguration)) {
            if (WildFlyActiveMQLogger.LOGGER.isDebugEnabled()) {
                WildFlyActiveMQLogger.LOGGER.debug("Updating " + wrapper + " configuration");
            }
            wrapper.updateRecoveryConfig(config);
        }
    }

    private boolean isNetworkConfigurationUpdateRequired(TransportConfiguration[] initialNetworkConfiguration, TransportConfiguration[] networkConfiguration) {
        if (initialNetworkConfiguration.length < networkConfiguration.length) {
            return true;
        }
        if (initialNetworkConfiguration.length > networkConfiguration.length) {
            if (WildFlyActiveMQLogger.LOGGER.isDebugEnabled()) {
                WildFlyActiveMQLogger.LOGGER.debug("initialNetworkConfiguration has more elements then networkConfiguration");
            }
            return false;
        }
        for (int i = 0; i < initialNetworkConfiguration.length; ++i) {
            if (initialNetworkConfiguration[i].isSameParams(networkConfiguration[i])) continue;
            if (WildFlyActiveMQLogger.LOGGER.isDebugEnabled()) {
                WildFlyActiveMQLogger.LOGGER.debug(initialNetworkConfiguration[i] + " is different from " + networkConfiguration[i]);
            }
            return true;
        }
        if (WildFlyActiveMQLogger.LOGGER.isDebugEnabled()) {
            WildFlyActiveMQLogger.LOGGER.debug(Arrays.toString(initialNetworkConfiguration) + " is the same as " + Arrays.toString(networkConfiguration));
        }
        return false;
    }

    public void nodeDown(String nodeID) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFailures() {
        final HashSet<WildFlyRecoveryDiscovery> failures = new HashSet<WildFlyRecoveryDiscovery>();
        Set<WildFlyRecoveryDiscovery> set = this.failedDiscoverySet;
        synchronized (set) {
            failures.addAll(this.failedDiscoverySet);
            this.failedDiscoverySet.clear();
        }
        if (!failures.isEmpty()) {
            Thread t = new Thread("ActiveMQ Recovery Discovery Reinitialization"){

                @Override
                public void run() {
                    for (WildFlyRecoveryDiscovery discovery : failures) {
                        try {
                            WildFlyActiveMQLogger.LOGGER.debug("Retrying discovery " + discovery);
                            discovery.start(true);
                        }
                        catch (Throwable e) {
                            WildFlyActiveMQLogger.LOGGER.warn(e.getMessage(), e);
                        }
                    }
                }
            };
            t.start();
        }
    }

    public String toString() {
        return "WildFlyActiveMQRecoveryRegistry{configSet=" + this.configSet + ", recoveries=" + this.recoveries + ", failedDiscoverySet=" + this.failedDiscoverySet + "}";
    }
}

