/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.jboss.as.clustering.infinispan.client.ManagedRemoteCacheContainer;
import org.jboss.as.clustering.infinispan.logging.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;
import org.wildfly.clustering.infinispan.client.service.HotRodServiceDescriptor;
import org.wildfly.clustering.server.Registrar;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public enum RemoteCacheContainerServiceConfigurator implements ResourceServiceConfigurator
{
    INSTANCE;


    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String name = context.getCurrentAddressValue();
        final ServiceDependency configuration = ServiceDependency.on((UnaryServiceDescriptor)HotRodServiceDescriptor.REMOTE_CACHE_CONTAINER_CONFIGURATION, (String)name);
        final ServiceDependency loader = ServiceDependency.on((ServiceName)Services.JBOSS_SERVICE_MODULE_LOADER);
        final RemoteCacheContainerResource registrar = (RemoteCacheContainerResource)context.readResource(PathAddress.EMPTY_ADDRESS);
        Supplier<RemoteCacheManager> factory = new Supplier<RemoteCacheManager>(){

            @Override
            public RemoteCacheManager get() {
                return new RemoteCacheManager((Configuration)configuration.get(), false);
            }
        };
        Consumer<RemoteCacheManager> start = new Consumer<RemoteCacheManager>(){

            @Override
            public void accept(RemoteCacheManager manager) {
                manager.start();
                InfinispanLogger.ROOT_LOGGER.remoteCacheContainerStarted(name);
            }
        };
        Consumer<RemoteCacheManager> stop = new Consumer<RemoteCacheManager>(){

            @Override
            public void accept(RemoteCacheManager manager) {
                manager.stop();
                InfinispanLogger.ROOT_LOGGER.remoteCacheContainerStopped(name);
            }
        };
        Function<RemoteCacheManager, RemoteCacheContainer> wrapper = new Function<RemoteCacheManager, RemoteCacheContainer>(){

            @Override
            public RemoteCacheContainer apply(RemoteCacheManager manager) {
                return new ManagedRemoteCacheContainer(manager, name, (ModuleLoader)loader.get(), (Registrar<String>)registrar);
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(RemoteCacheContainerResourceDefinition.REMOTE_CACHE_CONTAINER, (Function)wrapper, (Supplier)factory).blocking()).onStart((Consumer)start)).onStop((Consumer)stop)).requires(List.of(configuration, loader))).build();
    }
}

