/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl;

import io.reactivex.rxjava3.core.Flowable;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.reactive.RxJavaInterop;
import org.infinispan.reactive.publisher.impl.ClusterPublisherManager;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.reactive.publisher.impl.LocalPublisherManager;
import org.infinispan.reactive.publisher.impl.Notifications;
import org.infinispan.reactive.publisher.impl.SegmentAwarePublisherSupplier;
import org.infinispan.reactive.publisher.impl.SegmentPublisherSupplier;
import org.infinispan.reactive.publisher.impl.commands.reduction.PublisherResult;
import org.reactivestreams.Publisher;

@Scope(value=Scopes.NAMED_CACHE)
public class LocalClusterPublisherManagerImpl<K, V>
implements ClusterPublisherManager<K, V> {
    @Inject
    LocalPublisherManager<K, V> localPublisherManager;
    @Inject
    Configuration cacheConfiguration;
    @Inject
    KeyPartitioner keyPartitioner;
    @Inject
    ComponentRegistry componentRegistry;
    private int maxSegment;

    @Start
    public void start() {
        this.maxSegment = Configurations.needSegments(this.cacheConfiguration) ? this.cacheConfiguration.clustering().hash().numSegments() : 1;
    }

    static <K, V> Flowable<CacheEntry<K, V>> entryPublisherFromContext(InvocationContext ctx, IntSet segments, KeyPartitioner keyPartitioner, Set<K> keysToInclude) {
        Flowable flowable = Flowable.fromPublisher(ctx.publisher());
        if (segments == null && keysToInclude == null) {
            return flowable;
        }
        return flowable.filter(entry -> !(keysToInclude != null && !keysToInclude.contains(entry.getKey()) || segments != null && !segments.contains(keyPartitioner.getSegment(entry.getKey()))));
    }

    static <K, V> Flowable<SegmentPublisherSupplier.Notification<CacheEntry<K, V>>> notificationPublisherFromContext(InvocationContext ctx, IntSet segments, KeyPartitioner keyPartitioner, Set<K> keysToInclude) {
        return Flowable.fromPublisher(ctx.publisher()).mapOptional(ce -> {
            Object key = ce.getKey();
            if (keysToInclude == null || keysToInclude.contains(key)) {
                int segment = keyPartitioner.getSegment(key);
                if (segments == null || segments.contains(segment)) {
                    return Optional.of(Notifications.value(ce, segment));
                }
            }
            return Optional.empty();
        });
    }

    IntSet handleNullSegments(IntSet segments) {
        return segments != null ? segments : IntSets.immutableRangeSet((int)this.maxSegment);
    }

    @Override
    public <R> CompletionStage<R> keyReduction(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, InvocationContext invocationContext, long explicitFlags, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<K>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        if (transformer instanceof InjectableComponent) {
            ((InjectableComponent)((Object)transformer)).inject(this.componentRegistry);
        }
        if (finalizer instanceof InjectableComponent) {
            ((InjectableComponent)((Object)finalizer)).inject(this.componentRegistry);
        }
        if (invocationContext == null || invocationContext.lookedUpEntriesCount() == 0) {
            return this.localPublisherManager.keyReduction(parallelPublisher, this.handleNullSegments(segments), keysToInclude, null, explicitFlags, DeliveryGuarantee.AT_MOST_ONCE, transformer, finalizer).thenApply(PublisherResult::getResult);
        }
        CompletionStage<Object> stage = this.localPublisherManager.keyReduction(parallelPublisher, this.handleNullSegments(segments), keysToInclude, invocationContext.getLookedUpEntries().keySet(), explicitFlags, DeliveryGuarantee.AT_MOST_ONCE, transformer, finalizer).thenApply(PublisherResult::getResult);
        Flowable entryFlowable = LocalClusterPublisherManagerImpl.entryPublisherFromContext(invocationContext, segments, this.keyPartitioner, keysToInclude).map(RxJavaInterop.entryToKeyFunction());
        return transformer.apply((Publisher<K>)entryFlowable).thenCombine(stage, RxJavaInterop.combinedBiFunction()).thenCompose(finalizer);
    }

    @Override
    public <R> CompletionStage<R> entryReduction(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, InvocationContext invocationContext, long explicitFlags, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<CacheEntry<K, V>>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        if (transformer instanceof InjectableComponent) {
            ((InjectableComponent)((Object)transformer)).inject(this.componentRegistry);
        }
        if (finalizer instanceof InjectableComponent) {
            ((InjectableComponent)((Object)finalizer)).inject(this.componentRegistry);
        }
        if (invocationContext == null || invocationContext.lookedUpEntriesCount() == 0) {
            return this.localPublisherManager.entryReduction(parallelPublisher, this.handleNullSegments(segments), keysToInclude, null, explicitFlags, DeliveryGuarantee.AT_MOST_ONCE, transformer, finalizer).thenApply(PublisherResult::getResult);
        }
        CompletionStage<Object> stage = this.localPublisherManager.entryReduction(parallelPublisher, this.handleNullSegments(segments), keysToInclude, invocationContext.getLookedUpEntries().keySet(), explicitFlags, DeliveryGuarantee.AT_MOST_ONCE, transformer, finalizer).thenApply(PublisherResult::getResult);
        Flowable<CacheEntry<K, V>> entryFlowable = LocalClusterPublisherManagerImpl.entryPublisherFromContext(invocationContext, segments, this.keyPartitioner, keysToInclude);
        return transformer.apply((Publisher<CacheEntry<K, V>>)entryFlowable).thenCombine(stage, RxJavaInterop.combinedBiFunction()).thenCompose(finalizer);
    }

    @Override
    public <R> SegmentPublisherSupplier<R> keyPublisher(final IntSet segments, final Set<K> keysToInclude, final InvocationContext invocationContext, long explicitFlags, DeliveryGuarantee deliveryGuarantee, int batchSize, final Function<? super Publisher<K>, ? extends Publisher<R>> transformer) {
        if (transformer instanceof InjectableComponent) {
            ((InjectableComponent)((Object)transformer)).inject(this.componentRegistry);
        }
        if (invocationContext == null || invocationContext.lookedUpEntriesCount() == 0) {
            return this.localPublisherManager.keyPublisher(this.handleNullSegments(segments), keysToInclude, null, explicitFlags, DeliveryGuarantee.AT_MOST_ONCE, transformer);
        }
        Set<Object> contextKeys = invocationContext.getLookedUpEntries().keySet();
        final SegmentAwarePublisherSupplier cachePublisher = this.localPublisherManager.keyPublisher(this.handleNullSegments(segments), keysToInclude, contextKeys, explicitFlags, DeliveryGuarantee.AT_MOST_ONCE, transformer);
        return new SegmentPublisherSupplier<R>(){

            @Override
            public Publisher<SegmentPublisherSupplier.Notification<R>> publisherWithSegments() {
                Flowable contextFlowable = LocalClusterPublisherManagerImpl.notificationPublisherFromContext(invocationContext, segments, LocalClusterPublisherManagerImpl.this.keyPartitioner, keysToInclude);
                return Flowable.concat((Publisher)contextFlowable.concatMap(notification -> Flowable.fromPublisher((Publisher)((Publisher)transformer.apply(Flowable.just(((CacheEntry)notification.value()).getKey())))).map(r -> Notifications.value(r, notification.valueSegment()))), cachePublisher.publisherWithSegments());
            }

            @Override
            public Publisher<R> publisherWithoutSegments() {
                Flowable contextFlowable = LocalClusterPublisherManagerImpl.entryPublisherFromContext(invocationContext, segments, LocalClusterPublisherManagerImpl.this.keyPartitioner, keysToInclude).map(RxJavaInterop.entryToKeyFunction());
                return Flowable.concat((Publisher)((Publisher)transformer.apply(contextFlowable)), cachePublisher.publisherWithoutSegments());
            }
        };
    }

    @Override
    public <R> SegmentPublisherSupplier<R> entryPublisher(final IntSet segments, final Set<K> keysToInclude, final InvocationContext invocationContext, long explicitFlags, DeliveryGuarantee deliveryGuarantee, int batchSize, final Function<? super Publisher<CacheEntry<K, V>>, ? extends Publisher<R>> transformer) {
        if (transformer instanceof InjectableComponent) {
            ((InjectableComponent)((Object)transformer)).inject(this.componentRegistry);
        }
        if (invocationContext == null || invocationContext.lookedUpEntriesCount() == 0) {
            return this.localPublisherManager.entryPublisher(this.handleNullSegments(segments), keysToInclude, null, explicitFlags, DeliveryGuarantee.AT_MOST_ONCE, transformer);
        }
        Set<Object> contextKeys = invocationContext.getLookedUpEntries().keySet();
        final SegmentAwarePublisherSupplier cachePublisher = this.localPublisherManager.entryPublisher(this.handleNullSegments(segments), keysToInclude, contextKeys, explicitFlags, DeliveryGuarantee.AT_MOST_ONCE, transformer);
        return new SegmentPublisherSupplier<R>(){

            @Override
            public Publisher<SegmentPublisherSupplier.Notification<R>> publisherWithSegments() {
                Flowable entryFlowable = LocalClusterPublisherManagerImpl.notificationPublisherFromContext(invocationContext, segments, LocalClusterPublisherManagerImpl.this.keyPartitioner, keysToInclude);
                Flowable contextFlowable = entryFlowable.concatMap(notification -> Flowable.fromPublisher((Publisher)((Publisher)transformer.apply(Flowable.just((Object)((CacheEntry)notification.value()))))).map(r -> Notifications.value(r, notification.valueSegment())));
                return Flowable.concat((Publisher)contextFlowable, cachePublisher.publisherWithSegments());
            }

            @Override
            public Publisher<R> publisherWithoutSegments() {
                Flowable entryFlowable = LocalClusterPublisherManagerImpl.entryPublisherFromContext(invocationContext, segments, LocalClusterPublisherManagerImpl.this.keyPartitioner, keysToInclude);
                return Flowable.concat((Publisher)((Publisher)transformer.apply(entryFlowable)), cachePublisher.publisherWithoutSegments());
            }
        };
    }

    @Override
    public CompletionStage<Long> sizePublisher(IntSet segments, InvocationContext ctx, long flags) {
        return this.localPublisherManager.sizePublisher(segments, flags);
    }
}

