/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.wildfly.clustering.context.Context;
import org.wildfly.common.function.Functions;

public interface ContextReference<C>
extends Supplier<C>,
Consumer<C> {
    public static <C> ContextReference<C> fromThreadLocal(final ThreadLocal<C> threadLocal) {
        return new ContextReference<C>(){

            @Override
            public C get() {
                return threadLocal.get();
            }

            @Override
            public void accept(C value) {
                threadLocal.set(value);
            }
        };
    }

    default public Supplier<Context> provide(final C target) {
        return target != null ? new Supplier<Context>(){

            @Override
            public Context get() {
                final Object existing = ContextReference.this.get();
                if (existing == target) {
                    return Context.EMPTY;
                }
                ContextReference.this.accept(target);
                return new Context(){

                    @Override
                    public void close() {
                        ContextReference.this.accept(existing);
                    }
                };
            }
        } : Functions.constantSupplier((Object)Context.EMPTY);
    }
}

