/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonArrayAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.gson.impl.UnexpectedJsonElementTypeException;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.spi.ProjectionAccumulator;

abstract class AccumulatingSourceExtractor<E, V, A, P>
implements ElasticsearchSearchProjection.Extractor<A, P> {
    static final JsonArrayAccessor REQUEST_SOURCE_ACCESSOR = JsonAccessor.root().property("_source").asArray();
    private final String[] fieldPathComponents;
    final ProjectionAccumulator<E, V, A, P> accumulator;

    public AccumulatingSourceExtractor(String[] fieldPathComponents, ProjectionAccumulator<E, V, A, P> accumulator) {
        this.fieldPathComponents = fieldPathComponents;
        this.accumulator = accumulator;
    }

    @Override
    public final A extract(ProjectionHitMapper<?> projectionHitMapper, JsonObject hit, JsonObject source, ProjectionExtractContext context) {
        Object accumulated = this.accumulator.createInitial();
        accumulated = this.collect(projectionHitMapper, hit, source, context, accumulated, 0);
        return (A)accumulated;
    }

    private A collect(ProjectionHitMapper<?> projectionHitMapper, JsonObject hit, JsonObject parent, ProjectionExtractContext context, A accumulated, int currentPathComponentIndex) {
        if (parent == null) {
            return accumulated;
        }
        JsonElement child = parent.get(this.fieldPathComponents[currentPathComponentIndex]);
        if (currentPathComponentIndex == this.fieldPathComponents.length - 1) {
            return this.collectTargetField(projectionHitMapper, hit, child, context, accumulated);
        }
        if (child == null || child.isJsonNull()) {
            return accumulated;
        }
        if (child.isJsonArray()) {
            for (JsonElement childElement : child.getAsJsonArray()) {
                JsonObject childElementAsObject = this.toJsonObject(childElement, currentPathComponentIndex);
                accumulated = this.collect(projectionHitMapper, hit, childElementAsObject, context, accumulated, currentPathComponentIndex + 1);
            }
            return accumulated;
        }
        JsonObject childAsObject = this.toJsonObject(child, currentPathComponentIndex);
        return this.collect(projectionHitMapper, hit, childAsObject, context, accumulated, currentPathComponentIndex + 1);
    }

    private A collectTargetField(ProjectionHitMapper<?> projectionHitMapper, JsonObject hit, JsonElement fieldValue, ProjectionExtractContext context, A accumulated) {
        if (fieldValue == null) {
            return accumulated;
        }
        if (fieldValue.isJsonNull()) {
            return (A)this.accumulator.accumulate(accumulated, this.extract(projectionHitMapper, hit, fieldValue, context));
        }
        if (!this.canDecodeArrays() && fieldValue.isJsonArray()) {
            for (JsonElement childElement : fieldValue.getAsJsonArray()) {
                accumulated = this.accumulator.accumulate(accumulated, this.extract(projectionHitMapper, hit, childElement, context));
            }
            return accumulated;
        }
        return (A)this.accumulator.accumulate(accumulated, this.extract(projectionHitMapper, hit, fieldValue, context));
    }

    protected abstract E extract(ProjectionHitMapper<?> var1, JsonObject var2, JsonElement var3, ProjectionExtractContext var4);

    protected abstract boolean canDecodeArrays();

    private JsonObject toJsonObject(JsonElement childElement, int currentPathComponentIndex) {
        if (childElement == null || childElement.isJsonNull()) {
            return null;
        }
        if (!JsonElementTypes.OBJECT.isInstance(childElement)) {
            throw new UnexpectedJsonElementTypeException(Arrays.stream(this.fieldPathComponents, 0, currentPathComponentIndex + 1).collect(Collectors.joining(".")), JsonElementTypes.OBJECT, childElement);
        }
        return childElement.getAsJsonObject();
    }
}

