/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AmqpFlowControlFailOrdinaryTests
extends JMSClientTestSupport {
    @Override
    protected void configureAddressPolicy(ActiveMQServer server) {
        AddressSettings addressSettings = (AddressSettings)server.getAddressSettingsRepository().getMatch("#");
        addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL);
        addressSettings.setMaxSizeBytes(1000L);
        server.getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMessagesNotSent() throws Exception {
        AmqpClient client = this.createAmqpClient(this.getBrokerAmqpConnectionURI());
        int messagesSent = 0;
        try (AmqpConnection connection = client.connect();){
            int i;
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            boolean rejected = false;
            for (int i2 = 0; i2 < 1000; ++i2) {
                AmqpMessage message = new AmqpMessage();
                byte[] payload = new byte[10];
                message.setBytes(payload);
                try {
                    sender.send(message);
                    ++messagesSent;
                    continue;
                }
                catch (IOException e) {
                    rejected = true;
                    break;
                }
            }
            Assertions.assertTrue((boolean)rejected);
            rejected = false;
            AmqpSession session2 = connection.createSession();
            AmqpReceiver receiver = session2.createReceiver(this.getQueueName());
            receiver.flow(messagesSent);
            for (i = 0; i < messagesSent; ++i) {
                AmqpMessage receive = receiver.receive(5L, TimeUnit.SECONDS);
                Assertions.assertNotNull((Object)receive);
                receive.accept();
            }
            receiver.close();
            session2.close();
            for (i = 0; i < 1000; ++i) {
                AmqpMessage message = new AmqpMessage();
                byte[] payload = new byte[100];
                message.setBytes(payload);
                try {
                    sender.send(message);
                    continue;
                }
                catch (IOException e) {
                    rejected = true;
                    break;
                }
            }
            Assertions.assertTrue((boolean)rejected);
        }
    }
}

