/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnector;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NettyConnectorTest
extends ActiveMQTestBase {
    private ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, this.createDefaultNettyConfig());
        this.server.start();
    }

    @Test
    public void testConnectionTimeoutConfig() throws Exception {
        int timeout = 23456;
        TransportConfiguration transport = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
        transport.getParams().put("connect-timeout-millis", 23456);
        ServerLocator locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{transport});
        ClientSessionFactoryImpl factory = (ClientSessionFactoryImpl)locator.createSessionFactory();
        NettyConnector connector = (NettyConnector)factory.getConnector();
        Bootstrap bootstrap = connector.getBootStrap();
        Assertions.assertEquals((int)23456, (int)bootstrap.register().channel().config().getConnectTimeoutMillis());
        factory.close();
        locator.close();
    }

    @Test
    public void testConnectionHttpHeaders() throws Exception {
        TransportConfiguration transport = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
        transport.getParams().put("httpEnabled", true);
        transport.getParams().put("nettyHttpHeader.accept", "text/html,application/xhtml+xml,application/xml");
        transport.getParams().put("nettyHttpHeader.Accept-Encoding", "gzip,deflate");
        transport.getParams().put("nettyHttpHeader.Accept-Language", "en-us,en;q=0.5");
        try (ServerLocator locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{transport});){
            ClientSessionFactoryImpl factory = (ClientSessionFactoryImpl)locator.createSessionFactory();
            NettyConnector connector = (NettyConnector)factory.getConnector();
            Bootstrap bootstrap = connector.getBootStrap();
            ChannelPipeline pipeline = bootstrap.register().channel().pipeline();
            pipeline.flush();
            Wait.assertTrue((String)"HttpHandler is null!", () -> pipeline.get(NettyConnector.HttpHandler.class) != null, (long)500L, (long)25L);
            ChannelHandler httpHandler = pipeline.get(NettyConnector.HttpHandler.class);
            Method getHeadersMethod = httpHandler.getClass().getMethod("getHeaders", null);
            getHeadersMethod.setAccessible(true);
            Map headers = (Map)getHeadersMethod.invoke((Object)httpHandler, (Object[])null);
            Assertions.assertEquals((int)3, (int)headers.size());
            Assertions.assertTrue((boolean)headers.containsKey("accept"));
            Assertions.assertEquals((Object)"text/html,application/xhtml+xml,application/xml", headers.get("accept"));
            Assertions.assertTrue((boolean)headers.containsKey("Accept-Encoding"));
            Assertions.assertEquals((Object)"gzip,deflate", headers.get("Accept-Encoding"));
            Assertions.assertTrue((boolean)headers.containsKey("Accept-Language"));
            Assertions.assertEquals((Object)"en-us,en;q=0.5", headers.get("Accept-Language"));
            Assertions.assertFalse((boolean)headers.containsKey("test"));
            factory.close();
        }
    }
}

