/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5.spec;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class MessageReceiptTests
extends MQTT5TestSupport {
    @Test
    @Timeout(value=60L)
    public void testMessageReceipt() throws Exception {
        int i;
        final String TOPIC = RandomUtil.randomString();
        String CONSUMER_ID = "consumer";
        int CONSUMER_COUNT = 25;
        MqttClient[] consumers = new MqttClient[25];
        final CountDownLatch latch = new CountDownLatch(25);
        for (int i2 = 0; i2 < 25; ++i2) {
            MqttClient consumer;
            consumers[i2] = consumer = this.createPahoClient("consumer" + i2);
            consumer.connect();
            final int finalI = i2;
            consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

                @Override
                public void messageArrived(String incomingTopic, MqttMessage message) throws Exception {
                    System.out.println("=== Message: " + message + " from: " + incomingTopic);
                    Assertions.assertEquals((Object)(TOPIC + finalI), (Object)incomingTopic);
                    Assertions.assertEquals((Object)("hello" + finalI), (Object)new String(message.getPayload()));
                    latch.countDown();
                }
            });
            consumer.subscribe(TOPIC + i2, 0);
        }
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        for (i = 0; i < 25; ++i) {
            producer.publish(TOPIC + i, ("hello" + i).getBytes(), 0, false);
        }
        Wait.assertEquals((Long)25L, () -> {
            int totalMessagesAdded = 0;
            for (int i = 0; i < 25; ++i) {
                totalMessagesAdded = (int)((long)totalMessagesAdded + this.getSubscriptionQueue(TOPIC + i, "consumer" + i).getMessagesAdded());
            }
            return totalMessagesAdded;
        }, (long)2000L, (long)100L);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latch.await(30L, TimeUnit.SECONDS));
        for (i = 0; i < 25; ++i) {
            consumers[i].disconnect();
            consumers[i].close();
        }
    }
}

