/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.management.impl.ActiveMQServerControlImpl;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ResizeDuplicateCacheTest
extends ActiveMQTestBase {
    @Test
    public void testReloadCache() throws Exception {
        this.internalReloadCache(false, null);
    }

    @Test
    public void testReloadCacheAdditionalSettings() throws Exception {
        this.internalReloadCache(true, null);
    }

    @Test
    public void testReloadCacheAdditionalSettingsValueSet() throws Exception {
        this.internalReloadCache(true, 50000);
    }

    public void internalReloadCache(boolean additionalSettings, Integer preExistingCacheValue) throws Exception {
        int duplicateSize = 30;
        SimpleString randomString = RandomUtil.randomSimpleString();
        ActiveMQServer server = this.createServer(true, false);
        server.start();
        ActiveMQServerControlImpl serverControl = server.getActiveMQServerControl();
        if (additionalSettings) {
            AddressSettings settings = new AddressSettings().setDefaultRingSize(3333L);
            if (preExistingCacheValue != null) {
                settings.setIDCacheSize(preExistingCacheValue.intValue());
            }
            serverControl.addAddressSettings(randomString.toString(), settings.toJSON());
            String json = serverControl.getAddressSettingsAsJSON(randomString.toString());
            AddressSettings settingsFromJson = AddressSettings.fromJSON((String)json);
            Assertions.assertEquals((Integer)preExistingCacheValue, (Integer)settingsFromJson.getIDCacheSize());
            Assertions.assertEquals((long)3333L, (long)settingsFromJson.getDefaultRingSize());
        }
        DuplicateIDCache duplicateIDCache = server.getPostOffice().getDuplicateIDCache(randomString, duplicateSize);
        for (int i = 0; i < duplicateSize * 2; ++i) {
            duplicateIDCache.addToCache(("a" + i).getBytes(StandardCharsets.UTF_8));
        }
        server.stop();
        server = this.createServer(true, false);
        server.start();
        serverControl = server.getActiveMQServerControl();
        duplicateIDCache = server.getPostOffice().getDuplicateIDCache(randomString, duplicateSize);
        Assertions.assertEquals((int)duplicateSize, (int)duplicateIDCache.getSize());
        server.getStorageManager().getMessageJournal().scheduleCompactAndBlock(10000);
        HashMap<Integer, AtomicInteger> records = this.countJournal(server.getConfiguration());
        AtomicInteger duplicateRecordsCount = records.get(37);
        Assertions.assertNotNull((Object)duplicateRecordsCount);
        Assertions.assertEquals((int)duplicateSize, (int)duplicateRecordsCount.get());
        if (additionalSettings) {
            String json = serverControl.getAddressSettingsAsJSON(randomString.toString());
            AddressSettings settingsFromJson = AddressSettings.fromJSON((String)json);
            Assertions.assertEquals((Integer)duplicateSize, (Integer)settingsFromJson.getIDCacheSize());
            Assertions.assertEquals((long)3333L, (long)settingsFromJson.getDefaultRingSize());
        }
        server.stop();
    }
}

