/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.replication;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReplicationOrderTest
extends FailoverTestBase {
    public static final int NUM = 300;

    @Test
    public void testMixedPersistentAndNonPersistentMessagesOrderWithReplicatedBackup() throws Exception {
        this.doTestMixedPersistentAndNonPersistentMessagesOrderWithReplicatedBackup(false);
    }

    @Test
    public void testTxMixedPersistentAndNonPersistentMessagesOrderWithReplicatedBackup() throws Exception {
        this.doTestMixedPersistentAndNonPersistentMessagesOrderWithReplicatedBackup(true);
    }

    private void doTestMixedPersistentAndNonPersistentMessagesOrderWithReplicatedBackup(boolean transactional) throws Exception {
        String address = RandomUtil.randomString();
        String queue = RandomUtil.randomString();
        ServerLocator locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.getConnectorTransportConfiguration(true)});
        this.addServerLocator(locator);
        locator.setBlockOnNonDurableSend(false).setBlockOnDurableSend(false);
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = null;
        session = transactional ? csf.createSession(false, false) : csf.createSession(true, true);
        this.addClientSession(session);
        session.createQueue(QueueConfiguration.of((String)queue).setAddress(address));
        ClientProducer producer = session.createProducer(address);
        boolean durable = false;
        for (int i = 0; i < 300; ++i) {
            ClientMessage msg = session.createMessage(durable);
            msg.putIntProperty("counter", i);
            producer.send((Message)msg);
            if (transactional) {
                if (i % 10 != 0) continue;
                session.commit();
                durable = !durable;
                continue;
            }
            durable = !durable;
        }
        if (transactional) {
            session.commit();
        }
        session.close();
        locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.getConnectorTransportConfiguration(true)}));
        csf = this.createSessionFactory(locator);
        session = csf.createSession(true, true);
        session.start();
        ClientConsumer consumer = session.createConsumer(queue);
        for (int i = 0; i < 300; ++i) {
            ClientMessage message = consumer.receive(1000L);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((int)i, (int)message.getIntProperty("counter"));
        }
        consumer.close();
        session.deleteQueue(queue);
        session.close();
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createReplicatedConfigs();
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }
}

